/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.color;

import java.util.Collection;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.color.fn.ColorFunction;
import script.imglib.math.fn.IFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RGBA
extends ColorFunction {
    private final IFunction red;
    private final IFunction green;
    private final IFunction blue;
    private final IFunction alpha;

    public RGBA(IFunction iFunction, IFunction iFunction2, IFunction iFunction3, IFunction iFunction4) {
        this.red = null == iFunction ? empty : iFunction;
        this.green = null == iFunction2 ? empty : iFunction2;
        this.blue = null == iFunction3 ? empty : iFunction3;
        this.alpha = null == iFunction4 ? empty : iFunction4;
    }

    public RGBA(Image<? extends RealType<?>> image) {
        this(new ColorFunction.Channel(image, 3), new ColorFunction.Channel(image, 2), new ColorFunction.Channel(image, 1), new ColorFunction.Channel(image, 4));
    }

    public RGBA(Object object, Object object2, Object object3, Object object4) throws Exception {
        this(RGBA.wrap(object), RGBA.wrap(object2), RGBA.wrap(object3), RGBA.wrap(object4));
    }

    public RGBA(Object object, Object object2, Object object3) throws Exception {
        this(RGBA.wrap(object), RGBA.wrap(object2), RGBA.wrap(object3), empty);
    }

    public RGBA(Object object, Object object2) throws Exception {
        this(RGBA.wrap(object), RGBA.wrap(object2), empty, empty);
    }

    public RGBA(Object object) throws Exception {
        this(RGBA.wrap(object), empty, empty, empty);
    }

    public RGBA(IFunction iFunction, int n) throws IllegalArgumentException {
        this(3 == n ? iFunction : empty, 2 == n ? iFunction : empty, 1 == n ? iFunction : empty, 4 == n ? iFunction : empty);
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("RGB: channel must be >= 1 and <= 4");
        }
    }

    public RGBA(Object object, int n) throws Exception, IllegalArgumentException {
        this(RGBA.wrap(object), n);
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("RGB: channel must be >= 1 and <= 4");
        }
    }

    @Override
    public final IFunction duplicate() throws Exception {
        return new RGBA(this.red.duplicate(), this.green.duplicate(), this.blue.duplicate(), this.alpha.duplicate());
    }

    @Override
    public final double eval() {
        return ((int)this.alpha.eval() & 0xFF) << 24 | ((int)this.red.eval() & 0xFF) << 16 | ((int)this.green.eval() & 0xFF) << 8 | (int)this.blue.eval() & 0xFF;
    }

    @Override
    public final void findCursors(Collection<Cursor<?>> collection) {
        this.alpha.findCursors(collection);
        this.red.findCursors(collection);
        this.green.findCursors(collection);
        this.blue.findCursors(collection);
    }
}

