/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.color;

import java.awt.Color;
import java.util.Collection;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.color.fn.ColorFunction;
import script.imglib.math.fn.IFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSB
extends ColorFunction {
    private final IFunction hue;
    private final IFunction saturation;
    private final IFunction brightness;

    public HSB(IFunction iFunction, IFunction iFunction2, IFunction iFunction3) {
        this.hue = null == iFunction ? empty : iFunction;
        this.saturation = null == iFunction2 ? empty : iFunction2;
        this.brightness = null == iFunction3 ? empty : iFunction3;
    }

    public HSB(Image<? extends RealType<?>> image) {
        this(new ColorFunction.Channel(image, 3), new ColorFunction.Channel(image, 2), new ColorFunction.Channel(image, 1));
    }

    public HSB(Object object, Object object2, Object object3) throws Exception {
        this(HSB.wrap(object), HSB.wrap(object2), HSB.wrap(object3));
    }

    public HSB(Object object, Object object2) throws Exception {
        this(HSB.wrap(object), HSB.wrap(object2), empty);
    }

    public HSB(Object object) throws Exception {
        this(HSB.wrap(object), empty, empty);
    }

    public HSB(IFunction iFunction, int n) throws IllegalArgumentException {
        this(3 == n ? iFunction : empty, 2 == n ? iFunction : empty, 1 == n ? iFunction : empty);
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("HSB: channel must be >= 1 and <= 3");
        }
    }

    public HSB(Object object, int n) throws Exception, IllegalArgumentException {
        this(HSB.wrap(object), n);
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("RGB: channel must be >= 1 and <= 3");
        }
    }

    @Override
    public final IFunction duplicate() throws Exception {
        return new HSB(this.hue.duplicate(), this.saturation.duplicate(), this.brightness.duplicate());
    }

    @Override
    public final double eval() {
        return Color.HSBtoRGB((float)this.hue.eval(), (float)this.saturation.eval(), (float)this.brightness.eval());
    }

    @Override
    public final void findCursors(Collection<Cursor<?>> collection) {
        this.hue.findCursors(collection);
        this.saturation.findCursors(collection);
        this.brightness.findCursors(collection);
    }
}

