/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.analysis;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussian;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.function.RealTypeConverter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;
import script.imglib.algorithm.fn.AlgorithmUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoGPeaks<N extends RealType<N>>
extends ArrayList<float[]> {
    private static final long serialVersionUID = 7614417748092214062L;
    private final List<DifferenceOfGaussianPeak<FloatType>> peaks;

    public DoGPeaks(Object object, Number number, Number number2, Number number3, Number number4) throws Exception {
        this(AlgorithmUtil.wrapS(object), number, number2, number3, number4);
    }

    public DoGPeaks(Image<N> image, Number number, Number number2, Number number3, Number number4) throws Exception {
        this(image, AlgorithmUtil.asArray(image.getNumDimensions(), number.doubleValue()), AlgorithmUtil.asArray(image.getNumDimensions(), number2.doubleValue()), number3, number4);
    }

    public DoGPeaks(Object object, List<Number> list, List<Number> list2, Number number, Number number2) throws Exception {
        this(object, AlgorithmUtil.asDoubleArray(list), AlgorithmUtil.asDoubleArray(list2), number, number2);
    }

    public DoGPeaks(Object object, float[] fArray, float[] fArray2, Number number, Number number2) throws Exception {
        this(object, AlgorithmUtil.asDoubleArray(fArray), AlgorithmUtil.asDoubleArray(fArray2), number, number2);
    }

    public DoGPeaks(Object object, double[] dArray, double[] dArray2, Number number, Number number2) throws Exception {
        this(AlgorithmUtil.wrapS(object), dArray, dArray2, number, number2);
    }

    public DoGPeaks(Image<N> image, double[] dArray, double[] dArray2, Number number, Number number2) throws Exception {
        DifferenceOfGaussian differenceOfGaussian = new DifferenceOfGaussian(image, new ImageFactory((Type)new FloatType(), (ContainerFactory)new ArrayContainerFactory()), (Converter)new RealTypeConverter(), (OutOfBoundsStrategyFactory)new OutOfBoundsStrategyMirrorFactory(), dArray, dArray2, (NumericType)new FloatType(number.floatValue()), (NumericType)new FloatType(number2.floatValue()));
        if (!differenceOfGaussian.process()) {
            throw new Exception("Could not process DifferenceOfGaussian: " + differenceOfGaussian.getErrorMessage());
        }
        this.peaks = differenceOfGaussian.getPeaks();
        for (DifferenceOfGaussianPeak<FloatType> differenceOfGaussianPeak : this.peaks) {
            this.add(differenceOfGaussianPeak.getSubPixelPosition());
        }
    }

    public List<DifferenceOfGaussianPeak<FloatType>> getPeaks() {
        return new ArrayList<DifferenceOfGaussianPeak<FloatType>>(this.peaks);
    }

    public List<Object> asPoints(float[] fArray) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.isEmpty()) {
            return arrayList;
        }
        int n = ((float[])this.get(0)).length;
        if (n < 2 || n > 4) {
            throw new Exception("Dimensions of the peak coordinates are not 2, 3 or 4. Use getDoGPeaks() instead.");
        }
        if (fArray.length != n) {
            throw new IllegalArgumentException("scalingFactor dimensions does not match with the dimensions of the peaks.");
        }
        switch (n) {
            case 2: {
                for (float[] fArray2 : this) {
                    arrayList.add(new Point2f(DoGPeaks.scaled(fArray2, fArray)));
                }
                break;
            }
            case 3: {
                for (float[] fArray3 : this) {
                    arrayList.add(new Point3f(DoGPeaks.scaled(fArray3, fArray)));
                }
                break;
            }
            case 4: {
                for (float[] fArray4 : this) {
                    arrayList.add(new Point4f(DoGPeaks.scaled(fArray4, fArray)));
                }
                break;
            }
        }
        return arrayList;
    }

    public List<Object> asPoints() throws Exception {
        return this.asPoints(1);
    }

    public List<Object> asPoints(Number number) throws Exception {
        if (this.isEmpty()) {
            return new ArrayList<Object>();
        }
        float[] fArray = new float[((float[])this.get(0)).length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = number.floatValue();
        }
        return this.asPoints(fArray);
    }

    private static final float[] scaled(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray3[i] = fArray[i] * fArray2[i];
        }
        return fArray3;
    }
}

