/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm.fn;

import mpicbg.imglib.algorithm.roi.StatisticalOperation;
import mpicbg.imglib.algorithm.roi.StructuringElement;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.algorithm.fn.AlgorithmUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Morph<T extends RealType<T>>
extends Image<T> {
    public static final Shape BALL = Shape.BALL;
    public static final Shape CUBE = Shape.CUBE;
    public static final Shape BAR = Shape.BAR;

    private Morph(Image<T> image) {
        super(image.getContainer(), image.createType());
    }

    public Morph(Object object, Class<?> clazz, Shape shape, int n, int n2, float f) throws Exception {
        this(Morph.process(clazz, object, shape, n, n2, f));
    }

    private static final <R extends RealType<R>> Image<R> process(Class<?> clazz, Object object, Shape shape, int n, int n2, float f) throws Exception {
        StructuringElement structuringElement;
        Image image = AlgorithmUtil.wrap(object);
        switch (shape) {
            case BALL: {
                structuringElement = StructuringElement.createBall((int)image.getNumDimensions(), (double)n);
                break;
            }
            case BAR: {
                structuringElement = StructuringElement.createBar((int)image.getNumDimensions(), (int)n, (int)n2);
                break;
            }
            default: {
                structuringElement = StructuringElement.createCube((int)image.getNumDimensions(), (int)n);
            }
        }
        RealType realType = (RealType)image.createType();
        realType.setReal(f);
        StatisticalOperation statisticalOperation = (StatisticalOperation)clazz.getConstructor(Image.class, StructuringElement.class, OutOfBoundsStrategyFactory.class).newInstance(image, structuringElement, new OutOfBoundsStrategyValueFactory((Type)realType));
        if (!statisticalOperation.process()) {
            throw new Exception(statisticalOperation.getClass().getSimpleName() + ": " + statisticalOperation.getErrorMessage());
        }
        return statisticalOperation.getResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Shape {
        BALL,
        CUBE,
        BAR;

    }
}

