/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm.fn;

import mpicbg.imglib.algorithm.transformation.ImageTransform;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.linear.LinearInterpolatorFactory;
import mpicbg.imglib.interpolation.nearestneighbor.NearestNeighborInterpolatorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.models.AffineModel2D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.InvertibleCoordinateTransform;
import script.imglib.color.Alpha;
import script.imglib.color.Blue;
import script.imglib.color.Green;
import script.imglib.color.RGBA;
import script.imglib.color.Red;
import script.imglib.math.Compute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAffine3D<T extends NumericType<T>>
extends Image<T> {
    public static final Mode LINEAR = Mode.LINEAR;
    public static final Mode NEAREST_NEIGHBOR = Mode.NEAREST_NEIGHBOR;
    public static final Mode BEST = Mode.LINEAR;

    public AbstractAffine3D(Image<T> image, float[] fArray, Mode mode, Number number) throws Exception {
        this(image, fArray, mode, (OutOfBoundsStrategyFactory<T>)new OutOfBoundsStrategyValueFactory(AbstractAffine3D.withValue(image, (NumericType)image.createType(), number)));
    }

    public AbstractAffine3D(Image<T> image, float[] fArray, Mode mode, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) throws Exception {
        super(AbstractAffine3D.process(image, fArray, mode, outOfBoundsStrategyFactory).getContainer(), image.createType());
    }

    public AbstractAffine3D(Image<T> image, float f, float f2, float f3, float f4, float f5, float f6, Mode mode, Number number) throws Exception {
        this(image, new float[]{f, f2, 0.0f, f5, f3, f4, 0.0f, f6, 0.0f, 0.0f, 1.0f, 0.0f}, mode, (OutOfBoundsStrategyFactory<T>)new OutOfBoundsStrategyValueFactory(AbstractAffine3D.withValue(image, (NumericType)image.createType(), number)));
    }

    public AbstractAffine3D(Image<T> image, float f, float f2, float f3, float f4, float f5, float f6, Mode mode, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) throws Exception {
        this(image, new float[]{f, f2, 0.0f, f5, f3, f4, 0.0f, f6, 0.0f, 0.0f, 1.0f, 0.0f}, mode, outOfBoundsStrategyFactory);
    }

    private static final NumericType<?> withValue(Image<? extends NumericType<?>> image, NumericType<?> numericType, Number number) {
        NumericType numericType2 = (NumericType)image.createType();
        if (RGBALegacyType.class.isAssignableFrom(numericType2.getClass())) {
            int n = number.intValue();
            numericType2.set((Type)new RGBALegacyType(n));
        } else {
            ((RealType)numericType2).setReal(number.doubleValue());
        }
        return numericType2;
    }

    private static final <N extends NumericType<N>> Image<N> process(Image<N> image, float[] fArray, Mode mode, OutOfBoundsStrategyFactory<N> outOfBoundsStrategyFactory) throws Exception {
        if (fArray.length < 12) {
            throw new IllegalArgumentException("Affine transform in 2D requires a matrix array of 12 elements.");
        }
        Type type = image.createType();
        if (RGBALegacyType.class.isAssignableFrom(type.getClass())) {
            return AbstractAffine3D.processRGBA(image, fArray, mode, outOfBoundsStrategyFactory);
        }
        if (type instanceof RealType) {
            return AbstractAffine3D.processReal(image, fArray, mode, outOfBoundsStrategyFactory);
        }
        throw new Exception("Affine transform: cannot handle type " + type.getClass());
    }

    private static final Image<RGBALegacyType> processRGBA(Image<RGBALegacyType> image, float[] fArray, Mode mode, OutOfBoundsStrategyFactory<RGBALegacyType> outOfBoundsStrategyFactory) throws Exception {
        OutOfBoundsStrategyFactory outOfBoundsStrategyFactory2;
        OutOfBoundsStrategyFactory outOfBoundsStrategyFactory3;
        OutOfBoundsStrategyFactory outOfBoundsStrategyFactory4;
        OutOfBoundsStrategyFactory outOfBoundsStrategyFactory5;
        if (OutOfBoundsStrategyValueFactory.class.isAssignableFrom(outOfBoundsStrategyFactory.getClass())) {
            int n = ((RGBALegacyType)((OutOfBoundsStrategyValueFactory)outOfBoundsStrategyFactory).getValue()).get();
            outOfBoundsStrategyFactory5 = new OutOfBoundsStrategyValueFactory((Type)new FloatType((float)(n >> 16 & 0xFF)));
            outOfBoundsStrategyFactory4 = new OutOfBoundsStrategyValueFactory((Type)new FloatType((float)(n >> 8 & 0xFF)));
            outOfBoundsStrategyFactory3 = new OutOfBoundsStrategyValueFactory((Type)new FloatType((float)(n & 0xFF)));
            outOfBoundsStrategyFactory2 = new OutOfBoundsStrategyValueFactory((Type)new FloatType((float)(n >> 24 & 0xFF)));
        } else {
            try {
                outOfBoundsStrategyFactory5 = (OutOfBoundsStrategyFactory)outOfBoundsStrategyFactory.getClass().newInstance();
            }
            catch (Exception exception) {
                System.out.println("Affine3D for RGBA: oops -- using a black OutOfBoundsStrategyValueFactory");
                outOfBoundsStrategyFactory5 = new OutOfBoundsStrategyValueFactory((Type)new FloatType());
            }
            outOfBoundsStrategyFactory4 = outOfBoundsStrategyFactory5;
            outOfBoundsStrategyFactory3 = outOfBoundsStrategyFactory5;
            outOfBoundsStrategyFactory2 = outOfBoundsStrategyFactory5;
        }
        return new RGBA(AbstractAffine3D.processReal(Compute.inFloats(new Red(image)), fArray, mode, outOfBoundsStrategyFactory5), AbstractAffine3D.processReal(Compute.inFloats(new Green(image)), fArray, mode, outOfBoundsStrategyFactory4), AbstractAffine3D.processReal(Compute.inFloats(new Blue(image)), fArray, mode, outOfBoundsStrategyFactory3), AbstractAffine3D.processReal(Compute.inFloats(new Alpha(image)), fArray, mode, outOfBoundsStrategyFactory2)).asImage();
    }

    private static final <R extends RealType<R>> Image<R> processReal(Image<R> image, float[] fArray, Mode mode, OutOfBoundsStrategyFactory<R> outOfBoundsStrategyFactory) throws Exception {
        ImageTransform imageTransform;
        LinearInterpolatorFactory linearInterpolatorFactory;
        switch (mode) {
            case LINEAR: {
                linearInterpolatorFactory = new LinearInterpolatorFactory(outOfBoundsStrategyFactory);
                break;
            }
            case NEAREST_NEIGHBOR: {
                linearInterpolatorFactory = new NearestNeighborInterpolatorFactory(outOfBoundsStrategyFactory);
                break;
            }
            default: {
                throw new IllegalArgumentException("Scale: don't know how to scale with mode " + (Object)((Object)mode));
            }
        }
        if (2 == image.getNumDimensions()) {
            AffineModel2D affineModel2D = new AffineModel2D();
            affineModel2D.set(fArray[0], fArray[4], fArray[1], fArray[5], fArray[3], fArray[7]);
            imageTransform = new ImageTransform(image, (InvertibleCoordinateTransform)affineModel2D, (InterpolatorFactory)linearInterpolatorFactory);
        } else if (3 == image.getNumDimensions()) {
            if (fArray.length < 12) {
                throw new IllegalArgumentException("Affine transform in 3D requires a matrix array of 12 elements.");
            }
            AffineModel3D affineModel3D = new AffineModel3D();
            affineModel3D.set(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7], fArray[8], fArray[9], fArray[10], fArray[11]);
            imageTransform = new ImageTransform(image, (InvertibleCoordinateTransform)affineModel3D, (InterpolatorFactory)linearInterpolatorFactory);
            if ((double)Math.abs(fArray[10] - 1.0f) < 1.0E-6 && 0.0f == fArray[8] && 0.0f == fArray[9]) {
                int[] nArray = imageTransform.getNewImageSize();
                nArray[2] = image.getDimension(2);
                imageTransform.setNewImageSize(nArray);
            }
        } else {
            throw new Exception("Affine transform: only 2D and 3D images are supported.");
        }
        if (!imageTransform.checkInput() || !imageTransform.process()) {
            throw new Exception("Could not affine transform the image: " + imageTransform.getErrorMessage());
        }
        return imageTransform.getResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        LINEAR,
        NEAREST_NEIGHBOR;

    }
}

