/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.interpolation.linear.LinearInterpolatorFactory;
import mpicbg.imglib.interpolation.nearestneighbor.NearestNeighborInterpolatorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.algorithm.Affine3D;
import script.imglib.algorithm.fn.AbstractAffine3D;
import script.imglib.color.Alpha;
import script.imglib.color.Blue;
import script.imglib.color.Green;
import script.imglib.color.RGBA;
import script.imglib.color.Red;
import script.imglib.math.Compute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resample<N extends NumericType<N>>
extends Image<N> {
    public static final AbstractAffine3D.Mode LINEAR = Affine3D.LINEAR;
    public static final AbstractAffine3D.Mode NEAREST_NEIGHBOR = Affine3D.NEAREST_NEIGHBOR;
    public static final AbstractAffine3D.Mode BEST = Affine3D.BEST;

    public Resample(Image<N> image, Number number) throws Exception {
        this(image, Resample.asDimArray(image, number), BEST);
    }

    public Resample(Image<N> image, Number number, AbstractAffine3D.Mode mode) throws Exception {
        this(image, Resample.asDimArray(image, number), mode);
    }

    public Resample(Image<N> image, int[] nArray) throws Exception {
        this(image, nArray, BEST);
    }

    public Resample(Image<N> image, int[] nArray, AbstractAffine3D.Mode mode) throws Exception {
        super(Resample.process(image, nArray, mode).getContainer(), image.createType());
    }

    private static final int[] asDimArray(Image<?> image, Number number) {
        int[] nArray = new int[image.getNumDimensions()];
        double d = number.doubleValue();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)((double)image.getDimension(i) * d + 0.5);
        }
        return nArray;
    }

    private static final <N extends NumericType<N>> Image<N> process(Image<N> image, int[] object, AbstractAffine3D.Mode mode) throws Exception {
        Object object2;
        if (((int[])object).length != image.getNumDimensions()) {
            int n;
            object2 = new int[image.getNumDimensions()];
            for (n = 0; n < ((int[])object).length; ++n) {
                object2[n] = object[n];
            }
            while (n < image.getNumDimensions()) {
                object2[n] = image.getDimension(n);
                ++n;
            }
            object = object2;
        }
        if (RGBALegacyType.class.isAssignableFrom((object2 = image.createType()).getClass())) {
            return Resample.processRGBA(image, object, mode);
        }
        if (object2 instanceof RealType) {
            return Resample.processReal(image, object, mode);
        }
        throw new Exception("Affine transform: cannot handle type " + object2.getClass());
    }

    private static final Image<RGBALegacyType> processRGBA(Image<RGBALegacyType> image, int[] nArray, AbstractAffine3D.Mode mode) throws Exception {
        return new RGBA(Resample.processReal(Compute.inFloats(new Red(image)), nArray, mode), Resample.processReal(Compute.inFloats(new Green(image)), nArray, mode), Resample.processReal(Compute.inFloats(new Blue(image)), nArray, mode), Resample.processReal(Compute.inFloats(new Alpha(image)), nArray, mode)).asImage();
    }

    private static final <T extends RealType<T>> Image<T> processReal(Image<T> image, int[] nArray, AbstractAffine3D.Mode mode) throws Exception {
        LinearInterpolatorFactory linearInterpolatorFactory;
        Image image2 = image.getImageFactory().createImage(nArray);
        switch (mode) {
            case LINEAR: {
                linearInterpolatorFactory = new LinearInterpolatorFactory((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyMirrorFactory());
                break;
            }
            case NEAREST_NEIGHBOR: {
                linearInterpolatorFactory = new NearestNeighborInterpolatorFactory((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyMirrorFactory());
                break;
            }
            default: {
                throw new Exception("Resample: unknown mode!");
            }
        }
        Interpolator interpolator = linearInterpolatorFactory.createInterpolator(image);
        LocalizableCursor localizableCursor = image2.createLocalizableCursor();
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)image.getDimension(i) / (float)nArray[i];
        }
        int[] nArray2 = new int[nArray.length];
        float[] fArray2 = new float[nArray.length];
        while (localizableCursor.hasNext()) {
            localizableCursor.fwd();
            localizableCursor.getPosition(nArray2);
            for (int i = 0; i < nArray2.length; ++i) {
                fArray2[i] = (float)nArray2[i] * fArray[i];
            }
            interpolator.moveTo(fArray2);
            ((RealType)localizableCursor.getType()).set(interpolator.getType());
        }
        return image2;
    }
}

