/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import java.util.Collection;
import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Process
implements IFunction {
    private final Cursor<? extends RealType<?>> c;

    public Process(OutputAlgorithm<? extends RealType<?>> outputAlgorithm) throws Exception {
        this.execute((Algorithm)outputAlgorithm);
        this.c = outputAlgorithm.getResult().createCursor();
    }

    public Process(Class<Algorithm> clazz, IFunction iFunction, Object ... objectArray) throws Exception {
        this(clazz, Compute.inDoubles(iFunction), objectArray);
    }

    public Process(Class<Algorithm> clazz, Image<? extends RealType<?>> image, Object ... objectArray) throws Exception {
        Class[] classArray = new Class[1 + objectArray.length];
        Object[] objectArray2 = new Object[classArray.length];
        classArray[0] = Image.class;
        objectArray2[0] = image;
        for (int i = 1; i < classArray.length; ++i) {
            classArray[i] = objectArray[i - 1].getClass();
            objectArray2[i] = objectArray[i - 1];
        }
        Algorithm algorithm = clazz.getConstructor(classArray).newInstance(objectArray2);
        this.execute(algorithm);
        this.c = (algorithm instanceof OutputAlgorithm ? ((OutputAlgorithm)algorithm).getResult() : image).createCursor();
    }

    private final void execute(Algorithm algorithm) throws Exception {
        if (!algorithm.checkInput() || !algorithm.process()) {
            throw new Exception("Algorithm " + algorithm.getClass().getSimpleName() + " failed: " + algorithm.getErrorMessage());
        }
    }

    private Process(Cursor<? extends RealType<?>> cursor) {
        this.c = cursor;
    }

    public Image<? extends RealType<?>> getResult() {
        return this.c.getImage();
    }

    @Override
    public final IFunction duplicate() throws Exception {
        return new Process(this.c.getImage().createCursor());
    }

    @Override
    public final double eval() {
        this.c.fwd();
        return ((RealType)this.c.getType()).getRealDouble();
    }

    @Override
    public final void findCursors(Collection<Cursor<?>> collection) {
        collection.add(this.c);
    }
}

