/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import mpicbg.imglib.algorithm.math.ComputeMinMax;
import mpicbg.imglib.algorithm.math.ImageConverter;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;
import script.imglib.algorithm.fn.AbstractNormalize;
import script.imglib.color.Alpha;
import script.imglib.color.Blue;
import script.imglib.color.Green;
import script.imglib.color.RGBA;
import script.imglib.color.Red;
import script.imglib.color.fn.ColorFunction;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Normalize<N extends NumericType<N>>
extends AbstractNormalize<N> {
    public Normalize(Object object) throws Exception {
        super(Normalize.process(object));
    }

    private static final Image process(Object object) throws Exception {
        if (object instanceof ColorFunction) {
            return Normalize.processRGBA(Compute.inRGBA((ColorFunction)object));
        }
        if (object instanceof IFunction) {
            return Normalize.processReal((IFunction)object);
        }
        if (object instanceof Image) {
            if (((Image)object).createType() instanceof RGBALegacyType) {
                return Normalize.processRGBA((Image<RGBALegacyType>)((Image)object));
            }
            return Normalize.processReal((Image)object);
        }
        throw new Exception("NormalizeMinMax: don't know how to process " + object.getClass());
    }

    private static final Image<RGBALegacyType> processRGBA(Image<RGBALegacyType> image) throws Exception {
        return new RGBA(Normalize.processReal(new Red(image)), Normalize.processReal(new Green(image)), Normalize.processReal(new Blue(image)), Normalize.processReal(new Alpha(image))).asImage();
    }

    private static final Image<FloatType> processReal(IFunction iFunction) throws Exception {
        return Normalize.processReal(Compute.inFloats(iFunction));
    }

    private static final <T extends RealType<T>> Image<FloatType> processReal(Image<T> image) throws Exception {
        double d;
        double d2;
        double d3;
        ComputeMinMax computeMinMax = new ComputeMinMax(image);
        if (!computeMinMax.checkInput() || !computeMinMax.process()) {
            throw new Exception("Coult not compute min and max: " + computeMinMax.getErrorMessage());
        }
        if (0 == ((RealType)computeMinMax.getMin()).compareTo((Object)computeMinMax.getMax())) {
            return new Image(image.getContainerFactory().createContainer(image.getDimensions(), (Type)new FloatType()), (Type)new FloatType());
        }
        Image image2 = new Image(image.getContainerFactory().createContainer(image.getDimensions(), (Type)new FloatType()), (Type)new FloatType());
        ImageConverter imageConverter = new ImageConverter(image, image2, new Converter<T, FloatType>(d3 = ((RealType)computeMinMax.getMin()).getRealDouble(), d2 = (d = ((RealType)computeMinMax.getMax()).getRealDouble()) - d3){
            final /* synthetic */ double val$min;
            final /* synthetic */ double val$range;
            {
                this.val$min = d;
                this.val$range = d2;
            }

            public void convert(T t, FloatType floatType) {
                floatType.setReal((t.getRealDouble() - this.val$min) / this.val$range);
            }
        });
        if (!imageConverter.checkInput() || !imageConverter.process()) {
            throw new Exception("Could not normalize image: " + imageConverter.getErrorMessage());
        }
        return image2;
    }
}

