/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import mpicbg.imglib.algorithm.fft.FourierTransform;
import mpicbg.imglib.algorithm.fft.InverseFourierTransform;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.complex.ComplexDoubleType;
import script.imglib.algorithm.FFT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InverseFFT<T extends RealType<T>>
extends Image<T> {
    public InverseFFT(FFT<T> fFT) throws Exception {
        super(InverseFFT.process(fFT, fFT.fft).getContainer(), fFT.value.copy(), "Inverse FFT");
    }

    public InverseFFT(Image<ComplexDoubleType> image, FFT<T> fFT) throws Exception {
        super(InverseFFT.process(image, fFT.fft).getContainer(), fFT.value.copy(), "Inverse FFT");
    }

    private static final <T extends RealType<T>> Image<T> process(Image<ComplexDoubleType> image, FourierTransform<T, ComplexDoubleType> fourierTransform) throws Exception {
        InverseFourierTransform inverseFourierTransform = new InverseFourierTransform(image, fourierTransform);
        if (!inverseFourierTransform.checkInput() || !inverseFourierTransform.process()) {
            throw new Exception("FFT: failed to process for image " + image.getClass() + " -- " + inverseFourierTransform.getErrorMessage());
        }
        return inverseFourierTransform.getResult();
    }
}

