/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import mpicbg.imglib.algorithm.gauss.GaussianConvolutionReal;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.DoubleType;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gauss<T extends RealType<T>>
extends Image<T> {
    public Gauss(Image<T> image, double d) throws Exception {
        this(image, (OutOfBoundsStrategyFactory<T>)new OutOfBoundsStrategyMirrorFactory(), d);
    }

    public Gauss(Image<T> image, double[] dArray) throws Exception {
        this(image, (OutOfBoundsStrategyFactory<T>)new OutOfBoundsStrategyMirrorFactory(), dArray);
    }

    public Gauss(IFunction iFunction, double d) throws Exception {
        this(Compute.inDoubles(iFunction), (OutOfBoundsStrategyFactory<DoubleType>)new OutOfBoundsStrategyMirrorFactory(), d);
    }

    public Gauss(IFunction iFunction, double[] dArray) throws Exception {
        this(Compute.inDoubles(iFunction), (OutOfBoundsStrategyFactory<DoubleType>)new OutOfBoundsStrategyMirrorFactory(), dArray);
    }

    public Gauss(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, double d) throws Exception {
        this(image, outOfBoundsStrategyFactory, Gauss.asArray(d, image.getNumDimensions()));
    }

    public Gauss(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, double[] dArray) throws Exception {
        super(Gauss.process(image, outOfBoundsStrategyFactory, dArray).getContainer(), image.createType());
    }

    public Gauss(IFunction iFunction, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, double d) throws Exception {
        this(Compute.inDoubles(iFunction), outOfBoundsStrategyFactory, d);
    }

    public Gauss(IFunction iFunction, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, double[] dArray) throws Exception {
        this(Compute.inDoubles(iFunction), outOfBoundsStrategyFactory, dArray);
    }

    private static final double[] asArray(double d, int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d;
        }
        return dArray;
    }

    private static final <R extends RealType<R>> Image<R> process(Image<R> image, OutOfBoundsStrategyFactory<R> outOfBoundsStrategyFactory, double[] dArray) throws Exception {
        GaussianConvolutionReal gaussianConvolutionReal = new GaussianConvolutionReal(image, outOfBoundsStrategyFactory, dArray);
        if (!gaussianConvolutionReal.checkInput() || !gaussianConvolutionReal.process()) {
            throw new Exception("Gauss: " + gaussianConvolutionReal.getErrorMessage());
        }
        return gaussianConvolutionReal.getResult();
    }
}

