/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mpicbg.imglib.algorithm.fft.FourierTransform;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.ComplexType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.complex.ComplexDoubleType;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FFT<T extends RealType<T>>
extends Image<ComplexDoubleType> {
    private static Map<Thread, FourierTransform<?, ComplexDoubleType>> m = Collections.synchronizedMap(new HashMap());
    final FourierTransform<T, ComplexDoubleType> fft = m.remove(Thread.currentThread());
    final T value;

    public FFT(Image<T> image) throws Exception {
        super(FFT.process(image).getContainer(), (Type)new ComplexDoubleType(), "FFT");
        this.value = (RealType)image.createType();
    }

    public FFT(IFunction iFunction) throws Exception {
        this(Compute.inDoubles(iFunction));
    }

    private static final synchronized <T extends RealType<T>> Image<ComplexDoubleType> process(Image<T> image) throws Exception {
        FourierTransform fourierTransform = new FourierTransform(image, (ComplexType)new ComplexDoubleType());
        if (!fourierTransform.checkInput() || !fourierTransform.process()) {
            throw new Exception("FFT: failed to process for image " + image.getClass() + " -- " + fourierTransform.getErrorMessage());
        }
        m.put(Thread.currentThread(), fourierTransform);
        return fourierTransform.getResult();
    }
}

