/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.floydsteinberg.FloydSteinbergDithering;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.logic.BitType;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dither<T extends RealType<T>>
extends Image<BitType> {
    public Dither(Image<T> image) throws Exception {
        super(Dither.process(image).getContainer(), (Type)new BitType());
    }

    public Dither(Image<T> image, float f) throws Exception {
        super(Dither.process(image, f).getContainer(), (Type)new BitType());
    }

    public Dither(IFunction iFunction) throws Exception {
        this(Compute.inDoubles(iFunction));
    }

    public Dither(IFunction iFunction, float f) throws Exception {
        this(Compute.inDoubles(iFunction), f);
    }

    private static final <R extends RealType<R>> Image<BitType> process(Image<R> image, float f) throws Exception {
        return Dither.process(new FloydSteinbergDithering(image, f));
    }

    private static final <R extends RealType<R>> Image<BitType> process(Image<R> image) throws Exception {
        return Dither.process(new FloydSteinbergDithering(image));
    }

    private static final <R extends RealType<R>> Image<R> process(OutputAlgorithm<R> outputAlgorithm) throws Exception {
        if (!outputAlgorithm.checkInput() || !outputAlgorithm.process()) {
            throw new Exception("Dither failed: " + outputAlgorithm.getErrorMessage());
        }
        return outputAlgorithm.getResult();
    }
}

