/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import mpicbg.imglib.algorithm.fft.Bandpass;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BandpassFilter<T extends RealType<T>>
extends Image<T> {
    public BandpassFilter(Image<T> image, int n, int n2) throws Exception {
        super(BandpassFilter.process(image, n, n2).getContainer(), image.createType(), "Bandpass");
    }

    public BandpassFilter(IFunction iFunction, int n, int n2) throws Exception {
        this(Compute.inDoubles(iFunction), n, n2);
    }

    private static final <T extends RealType<T>> Image<T> process(Image<T> image, int n, int n2) throws Exception {
        Bandpass bandpass = new Bandpass(image, n, n2);
        if (!bandpass.checkInput() || !bandpass.process()) {
            throw new Exception(bandpass.getClass().getSimpleName() + " failed: " + bandpass.getErrorMessage());
        }
        return bandpass.getResult();
    }
}

