/*
 * Decompiled with CFR 0.152.
 */
package script.imglib;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileSaver;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImagePlusAdapter;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImgLib {
    public static <T extends RealType<T>> Image<T> open(String string) {
        try {
            return ImgLib.wrap(IJ.openImage((String)string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Got I/O exception: " + exception, exception);
        }
    }

    public static <T extends RealType<T>> Image<T> wrap(ImagePlus imagePlus) {
        return ImagePlusAdapter.wrap((ImagePlus)imagePlus);
    }

    public static final ImagePlus wrap(Image<?> image) {
        return ImageJFunctions.displayAsVirtualStack(image);
    }

    public static <T extends RealType<T>> boolean save(Image<T> image, String string) {
        int n = string.lastIndexOf(46);
        if (n < 0 || string.length() - n - 1 > 4) {
            throw new RuntimeException("Could not infer file type from filename: " + string);
        }
        return ImgLib.save(image, string.substring(n + 1), string);
    }

    public static <T extends RealType<T>> boolean save(Image<T> image, String string, String string2) {
        ImagePlus imagePlus = ImageJFunctions.displayAsVirtualStack(image);
        FileSaver fileSaver = new FileSaver(imagePlus);
        if ((string = string.toLowerCase()).equals("tif") || string.equals("tiff")) {
            if (image.getNumDimensions() > 2) {
                return fileSaver.saveAsTiffStack(string2);
            }
            return fileSaver.saveAsTiff(string2);
        }
        if (string.equals("zip")) {
            return fileSaver.saveAsZip(string2);
        }
        if (string.equals("gif")) {
            return fileSaver.saveAsGif(string2);
        }
        if (string.equals("jpg") || string.equals("jpeg")) {
            return fileSaver.saveAsJpeg(string2);
        }
        if (string.equals("bmp")) {
            return fileSaver.saveAsBmp(string2);
        }
        if (string.equals("pgm")) {
            return fileSaver.saveAsPgm(string2);
        }
        if (string.equals("png")) {
            return fileSaver.saveAsPng(string2);
        }
        if (string.equals("raw")) {
            return fileSaver.saveAsRaw(string2);
        }
        throw new RuntimeException("Unknown fileformat: " + string);
    }
}

