/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.NIOFileHandle;
import loci.common.RandomAccessInputStream;
import loci.common.StreamHandle;
import loci.common.URLHandle;

public class ZipHandle
extends StreamHandle {
    private RandomAccessInputStream in;
    private ZipInputStream zip;
    private ZipEntry entry;
    private int entryCount = 0;
    private String file;

    public ZipHandle(String file) throws IOException {
        ZipEntry ze;
        this.file = file;
        this.in = new RandomAccessInputStream(ZipHandle.getHandle(file));
        this.zip = new ZipInputStream(this.in);
        String innerFile = file.substring(0, file.length() - 4);
        int slash = innerFile.lastIndexOf(File.separator);
        if (slash < 0) {
            slash = innerFile.lastIndexOf("/");
        }
        if (slash >= 0) {
            innerFile = innerFile.substring(slash + 1);
        }
        this.entry = null;
        while ((ze = this.zip.getNextEntry()) != null) {
            ++this.entryCount;
        }
        this.resetStream();
        while ((ze = this.zip.getNextEntry()) != null) {
            if (this.entry == null) {
                this.entry = ze;
            }
            if (!ze.getName().startsWith(innerFile)) continue;
            this.entry = ze;
            break;
        }
        this.resetStream();
        this.populateLength();
    }

    public ZipHandle(String file, ZipEntry entry) throws IOException {
        this.file = file;
        this.in = new RandomAccessInputStream(ZipHandle.getHandle(file));
        this.zip = new ZipInputStream(this.in);
        while (!entry.getName().equals(this.zip.getNextEntry().getName())) {
        }
        this.entryCount = 1;
        this.entry = entry;
        this.resetStream();
        this.populateLength();
    }

    public static boolean isZipFile(String file) throws IOException {
        if (!file.toLowerCase().endsWith(".zip")) {
            return false;
        }
        IRandomAccess handle = ZipHandle.getHandle(file);
        byte[] b = new byte[2];
        if (handle.length() >= 2L) {
            handle.read(b);
        }
        handle.close();
        return new String(b).equals("PK");
    }

    public String getEntryName() {
        return this.entry.getName();
    }

    public DataInputStream getInputStream() {
        return this.stream;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public void close() throws IOException {
        if (!Location.getIdMap().containsValue(this)) {
            super.close();
            this.zip = null;
            this.entry = null;
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
            this.entryCount = 0;
        }
    }

    protected void resetStream() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        if (this.in != null) {
            this.in.close();
            this.in = new RandomAccessInputStream(ZipHandle.getHandle(this.file));
        }
        if (this.zip != null) {
            this.zip.close();
        }
        this.zip = new ZipInputStream(this.in);
        if (this.entry != null) {
            while (!this.entry.getName().equals(this.zip.getNextEntry().getName())) {
            }
        }
        this.stream = new DataInputStream(new BufferedInputStream(this.zip, 0xA00000));
        this.stream.mark(0xA00000);
    }

    private void populateLength() throws IOException {
        this.length = -1L;
        while (this.stream.available() > 0) {
            this.stream.skip(1L);
            ++this.length;
        }
        this.resetStream();
    }

    private static IRandomAccess getHandle(String file) throws IOException {
        return file.startsWith("http://") ? new URLHandle(file) : new NIOFileHandle(file, "r");
    }
}

