/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import eu.kostia.gtkjfilechooser.ui.Autocompleter;
import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class PathAutoCompleter
extends Autocompleter {
    private String currentPath;
    private boolean showHidden = false;
    private int fileSelectionMode = 2;
    private javax.swing.filechooser.FileFilter currentFilter;

    public PathAutoCompleter(JTextField comp) {
        super(comp);
        this.setCurrentPath(System.getProperty("user.dir"));
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        if (fileSelectionMode < 0 || fileSelectionMode > 2) {
            throw new IllegalArgumentException("Value " + fileSelectionMode + " is invalid.");
        }
        this.fileSelectionMode = fileSelectionMode;
    }

    public void setCurrentFilter(javax.swing.filechooser.FileFilter currentFilter) {
        this.currentFilter = currentFilter;
    }

    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public void setCurrentPath(String currentPath) {
        this.currentPath = currentPath;
    }

    @Override
    protected List<String> updateSuggestions(String value) {
        File file = this.isAbsolute(value) ? new File(value) : new File(this.getCurrentPath() + File.separator + value);
        final String prefix = file.getName();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!PathAutoCompleter.this.showHidden && pathname.isHidden()) {
                    return false;
                }
                if (PathAutoCompleter.this.fileSelectionMode == 1 && !pathname.isDirectory()) {
                    return false;
                }
                if (PathAutoCompleter.this.currentFilter != null && !PathAutoCompleter.this.currentFilter.accept(pathname)) {
                    return false;
                }
                String name = pathname.getName();
                return name != null ? name.startsWith(prefix) : false;
            }
        };
        File[] list = null;
        if (file.isDirectory()) {
            list = file.listFiles(filter);
        } else if (file.getParentFile() != null) {
            list = file.getParentFile().listFiles(filter);
        }
        if (list == null || list.length == 0) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        int index = value.lastIndexOf(File.separatorChar);
        String before = index != -1 ? value.substring(0, index + 1) : "";
        for (File f : list) {
            String name = f.getName();
            if (f.isDirectory()) {
                name = name + File.separator;
            }
            results.add(before + name);
        }
        Collections.sort(results);
        return results;
    }

    private boolean isAbsolute(String value) {
        return new File(value).isAbsolute();
    }

    @Override
    protected ListCellRenderer getCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String suggestion = (String)value;
                int lastIndexOf = suggestion.lastIndexOf(File.separatorChar);
                if (lastIndexOf < suggestion.length() - 1) {
                    this.setText(suggestion.substring(lastIndexOf + 1));
                }
                return this;
            }
        };
    }
}

