/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;

public class MissingResourceIcon
implements Icon {
    private int w;
    private int h;
    private int mx = 2;
    private int my = 2;

    public MissingResourceIcon(int w, int h) {
        this.w = w;
        this.h = h;
    }

    public MissingResourceIcon(int x) {
        this(x, x);
    }

    public MissingResourceIcon() {
        this(16, 16);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, this.w, this.h);
        g2d.setColor(Color.DARK_GRAY);
        g2d.drawRect(this.mx, this.my, this.w - 2 * this.mx, this.h - 2 * this.my);
        int stroke = 2;
        int k = 2;
        g2d.setStroke(new BasicStroke(stroke));
        g2d.setColor(Color.RED);
        GeneralPath cross = new GeneralPath();
        cross.moveTo(k * this.my + stroke, k * this.mx + stroke);
        cross.lineTo(this.w - (k * this.mx + stroke), this.h - (k * this.my + stroke));
        cross.moveTo(this.w - (k * this.mx + stroke), k * this.mx + stroke);
        cross.lineTo(k * this.my + stroke, this.h - (k * this.my + stroke));
        g2d.draw(cross);
        g2d.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.w;
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }
}

