/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import com.sun.java.swing.plaf.gtk.GTKConstants;
import eu.kostia.gtkjfilechooser.FreeDesktopUtil;
import eu.kostia.gtkjfilechooser.GtkArrow;
import eu.kostia.gtkjfilechooser.GtkStockIcon;
import eu.kostia.gtkjfilechooser.ui.JPanelUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class GtkPathBar
extends JPanel {
    private static final String DIRECTORY_INDEX = "directory index";
    private static final int BUTTON_HEIGHT = 34;
    private static final long serialVersionUID = 1L;
    private JToggleButton selectedButton;
    private ButtonGroup dirButtonsgroup;
    private static int VISIBLE_BUTTONS = 6;
    private int currentStartIndex = 0;
    private String[] directories;
    private String currentDirectory;
    private JButton backButton;
    private JPanel buttonsPanel;
    private JButton forwardButton;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();

    public GtkPathBar(File location) {
        this.setDirectories(location);
        this.setLayout(new BorderLayout());
        this.createButtonsPanel();
        this.backButton = this.createBackButton();
        this.add((Component)JPanelUtil.createPanel(this.flowLayout(0), this.backButton, this.buttonsPanel), "Before");
        this.forwardButton = this.createForwardButton();
        this.add((Component)JPanelUtil.createPanel(this.flowLayout(2), this.forwardButton), "After");
        int last = this.directories.length - 1;
        this.currentStartIndex = last - VISIBLE_BUTTONS + 1;
        this.showButtons(this.currentStartIndex, last);
        this.selectButton(this.directories.length - 1);
    }

    private FlowLayout flowLayout(int align) {
        FlowLayout flowLayout = new FlowLayout(align, 0, 5);
        flowLayout.setAlignOnBaseline(true);
        return flowLayout;
    }

    public void setCurrentDirectory(File location) {
        if (location.equals(this.getCurrentDirectory())) {
            return;
        }
        this.setDirectories(location);
        this.createButtonsPanel();
        int last = this.directories.length - 1;
        this.currentStartIndex = last - VISIBLE_BUTTONS + 1;
        this.showButtons(this.currentStartIndex, last);
        this.selectButton(this.directories.length - 1);
    }

    public File getCurrentDirectory() {
        return new File(this.currentDirectory);
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    public List<ActionListener> getActionListeners() {
        return this.actionListeners;
    }

    private JButton createBackButton() {
        JButton backButton = new JButton();
        backButton.add(new GtkArrow(GTKConstants.ArrowType.LEFT));
        this.setStandardHeight(backButton);
        backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GtkPathBar.this.currentStartIndex--;
                if (GtkPathBar.this.currentStartIndex < 0) {
                    GtkPathBar.this.currentStartIndex = 0;
                }
                GtkPathBar.this.showButtons(GtkPathBar.this.currentStartIndex, GtkPathBar.this.currentStartIndex + VISIBLE_BUTTONS - 1);
            }
        });
        return backButton;
    }

    private void setStandardHeight(JButton backButton) {
        Dimension size = backButton.getPreferredSize();
        size.height = 34;
        backButton.setPreferredSize(size);
    }

    private void createButtonsPanel() {
        this.dirButtonsgroup = new ButtonGroup();
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel(new FlowLayout(0, 0, 0));
        }
        this.buttonsPanel.removeAll();
        for (int i = 0; i < this.directories.length; ++i) {
            String dir = this.directories[i];
            JToggleButton dirButton = new JToggleButton(){
                private static final long serialVersionUID = 1L;

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.height = 34;
                    return d;
                }
            };
            dirButton.putClientProperty(DIRECTORY_INDEX, i);
            if (dir.equals(File.separator)) {
                dirButton.setIcon(GtkStockIcon.get("gtk-harddisk", GtkStockIcon.Size.GTK_ICON_SIZE_BUTTON));
            } else {
                dirButton.setText(dir);
            }
            File tmp = this.getDirectory(i);
            if (tmp.equals(new File(System.getProperty("user.home")))) {
                dirButton.setIcon(GtkStockIcon.get("places/user-home", GtkStockIcon.Size.GTK_ICON_SIZE_BUTTON));
            }
            if (tmp.equals(FreeDesktopUtil.getWellKnownDirPath(FreeDesktopUtil.WellKnownDir.DESKTOP))) {
                dirButton.setIcon(GtkStockIcon.get("places/user-desktop", GtkStockIcon.Size.GTK_ICON_SIZE_MENU));
            }
            dirButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JToggleButton oldSelectedButton = GtkPathBar.this.selectedButton;
                    if (oldSelectedButton != null) {
                        Font plain = oldSelectedButton.getFont().deriveFont(0);
                        oldSelectedButton.setFont(plain);
                        oldSelectedButton.setForeground(Color.BLACK);
                    }
                    GtkPathBar.this.selectedButton = (JToggleButton)e.getSource();
                    Font bold = GtkPathBar.this.selectedButton.getFont().deriveFont(1);
                    GtkPathBar.this.selectedButton.setFont(bold);
                    GtkPathBar.this.updateCurrentDir();
                    for (ActionListener listener : GtkPathBar.this.actionListeners) {
                        ActionEvent myEvt = new ActionEvent(GtkPathBar.this, 1, "directory-selected");
                        listener.actionPerformed(myEvt);
                    }
                }
            });
            this.dirButtonsgroup.add(dirButton);
            this.buttonsPanel.add(dirButton);
        }
    }

    private void updateCurrentDir() {
        int dirIndex = (Integer)this.selectedButton.getClientProperty(DIRECTORY_INDEX);
        if (dirIndex == 0) {
            this.currentDirectory = File.separator;
            return;
        }
        StringBuilder sb = new StringBuilder(File.separator);
        for (int i = 1; i <= dirIndex; ++i) {
            sb.append(this.directories[i]);
            sb.append(File.separator);
        }
        this.currentDirectory = sb.toString();
    }

    private File getDirectory(int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= n; ++i) {
            sb.append(this.directories[i]).append(File.separator);
        }
        return new File(sb.toString());
    }

    private JButton createForwardButton() {
        JButton forwardButton = new JButton();
        forwardButton.add(new GtkArrow(GTKConstants.ArrowType.RIGHT));
        this.setStandardHeight(forwardButton);
        forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GtkPathBar.this.currentStartIndex++;
                if (GtkPathBar.this.currentStartIndex + VISIBLE_BUTTONS - 1 > GtkPathBar.this.directories.length - 1) {
                    GtkPathBar.this.currentStartIndex--;
                }
                GtkPathBar.this.showButtons(GtkPathBar.this.currentStartIndex, GtkPathBar.this.currentStartIndex + VISIBLE_BUTTONS - 1);
            }
        });
        return forwardButton;
    }

    private void showButtons(int startIndex, int endIndex) {
        Enumeration<AbstractButton> buttons = this.dirButtonsgroup.getElements();
        int count = 0;
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            button.setVisible(count >= startIndex && count <= endIndex);
            ++count;
        }
    }

    private void selectButton(int index) {
        Enumeration<AbstractButton> buttons = this.dirButtonsgroup.getElements();
        int count = 0;
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            button.setSelected(count == index);
            if (count == index) {
                button.doClick();
            }
            ++count;
        }
    }

    public void upFolder() {
        Enumeration<AbstractButton> buttons = this.dirButtonsgroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!button.isSelected() || !buttons.hasMoreElements()) continue;
            AbstractButton nextButton = buttons.nextElement();
            nextButton.doClick();
        }
    }

    public void downFolder() {
        Enumeration<AbstractButton> buttons = this.dirButtonsgroup.getElements();
        AbstractButton previousButton = null;
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (button.isSelected() && previousButton != null) {
                previousButton.doClick();
            }
            previousButton = button;
        }
    }

    private void setDirectories(File location) throws IOError {
        if (location == null) {
            throw new IllegalArgumentException("The location cannot be null!");
        }
        File parentDir = location.isDirectory() ? location : location.getParentFile();
        String parentDirPath = null;
        try {
            parentDirPath = parentDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.currentDirectory = parentDirPath;
        if (parentDirPath.startsWith(File.separator)) {
            parentDirPath = "x" + parentDirPath;
        }
        String[] dirs = parentDirPath.split(Pattern.quote(File.separator));
        dirs[0] = File.separator;
        this.directories = dirs;
    }
}

