/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import eu.kostia.gtkjfilechooser.ActionPath;
import eu.kostia.gtkjfilechooser.ArrayUtil;
import eu.kostia.gtkjfilechooser.BookmarkManager;
import eu.kostia.gtkjfilechooser.ButtonAreaLayout;
import eu.kostia.gtkjfilechooser.FileFilterWrapper;
import eu.kostia.gtkjfilechooser.FocusUtil;
import eu.kostia.gtkjfilechooser.FreeDesktopUtil;
import eu.kostia.gtkjfilechooser.GtkFileChooserSettings;
import eu.kostia.gtkjfilechooser.GtkFileView;
import eu.kostia.gtkjfilechooser.GtkStockIcon;
import eu.kostia.gtkjfilechooser.GtkVersion;
import eu.kostia.gtkjfilechooser.I18N;
import eu.kostia.gtkjfilechooser.Log;
import eu.kostia.gtkjfilechooser.NavigationKeyBinding;
import eu.kostia.gtkjfilechooser.Path;
import eu.kostia.gtkjfilechooser.filewatcher.FileEvent;
import eu.kostia.gtkjfilechooser.filewatcher.FileListener;
import eu.kostia.gtkjfilechooser.filewatcher.FileWatcher;
import eu.kostia.gtkjfilechooser.ui.FileBrowserPane;
import eu.kostia.gtkjfilechooser.ui.FilesListPane;
import eu.kostia.gtkjfilechooser.ui.GtkLocationsPane;
import eu.kostia.gtkjfilechooser.ui.GtkPathBar;
import eu.kostia.gtkjfilechooser.ui.JPanelUtil;
import eu.kostia.gtkjfilechooser.ui.PathAutoCompleter;
import eu.kostia.gtkjfilechooser.ui.RecentlyUsedFileWorker;
import eu.kostia.gtkjfilechooser.ui.SaveDialogPanel;
import eu.kostia.gtkjfilechooser.ui.SearchPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class GtkFileChooserUI
extends BasicFileChooserUI
implements Serializable,
PropertyChangeListener,
ActionListener {
    public static final String PROP_FILE_CHOOSER_SHOW_BACKUP = "FileChooser.showBackup";
    private static final File FILE_GTK_BOOKMARK = new File(System.getProperty("user.home") + File.separator + ".gtk-bookmarks");
    private static final File FILE_MEDIA = new File("/media");
    private static final String ACTION_SELECTED_BOOKMARK = "selected bookmark";
    private static final String ACTION_CREATE_FOLDER = "createFolder";
    private static final String ANCESTOR_PROPERTY = "ancestor";
    private static final String COMPONENT_ORIENTATION_PROPERTY = "componentOrientation";
    private static final String CURRENT_PANEL_CHANGED = "CurrentPanelChanged";
    private static final String FILEBROWSER_PANEL = "fileBrowserPane";
    private static final int FILEBROWSER_PANEL_ID = 1000;
    private static int LIST_PREF_HEIGHT = 135;
    private static int LIST_PREF_WIDTH = 405;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private static int MIN_HEIGHT = 200;
    private static int MIN_EXPANDED_HEIGHT = 500;
    private static int MIN_WIDTH = 700;
    private static final int BOTTOM_ROW_GAP = 6;
    private static final int UPPER_BUTTON_GAP = 12;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_EXPANDED_HEIGHT);
    private static int PREF_WIDTH = 700;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static final String RECENTLY_USED_PANEL = "recentlyUsedPane";
    private static final String SEARCH_PANEL = "searchFilesPane";
    private static final long serialVersionUID = 10L;
    private static final String TOP_PATHBAR_PANEL = "Path bar panel on the top";
    private static final String TOP_SEARCH_PANEL = "Search panel on the top";
    private JButton addBookmarkButton;
    private JButton approveButton;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel openDialogPanel;
    private SaveDialogPanel saveDialogPanel;
    private JPanel cardPanel = new JPanel(new CardLayout());
    private JToggleButton showPositionButton;
    private GtkPathBar pathBarButtons;
    private ActionListener pathBarActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GtkFileChooserUI.this.fireChangeDirectoryEvent(GtkFileChooserUI.this.pathBarButtons.getCurrentDirectory());
        }
    };
    private JButton createFolderButton;
    private int currentPanelId = 1000;
    private FileBrowserPane fileBrowserPane;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText;
    private JPanel filenamePanel;
    private JTextField fileNameTextField;
    private String filesOfTypeLabelText;
    private JComboBox filterComboBox;
    private GtkLocationsPane locationsPane;
    private PathAutoCompleter pathAutoCompletion;
    private FilesListPane recentlyUsedPane;
    private JButton removeBookmarkButton;
    private FilesListPane searchFilesPane;
    private SearchPanel searchPanel;
    private JPanel topPanel;
    private JFileChooser chooser;
    private ComponentAdapter chooserComponentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            if (GtkFileChooserUI.this.saveDialogPanel != null && !GtkFileChooserUI.this.saveDialogPanel.isExpanded()) {
                return;
            }
            Rectangle bound = e.getComponent().getBounds();
            if (GtkFileChooserUI.this.getFileChooser().getDialogType() == 1) {
                bound.height += 20;
            }
            GtkFileChooserSettings.get().setBound(bound);
        }
    };
    private transient int expandedHeight = -1;

    public GtkFileChooserUI(JFileChooser chooser) {
        super(chooser);
        this.chooser = chooser;
        if (this.getFileChooser().getFileView() == null) {
            this.getFileChooser().setFileView(new GtkFileView());
        }
        this.openDialogPanel = new JPanel();
        this.openDialogPanel.setLayout(new BorderLayout(0, 11));
        chooser.setLayout(new BorderLayout());
        chooser.setBorder(new EmptyBorder(12, 11, 11, 11));
        this.doDialogTypeChanged(chooser.getDialogType());
        chooser.setFileHidingEnabled(GtkFileChooserSettings.get().getShowHidden() == false);
        if (chooser.getCurrentDirectory() == null) {
            chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        }
        chooser.removeComponentListener(this.chooserComponentListener);
        chooser.addComponentListener(this.chooserComponentListener);
        this.installKeyBinding();
        FileWatcher.theFileWatcher().register(chooser.getCurrentDirectory());
        FileWatcher.theFileWatcher().register(FILE_MEDIA);
        FileWatcher.theFileWatcher().register(FILE_GTK_BOOKMARK);
        FileWatcher.theFileWatcher().addFileListener(new FileListener(){

            @Override
            public void fileChanged(FileEvent event) {
                File file = event.getFile();
                if (FILE_MEDIA.equals(file) || FILE_GTK_BOOKMARK.equals(file)) {
                    GtkFileChooserUI.this.locationsPane.refreshLocations();
                } else {
                    GtkFileChooserUI.this.fileBrowserPane.refresh();
                }
            }
        });
    }

    private void installKeyBinding() {
        NavigationKeyBinding keyBinding = new NavigationKeyBinding(this.getFileChooser());
        keyBinding.addActionListener(this);
    }

    @Override
    public JFileChooser getFileChooser() {
        return this.chooser;
    }

    @Override
    public void installComponents(JFileChooser fc) {
        this.fileBrowserPane = new FileBrowserPane(this.getFileChooser().getCurrentDirectory(), this.getFileChooser().getFileView());
        fc.addPropertyChangeListener(this);
        this.fileBrowserPane.addPropertyChangeListener(this);
        this.fileBrowserPane.addActionListener(this);
        this.fileBrowserPane.table.getInputMap().put(KeyStroke.getKeyStroke(33, 0), "goToFileNameTextField");
        this.fileBrowserPane.table.getActionMap().put("goToFileNameTextField", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GtkFileChooserUI.this.fileNameTextField.requestFocus();
            }
        });
        this.showPositionButton = new JToggleButton(GtkStockIcon.get("gtk-edit", GtkStockIcon.Size.GTK_ICON_SIZE_BUTTON));
        this.showPositionButton.setSelected(GtkFileChooserSettings.get().getLocationMode() == GtkFileChooserSettings.Mode.FILENAME_ENTRY);
        this.showPositionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GtkFileChooserSettings.Mode mode = GtkFileChooserUI.this.showPositionButton.isSelected() ? GtkFileChooserSettings.Mode.FILENAME_ENTRY : GtkFileChooserSettings.Mode.PATH_BAR;
                GtkFileChooserSettings.get().setLocationMode(mode);
            }
        });
        this.showPositionButton.setToolTipText(I18N._("Type a file name"));
        this.pathBarButtons = new GtkPathBar(this.getFileChooser().getCurrentDirectory());
        this.pathBarButtons.addActionListener(this.pathBarActionListener);
        JPanel pathbar = new JPanel();
        pathbar.setLayout(new BoxLayout(pathbar, 2));
        pathbar.add(this.showPositionButton);
        pathbar.add(Box.createHorizontalStrut(12));
        pathbar.add(this.pathBarButtons);
        this.createFolderButton = new JButton(I18N._("Create Fo_lder"));
        this.createFolderButton.setVisible(false);
        this.createFolderButton.setMnemonic(I18N.getMnemonic("Create Fo_lder"));
        this.createFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent evt = new ActionEvent(GtkFileChooserUI.this, GtkFileChooserUI.ACTION_CREATE_FOLDER.hashCode(), GtkFileChooserUI.ACTION_CREATE_FOLDER);
                GtkFileChooserUI.this.actionPerformed(evt);
            }
        });
        pathbar.add(this.createFolderButton);
        this.createFilenamePanel(fc);
        this.showPositionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JToggleButton btn = (JToggleButton)e.getSource();
                GtkFileChooserUI.this.filenamePanel.setVisible(btn.isSelected());
            }
        });
        this.filenamePanel.setVisible(this.showPositionButton.isSelected());
        JPanel topPanelDefault = new JPanel(new BorderLayout());
        topPanelDefault.setLayout(new BoxLayout(topPanelDefault, 3));
        topPanelDefault.add(pathbar);
        topPanelDefault.add(this.filenamePanel);
        this.topPanel = new JPanel(new CardLayout());
        this.topPanel.add((Component)topPanelDefault, TOP_PATHBAR_PANEL);
        this.openDialogPanel.add((Component)this.topPanel, "North");
        this.openDialogPanel.add((Component)this.getAccessoryPanel(), "After");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        this.addFileBrowserPane();
        if (fc.getControlButtonsAreShown()) {
            fc.add((Component)this.getButtonPanel(), "Last");
        }
    }

    private void addFileBrowserPane() {
        this.addBookmarkButton = new JButton(I18N._("_Add"));
        this.addBookmarkButton.setMnemonic(I18N.getMnemonic("_Add"));
        this.addBookmarkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GtkFileChooserUI.this.addToBookmarks();
            }
        });
        this.addBookmarkButton.setEnabled(false);
        this.removeBookmarkButton = new JButton(I18N._("_Remove"));
        this.removeBookmarkButton.setMnemonic(I18N.getMnemonic("_Remove"));
        this.removeBookmarkButton.setEnabled(false);
        this.removeBookmarkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GtkFileChooserUI.this.locationsPane.removeSelectedBookmark();
            }
        });
        if (!GtkVersion.check(2, 18, 0)) {
            this.addBookmarkButton.setIcon(GtkStockIcon.get("gtk-add", GtkStockIcon.Size.GTK_ICON_SIZE_BUTTON));
            this.removeBookmarkButton.setIcon(GtkStockIcon.get("gtk-remove", GtkStockIcon.Size.GTK_ICON_SIZE_BUTTON));
        }
        JPanel buttonPanel = JPanelUtil.createPanelBoxLayout(1, Box.createVerticalStrut(6), JPanelUtil.createPanel(new GridLayout(1, 2), this.addBookmarkButton, this.removeBookmarkButton));
        this.locationsPane = new GtkLocationsPane();
        this.locationsPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Path entry = ((GtkLocationsPane)e.getSource()).getCurrentPath();
                if (entry instanceof ActionPath) {
                    ActionPath action = (ActionPath)entry;
                    GtkFileChooserUI.this.getFileChooser().firePropertyChange(GtkFileChooserUI.CURRENT_PANEL_CHANGED, GtkFileChooserUI.this.currentPanelId, action.getId());
                    return;
                }
                GtkFileChooserUI.this.getFileChooser().firePropertyChange(GtkFileChooserUI.CURRENT_PANEL_CHANGED, GtkFileChooserUI.this.currentPanelId, 1000);
                if (entry != null && entry.getLocation() != null) {
                    ActionEvent evt = new ActionEvent(GtkFileChooserUI.this.locationsPane, -1, GtkFileChooserUI.ACTION_SELECTED_BOOKMARK);
                    GtkFileChooserUI.this.actionPerformed(evt);
                }
            }
        });
        JPanel leftPane = JPanelUtil.createPanel(new JPanelUtil.PanelElement(this.locationsPane, "Center"), new JPanelUtil.PanelElement(buttonPanel, "Last"));
        this.installListenersForBookmarksButtons();
        this.fileBrowserPane.setPreferredSize(LIST_PREF_SIZE);
        this.cardPanel.add((Component)this.fileBrowserPane, FILEBROWSER_PANEL);
        JPanel rightPane = new JPanel(new BorderLayout());
        rightPane.add((Component)this.cardPanel, "Center");
        if (this.filterComboBox == null) {
            this.createFilterComboBox();
        }
        rightPane.add((Component)JPanelUtil.createPanelBoxLayout(1, Box.createVerticalStrut(6), JPanelUtil.createPanelBoxLayout(Box.createHorizontalGlue(), this.filterComboBox)), "Last");
        JSplitPane splitPanel = new JSplitPane(1, leftPane, rightPane);
        splitPanel.setContinuousLayout(true);
        this.openDialogPanel.add((Component)splitPanel, "Center");
    }

    @Override
    public String getApproveButtonText(JFileChooser fc) {
        String buttonText = fc.getApproveButtonText();
        if (buttonText != null) {
            return buttonText;
        }
        if (fc.getDialogType() == 0) {
            return this.openButtonText;
        }
        if (fc.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }

    @Override
    public String getDirectoryName() {
        return this.getFileChooser().getCurrentDirectory().getName();
    }

    @Override
    public String getFileName() {
        if (this.getFileChooser().getDialogType() == 1) {
            File filename = this.saveDialogPanel.getFilename();
            return filename != null ? filename.getAbsolutePath() : null;
        }
        return this.fileNameTextField.getText();
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Rectangle bound = GtkFileChooserSettings.get().getBound();
        if (bound != null && bound.width > 0 && bound.height > 0) {
            return new Dimension(bound.width, bound.height);
        }
        int prefWidth = GtkFileChooserUI.PREF_SIZE.width;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(d.width < prefWidth ? prefWidth : d.width, d.height < GtkFileChooserUI.PREF_SIZE.height ? GtkFileChooserUI.PREF_SIZE.height : d.height);
        }
        return new Dimension(prefWidth, GtkFileChooserUI.PREF_SIZE.height);
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        this.fileBrowserPane.rescanCurrentDirectory();
    }

    @Override
    public void setDirectoryName(String dirname) {
        this.getFileChooser().setCurrentDirectory(new File(dirname));
    }

    @Override
    public void setFileName(String filename) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners(this.chooser);
        this.uninstallComponents(this.chooser);
        this.uninstallDefaults(this.chooser);
        if (this.getAccessoryPanel() != null) {
            this.getAccessoryPanel().removeAll();
        }
        this.getFileChooser().removeAll();
    }

    @Override
    protected void uninstallListeners(JFileChooser fc) {
        fc.removePropertyChangeListener(this);
        fc.removeActionListener(this);
        SwingUtilities.replaceUIInputMap(fc, 1, null);
        SwingUtilities.replaceUIActionMap(fc, null);
    }

    @Override
    public void uninstallComponents(JFileChooser fc) {
        super.uninstallComponents(fc);
        this.addBookmarkButton = null;
        this.approveButton = null;
        this.buttonPanel = null;
        this.cancelButton = null;
        this.openDialogPanel = null;
        this.saveDialogPanel = null;
        this.cardPanel = null;
        this.showPositionButton = null;
        this.pathBarButtons = null;
        this.pathBarActionListener = null;
        this.createFolderButton = null;
        this.fileBrowserPane = null;
        this.fileNameLabelText = null;
        this.filenamePanel = null;
        this.fileNameTextField = null;
        this.filterComboBox = null;
        this.locationsPane = null;
        this.pathAutoCompletion = null;
        this.recentlyUsedPane = null;
        this.removeBookmarkButton = null;
        this.searchFilesPane = null;
        this.searchPanel = null;
        this.topPanel = null;
    }

    public void valueChanged(ListSelectionEvent e) {
        JFileChooser fc = this.getFileChooser();
        File f = fc.getSelectedFile();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.fileNameString(f));
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new ButtonAreaLayout());
            this.cancelButton = new JButton(this.cancelButtonText);
            this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
            this.cancelButton.addActionListener(this.getCancelSelectionAction());
            this.cancelButton.setMnemonic(I18N.getMnemonic("Stock label|_Cancel"));
            this.buttonPanel.add(this.cancelButton);
            this.approveButton = new JButton();
            this.approveButton.setAction(this.getOpenClickedAction());
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.getFileChooser()));
            this.buttonPanel.add(this.approveButton);
            if (!GtkVersion.check(2, 18, 0)) {
                if (this.getFileChooser().getDialogType() == 0) {
                    this.approveButton.setIcon(GtkStockIcon.get("gtk-open", GtkStockIcon.Size.GTK_ICON_SIZE_BUTTON));
                } else {
                    this.approveButton.setIcon(GtkStockIcon.get("gtk-save", GtkStockIcon.Size.GTK_ICON_SIZE_BUTTON));
                }
                this.cancelButton.setIcon(GtkStockIcon.get("gtk-cancel", GtkStockIcon.Size.GTK_ICON_SIZE_BUTTON));
            }
            Dimension psize0 = this.approveButton.getPreferredSize();
            Dimension psize1 = this.cancelButton.getPreferredSize();
            int width = psize0.width > psize1.width ? psize0.width : psize1.width;
            psize0.width = width = width < 80 ? 80 : width;
            this.cancelButton.setPreferredSize(psize0);
            this.approveButton.setPreferredSize(psize0);
        }
        return this.buttonPanel;
    }

    private Action getOpenClickedAction() {
        Action action = this.getApproveSelectionAction();
        action.putValue("Name", this.getApproveButtonText(this.getFileChooser()));
        action.putValue("MnemonicKey", I18N.getMnemonic("Stock label|_Open"));
        return action;
    }

    private Action getSaveClickedAction() {
        SelectPathAction action = new SelectPathAction(){

            @Override
            protected File getSelectedPath() {
                if (GtkFileChooserUI.this.saveDialogPanel != null) {
                    return GtkFileChooserUI.this.saveDialogPanel.getFilename();
                }
                return null;
            }
        };
        action.putValue("Name", this.getApproveButtonText(this.getFileChooser()));
        action.putValue("MnemonicKey", I18N.getMnemonic("Stock label|_Save"));
        return action;
    }

    @Override
    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.fileNameLabelText = I18N._("_Location:");
        this.fileNameLabelMnemonic = I18N.getMnemonic("_Location:");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", l);
        this.openButtonText = I18N._("Stock label|_Open");
        this.saveButtonText = I18N._("Stock label|_Save");
        this.cancelButtonText = I18N._("Stock label|_Cancel");
    }

    FilesListPane getRecentlyUsedPane() {
        return this.recentlyUsedPane;
    }

    private void addToBookmarks() {
        File[] paths = this.fileBrowserPane.getSelectedFiles();
        if (paths == null) {
            this.locationsPane.addBookmark(this.fileBrowserPane.getSelectedFile());
        } else {
            for (File path : paths) {
                this.locationsPane.addBookmark(path);
            }
        }
    }

    private void approveSelection() {
        if (this.askOverride()) {
            this.getFileChooser().approveSelection();
        }
    }

    private boolean askOverride() {
        if (1 == this.getFileChooser().getDialogType()) {
            File selectedFile = this.getFileChooser().getSelectedFile();
            if (selectedFile == null) {
                return false;
            }
            if (selectedFile.exists()) {
                String head = I18N._("A file named \"%s\" already exists.  Do you want to replace it?", selectedFile.getName());
                String foot = I18N._("The file already exists in \"%s\".  Replacing it will overwrite its contents.", selectedFile.getParentFile().getName());
                String msg = "<html><p width='400px'><span style='font-weight: bold; font-size: 18pt;'>" + head + "</span></p><br /><p>" + foot + "</p></html>";
                int n = JOptionPane.showConfirmDialog(this.getFileChooser(), msg, "", 2);
                return n == 0;
            }
        }
        return true;
    }

    private void createFilenamePanel(JFileChooser fc) {
        this.filenamePanel = new JPanel();
        this.filenamePanel.setLayout(new BoxLayout(this.filenamePanel, 2));
        JLabel fileNameLabel = new JLabel(this.fileNameLabelText);
        fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        this.filenamePanel.add(fileNameLabel);
        this.filenamePanel.add(Box.createRigidArea(new Dimension(15, 0)));
        this.fileNameTextField = new JTextField(){
            private static final long serialVersionUID = 10L;

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        this.filenamePanel.add(this.fileNameTextField);
        fileNameLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!GtkFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    GtkFileChooserUI.this.fileBrowserPane.clearSelection();
                }
            }
        });
        this.fileNameTextField.addActionListener(new SelectPathAction(){

            @Override
            protected File getSelectedPath() {
                String text = GtkFileChooserUI.this.fileNameTextField.getText();
                File path = new File(text);
                if (!path.isAbsolute()) {
                    path = new File(GtkFileChooserUI.this.getFileChooser().getCurrentDirectory().getAbsolutePath() + File.separator + text);
                }
                return path;
            }
        });
        this.fileNameTextField.getInputMap().put(KeyStroke.getKeyStroke(34, 0), "goToFileBrowser");
        this.fileNameTextField.getActionMap().put("goToFileBrowser", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GtkFileChooserUI)GtkFileChooserUI.this).fileBrowserPane.table.requestFocus();
            }
        });
        this.pathAutoCompletion = new PathAutoCompleter(this.fileNameTextField);
        this.pathAutoCompletion.setShowHidden(GtkFileChooserSettings.get().getShowHidden());
        this.pathAutoCompletion.setCurrentPath(this.fileBrowserPane.getCurrentDir().getAbsolutePath());
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(fc.getSelectedFile()));
        }
    }

    private void createFilterComboBox() {
        this.filterComboBox = new JComboBox();
        this.filterComboBox.putClientProperty("AccessibleDescription", this.filesOfTypeLabelText);
        Dimension size = new Dimension(150, (int)this.removeBookmarkButton.getPreferredSize().getHeight());
        this.filterComboBox.setPreferredSize(size);
        this.filterComboBox.setMaximumSize(size);
        this.filterComboBox.setMinimumSize(size);
        this.filterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFilter filter = (FileFilter)GtkFileChooserUI.this.filterComboBox.getSelectedItem();
                GtkFileChooserUI.this.getFileChooser().setFileFilter(filter);
            }
        });
    }

    private void createRecentlyUsedPane() {
        this.recentlyUsedPane = new FilesListPane(this.getFileChooser().getFileView());
        int selectionMode = this.getFileChooser().isMultiSelectionEnabled() ? 2 : 0;
        this.recentlyUsedPane.setSelectionMode(selectionMode);
        this.recentlyUsedPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GtkFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    GtkFileChooserUI.this.getFileChooser().setSelectedFiles(GtkFileChooserUI.this.recentlyUsedPane.getSelectedFiles());
                } else {
                    GtkFileChooserUI.this.getFileChooser().setSelectedFile(GtkFileChooserUI.this.recentlyUsedPane.getSelectedFile());
                }
                if (2 == e.getID()) {
                    GtkFileChooserUI.this.getFileChooser().approveSelection();
                }
            }
        });
        this.cardPanel.add((Component)this.recentlyUsedPane, RECENTLY_USED_PANEL);
        this.recentlyUsedPane.addActionListener(new SelectPathAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (3 == e.getID()) {
                    super.actionPerformed(e);
                }
            }

            @Override
            protected File getSelectedPath() {
                return GtkFileChooserUI.this.recentlyUsedPane.getSelectedFile();
            }
        });
        new RecentlyUsedFileWorker(this).execute();
    }

    private void createSearchPane() {
        this.searchFilesPane = new FilesListPane(this.getFileChooser().getFileView());
        int selectionMode = this.getFileChooser().isMultiSelectionEnabled() ? 2 : 0;
        this.searchFilesPane.setSelectionMode(selectionMode);
        this.searchFilesPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GtkFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    GtkFileChooserUI.this.getFileChooser().setSelectedFiles(GtkFileChooserUI.this.searchFilesPane.getSelectedFiles());
                } else {
                    GtkFileChooserUI.this.getFileChooser().setSelectedFile(GtkFileChooserUI.this.searchFilesPane.getSelectedFile());
                }
                if (2 == e.getID()) {
                    GtkFileChooserUI.this.getFileChooser().approveSelection();
                }
            }
        });
        this.searchFilesPane.addActionListener(new SelectPathAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (3 == e.getID()) {
                    super.actionPerformed(e);
                }
            }

            @Override
            protected File getSelectedPath() {
                return GtkFileChooserUI.this.searchFilesPane.getSelectedFile();
            }
        });
        this.searchPanel = new SearchPanel(this.searchFilesPane);
        this.topPanel.add((Component)this.searchPanel, TOP_SEARCH_PANEL);
        this.cardPanel.add((Component)this.searchFilesPane, SEARCH_PANEL);
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
    }

    private void doChoosableFileFilterChanged(FileFilter[] filters) {
        this.filterComboBox.removeAllItems();
        for (FileFilter filter : filters) {
            this.filterComboBox.addItem(this.wrapFileFilter(filter));
        }
        if (this.filterComboBox.getItemCount() == 0) {
            this.filterComboBox.addItem(this.wrapFileFilter(this.getFileChooser().getAcceptAllFileFilter()));
        }
    }

    private void doCurrentPanelChanged(int id) {
        this.currentPanelId = id;
        CardLayout top = (CardLayout)this.topPanel.getLayout();
        CardLayout right = (CardLayout)this.cardPanel.getLayout();
        switch (id) {
            case 1000: {
                Log.debug("   >>> Panel: ", FILEBROWSER_PANEL);
                this.topPanel.setVisible(true);
                this.filenamePanel.setVisible(this.showPositionButton.isSelected());
                top.show(this.topPanel, TOP_PATHBAR_PANEL);
                right.show(this.cardPanel, FILEBROWSER_PANEL);
                break;
            }
            case 1001: {
                Log.debug("   >>> Panel: ", RECENTLY_USED_PANEL);
                if (this.recentlyUsedPane == null) {
                    this.createRecentlyUsedPane();
                }
                this.topPanel.setVisible(false);
                right.show(this.cardPanel, RECENTLY_USED_PANEL);
                break;
            }
            case 1002: {
                Log.debug("   >>> Panel: ", SEARCH_PANEL);
                if (this.searchFilesPane == null) {
                    this.createSearchPane();
                }
                this.filenamePanel.setVisible(false);
                this.topPanel.setVisible(true);
                top.show(this.topPanel, TOP_SEARCH_PANEL);
                right.show(this.cardPanel, SEARCH_PANEL);
                this.searchPanel.setFileFilter(new FileFilterWrapper(this.getFileChooser().getFileFilter()));
                this.searchPanel.requestFocusInWindow();
            }
        }
    }

    private void doDialogTypeChanged(int dialogType) {
        JFileChooser chooser = this.getFileChooser();
        if (1 == chooser.getDialogType()) {
            if (this.openDialogPanel != null) {
                chooser.remove(this.openDialogPanel);
            }
            if (this.saveDialogPanel == null) {
                this.createSaveDialogPanel();
            }
            chooser.add((Component)this.saveDialogPanel, "Center");
            if (this.showPositionButton != null) {
                this.showPositionButton.setVisible(false);
                this.filenamePanel.setVisible(false);
            }
            if (this.createFolderButton != null) {
                this.createFolderButton.setVisible(true);
            }
            this.doMultiSelectionEnabledChanged(false);
        } else {
            if (this.saveDialogPanel != null) {
                chooser.remove(this.saveDialogPanel);
            }
            chooser.add((Component)this.openDialogPanel, "Center");
            if (this.showPositionButton != null) {
                this.showPositionButton.setVisible(true);
                this.filenamePanel.setVisible(true);
            }
            if (this.createFolderButton != null) {
                this.createFolderButton.setVisible(false);
            }
            this.saveDialogPanel = null;
        }
        if (this.approveButton != null) {
            this.approveButton.setText(this.getApproveButtonText(chooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
            this.approveButton.setAction(1 == chooser.getDialogType() ? this.getSaveClickedAction() : this.getOpenClickedAction());
        }
    }

    private void createSaveDialogPanel() {
        this.saveDialogPanel = new SaveDialogPanel(this.openDialogPanel);
        this.saveDialogPanel.addPropertyChangeListener(this);
        this.saveDialogPanel.addActionListener(this);
        this.saveDialogPanel.setExternalPath(this.getFileChooser().getCurrentDirectory().getAbsolutePath());
        this.saveDialogPanel.setExpanded(GtkFileChooserSettings.get().getExpandFolders());
    }

    private void doDirectoryChanged(File olddir, File newdir, Object source) {
        if (this.getFileChooser().getCurrentDirectory().equals(newdir)) {
            return;
        }
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        if (newdir != null) {
            PropertyChangeListener[] listeners;
            this.pathBarButtons.removeActionListener(this.pathBarActionListener);
            this.pathBarButtons.setCurrentDirectory(newdir);
            this.pathBarButtons.addActionListener(this.pathBarActionListener);
            this.updateFileNameField();
            if (!this.fileBrowserPane.equals(source)) {
                for (PropertyChangeListener listener : listeners = this.fileBrowserPane.getPropertyChangeListeners()) {
                    this.fileBrowserPane.removePropertyChangeListener(listener);
                }
                this.fileBrowserPane.setCurrentDir(newdir);
                for (PropertyChangeListener listener : listeners) {
                    this.fileBrowserPane.addPropertyChangeListener(listener);
                }
            }
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(newdir)) {
                    this.setFileName(newdir.getPath());
                } else {
                    this.setFileName(null);
                }
            }
            if (this.saveDialogPanel != null) {
                this.saveDialogPanel.setExternalPath(newdir.getAbsolutePath());
            }
            if (!fc.equals(source)) {
                for (PropertyChangeListener listener : listeners = fc.getPropertyChangeListeners()) {
                    fc.removePropertyChangeListener(listener);
                }
                fc.setCurrentDirectory(newdir);
                for (PropertyChangeListener listener : listeners) {
                    fc.addPropertyChangeListener(listener);
                }
            }
            this.pathAutoCompletion.setCurrentPath(newdir.getAbsolutePath());
            FileWatcher.theFileWatcher().unregister(olddir);
            FileWatcher.theFileWatcher().register(newdir);
        }
    }

    private void doFileHidingChanged(Boolean hide) {
        Boolean showHidden = hide == false;
        GtkFileChooserSettings.get().setShowHidden(showHidden);
        this.fileBrowserPane.setShowHidden(showHidden);
    }

    private void doFileSelectionModeChanged(Integer fileSelectionMode) {
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
        this.pathAutoCompletion.setFileSelectionMode(fileSelectionMode);
        this.fileBrowserPane.setFileSelectionMode(fileSelectionMode);
    }

    private void doFilterChanged(FileFilter filter) {
        this.fileBrowserPane.setCurrentFilter(filter);
        this.pathAutoCompletion.setCurrentFilter(filter);
        if (filter != null && !this.filterExists(filter)) {
            this.getFileChooser().addChoosableFileFilter(filter);
        }
        this.selectFilterInCombo();
        if (this.recentlyUsedPane != null) {
            new RecentlyUsedFileWorker(this).execute();
        }
        if (this.searchPanel != null) {
            this.searchPanel.setFileFilter(new FileFilterWrapper(filter));
        }
    }

    private boolean filterExists(FileFilter filter) {
        FileFilter[] filters;
        for (FileFilter f : filters = this.getFileChooser().getChoosableFileFilters()) {
            if (!f.getDescription().equals(filter.getDescription())) continue;
            return true;
        }
        return false;
    }

    private void doMultiSelectionEnabledChanged(Boolean multiSelectionEnabled) {
        int selectionMode;
        if (this.getFileChooser().getDialogType() == 1 && multiSelectionEnabled.booleanValue()) {
            return;
        }
        int n = selectionMode = multiSelectionEnabled != false ? 2 : 0;
        if (this.getRecentlyUsedPane() != null) {
            this.getRecentlyUsedPane().setSelectionMode(selectionMode);
        }
        if (this.searchFilesPane != null) {
            this.searchFilesPane.setSelectionMode(selectionMode);
        }
        this.fileBrowserPane.setIsMultiSelectionEnabled(multiSelectionEnabled);
    }

    private void doSelectedFileChanged(File file) {
        JFileChooser fc = this.getFileChooser();
        if (file != null && (fc.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(file));
        }
        if (file != null && !file.equals(fc.getSelectedFile())) {
            fc.setSelectedFile(file);
        }
        if (file != null && file.isDirectory()) {
            this.addBookmarkButton.setEnabled(true);
            this.addBookmarkButton.setToolTipText(I18N._("Add the folder '%s' to the bookmarks", file.getName()));
        } else {
            this.addBookmarkButton.setEnabled(false);
            this.addBookmarkButton.setToolTipText(null);
        }
        if (this.saveDialogPanel != null && file != null && !file.isDirectory()) {
            this.saveDialogPanel.setFilenameText(file.getName());
        }
    }

    private void doSelectedFilesChanged(File[] files) {
        JFileChooser fc = this.getFileChooser();
        if (files != null) {
            ArrayList<File> fileList = new ArrayList<File>();
            for (File file : files) {
                if (file.isDirectory()) {
                    if (!fc.isDirectorySelectionEnabled()) continue;
                    fileList.add(file);
                    continue;
                }
                fileList.add(file);
            }
            this.setFileName(this.fileNameString(fileList.toArray(new File[fileList.size()])));
        }
        if (files != null && !files.equals(fc.getSelectedFiles())) {
            fc.setSelectedFiles(files);
        }
        if (files != null) {
            boolean enable = true;
            for (File file : files) {
                if (file.isDirectory()) continue;
                enable = false;
                break;
            }
            this.addBookmarkButton.setEnabled(enable);
            this.addBookmarkButton.setToolTipText(I18N._("Add the selected folders to the bookmarks"));
        }
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() || fc.isDirectorySelectionEnabled() && fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystemRoot(file)) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] files) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (files.length <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    private void installListenersForBookmarksButtons() {
        this.locationsPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Path path = GtkFileChooserUI.this.locationsPane.getCurrentPath();
                if (path instanceof BookmarkManager.GtkBookmark) {
                    GtkFileChooserUI.this.removeBookmarkButton.setEnabled(true);
                    GtkFileChooserUI.this.removeBookmarkButton.setToolTipText(I18N._("Remove the bookmark '%s'", path.getName()));
                } else {
                    GtkFileChooserUI.this.removeBookmarkButton.setEnabled(false);
                    GtkFileChooserUI.this.removeBookmarkButton.setToolTipText(null);
                }
            }
        });
    }

    private void onClosing() {
        if (this.searchPanel != null) {
            this.searchPanel.stopSearch();
        }
        FileWatcher.theFileWatcher().stop();
    }

    private void selectFilterInCombo() {
        FileFilter filterInChooser = this.getFileChooser().getFileFilter();
        FileFilter filterInCombo = (FileFilter)this.filterComboBox.getSelectedItem();
        if (filterInChooser == null || filterInCombo == null) {
            return;
        }
        if (!filterInCombo.getDescription().equals(filterInChooser.getDescription())) {
            for (int i = 0; i < this.filterComboBox.getItemCount(); ++i) {
                FileFilter item = (FileFilter)this.filterComboBox.getItemAt(i);
                if (!item.getDescription().equals(filterInChooser.getDescription())) continue;
                this.filterComboBox.setSelectedIndex(i);
                break;
            }
        }
    }

    private void updateFileNameField() {
        this.pathAutoCompletion.setCurrentPath(this.getFileChooser().getCurrentDirectory().getAbsolutePath());
        this.fileNameTextField.setText("");
    }

    private FileFilter wrapFileFilter(final FileFilter filter) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return filter.accept(f);
            }

            @Override
            public String getDescription() {
                return filter.getDescription();
            }

            public String toString() {
                return this.getDescription();
            }
        };
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object value = e.getNewValue();
        if (value != null) {
            if (value.getClass().isArray() && ArrayUtil.areArrayEqual(value, e.getOldValue())) {
                return;
            }
            if (value.equals(e.getOldValue())) {
                return;
            }
        }
        String property = e.getPropertyName();
        Object source = e.getSource();
        Log.debug("Property: ", property, " = ", value, " ; source :", source.getClass());
        if ("directoryChanged".equals(property)) {
            this.doDirectoryChanged((File)e.getOldValue(), (File)value, source);
        } else if ("SelectedFileChangedProperty".equals(property)) {
            this.doSelectedFileChanged((File)value);
        } else if ("SelectedFilesChangedProperty".equals(property)) {
            this.doSelectedFilesChanged((File[])value);
        } else if ("ChoosableFileFilterChangedProperty".equals(property)) {
            this.doChoosableFileFilterChanged((FileFilter[])value);
        } else if (CURRENT_PANEL_CHANGED.equals(property)) {
            this.doCurrentPanelChanged((Integer)value);
        } else if ("fileFilterChanged".equals(property)) {
            this.doFilterChanged((FileFilter)value);
        } else if ("fileSelectionChanged".equals(property)) {
            this.doFileSelectionModeChanged((Integer)value);
        } else if ("FileHidingChanged".equals(property)) {
            this.doFileHidingChanged((Boolean)value);
        } else if ("MultiSelectionEnabledChangedProperty".equals(property)) {
            this.doMultiSelectionEnabledChanged((Boolean)value);
        } else if ("AccessoryChangedProperty".equals(property)) {
            this.doAccessoryChanged(e);
        } else if ("ApproveButtonTextChangedProperty".equals(property)) {
            this.doApproveButtonTextChanged(e);
        } else if ("ApproveButtonToolTipTextChangedProperty".equals(property)) {
            this.doApproveButtonTextChanged(e);
        } else if ("DialogTypeChangedProperty".equals(property)) {
            this.doDialogTypeChanged((Integer)value);
        } else if ("JFileChooserDialogIsClosingProperty".equals(property)) {
            this.onClosing();
        } else if ("ControlButtonsAreShownChangedProperty".equals(property)) {
            this.getButtonPanel().setVisible((Boolean)value);
        } else if (COMPONENT_ORIENTATION_PROPERTY.equals(property)) {
            this.doComponentOrientationChanged(e);
        } else if (ANCESTOR_PROPERTY.equals(property)) {
            this.doAncestorChanged(e);
        } else if ("expanded_status_changed".equals(property)) {
            boolean expanded = (Boolean)value;
            GtkFileChooserSettings.get().setExpandFolders(expanded);
            this.packSaveDialog(expanded);
        } else if ("fileViewChanged".equals(property)) {
            this.dofileViewChanged((FileView)value);
        }
    }

    private void packSaveDialog(boolean expand) {
        JDialog dialog = this.getAncestorDialog();
        if (dialog == null) {
            return;
        }
        Rectangle bound = GtkFileChooserSettings.get().getBound();
        Dimension size = dialog.getSize();
        if (size.width == 0 && size.height == 0) {
            size = bound != null ? new Dimension(bound.width, bound.height) : dialog.getPreferredSize();
        }
        if (expand) {
            if (this.expandedHeight == -1) {
                int n = this.expandedHeight = bound != null ? bound.height : MIN_EXPANDED_HEIGHT;
            }
            if (this.expandedHeight < MIN_EXPANDED_HEIGHT) {
                this.expandedHeight = MIN_EXPANDED_HEIGHT;
            }
            size.height = this.expandedHeight;
        } else {
            if (this.expandedHeight != -1) {
                this.expandedHeight = size.height;
            }
            size.height = MIN_HEIGHT;
        }
        if (dialog != null) {
            dialog.setPreferredSize(size);
            dialog.setSize(size);
        }
    }

    private JDialog getAncestorDialog() {
        JFileChooser fc = this.getFileChooser();
        Container parent = fc.getParent();
        JDialog dialog = null;
        while (parent != null) {
            if (!((parent = parent.getParent()) instanceof JDialog)) continue;
            dialog = (JDialog)parent;
            break;
        }
        return dialog;
    }

    private void doAncestorChanged(PropertyChangeEvent e) {
        if (e.getOldValue() == null && e.getNewValue() != null && e.getSource() instanceof JFileChooser) {
            FocusUtil.setFocusOrder(this.pathBarButtons, this.fileNameTextField, this.locationsPane.bookmarksTable, this.fileBrowserPane.table, this.filterComboBox, this.cancelButton, this.approveButton);
            this.fileNameTextField.selectAll();
            this.fileNameTextField.requestFocus();
            if (this.saveDialogPanel != null) {
                this.packSaveDialog(GtkFileChooserSettings.get().getExpandFolders());
            }
            FileWatcher.theFileWatcher().start();
        }
    }

    private void dofileViewChanged(FileView fileView) {
        this.fileBrowserPane.setFileView(fileView);
        this.recentlyUsedPane.setFileView(fileView);
        this.searchFilesPane.setFileView(fileView);
    }

    private void doComponentOrientationChanged(PropertyChangeEvent e) {
        ComponentOrientation o = (ComponentOrientation)e.getNewValue();
        JFileChooser cc = (JFileChooser)e.getSource();
        if (o != (ComponentOrientation)e.getOldValue()) {
            cc.applyComponentOrientation(o);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        Log.debug("GtkFileChooserUI: Action: ", e.getActionCommand());
        if ("ApproveSelection".equals(cmd)) {
            this.getFileChooser().setSelectedFile(this.fileBrowserPane.getSelectedFile());
            this.getFileChooser().setSelectedFiles(this.fileBrowserPane.getSelectedFiles());
            this.approveSelection();
        } else if ("Action Save".equals(cmd)) {
            this.approveButton.doClick();
        } else if ("AddBookmark".equals(cmd)) {
            this.addToBookmarks();
        } else if (ACTION_SELECTED_BOOKMARK.equals(cmd)) {
            File location = new File(this.locationsPane.getCurrentPath().getLocation());
            this.fireChangeDirectoryEvent(location);
        } else if ("location-popup".equals(cmd)) {
            if (this.getFileChooser().getDialogType() != 1) {
                this.showPositionButton.doClick();
            }
        } else if ("up-folder".equals(cmd)) {
            this.pathBarButtons.upFolder();
        } else if ("down-folder".equals(cmd)) {
            this.pathBarButtons.downFolder();
        } else if ("home-folder".equals(cmd)) {
            this.fireChangeDirectoryEvent(new File(System.getProperty("user.home")));
        } else if ("desktop-folder".equals(cmd)) {
            this.fireChangeDirectoryEvent(FreeDesktopUtil.getWellKnownDirPath(FreeDesktopUtil.WellKnownDir.DESKTOP));
        } else if ("quick-bookmark".equals(cmd)) {
            int id = e.getID();
            this.locationsPane.selectBookmark(id);
            File location = new File(this.locationsPane.getCurrentPath().getLocation());
            this.fireChangeDirectoryEvent(location);
        } else if (ACTION_CREATE_FOLDER.equals(cmd)) {
            this.fileBrowserPane.createFolder();
        }
    }

    private void fireChangeDirectoryEvent(File newDirectory) {
        this.propertyChange(new PropertyChangeEvent(this, "directoryChanged", this.getFileChooser().getCurrentDirectory(), newDirectory));
    }

    public static ComponentUI createUI(JComponent c) {
        GtkFileChooserUI ui = new GtkFileChooserUI((JFileChooser)c);
        return ui;
    }

    private abstract class SelectPathAction
    extends AbstractAction {
        private SelectPathAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File path = this.getSelectedPath();
            if (path == null) {
                return;
            }
            if (path.isDirectory()) {
                GtkFileChooserUI.this.fireChangeDirectoryEvent(path);
                if (GtkFileChooserUI.this.getFileChooser().getFileSelectionMode() == 1) {
                    GtkFileChooserUI.this.getFileChooser().setSelectedFile(path);
                    GtkFileChooserUI.this.approveSelection();
                }
            } else {
                GtkFileChooserUI.this.getFileChooser().setSelectedFile(path);
                GtkFileChooserUI.this.approveSelection();
            }
        }

        protected abstract File getSelectedPath();
    }
}

