/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Position;

public abstract class FindAction
extends AbstractAction
implements DocumentListener,
KeyListener {
    private JPanel searchPanel = new JPanel(new FlowLayout(0, 3, 3));
    protected JTextField searchField;
    private JPopupMenu popup = new JPopupMenu();
    private static final int TIMEOUT = 5;
    private long lastKeyPressed;
    private boolean stop = false;
    protected JComponent comp = null;
    protected boolean shiftDown = false;
    protected boolean controlDown = false;

    public FindAction() {
        super("Incremental Search");
        this.searchField = new JTextField(11);
        this.searchPanel.add(this.searchField);
        this.popup.add(this.searchPanel);
        this.searchField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindAction.this.popup.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.searchField) {
            this.popup.setVisible(false);
        } else {
            this.comp = (JComponent)ae.getSource();
            this.searchField.removeActionListener(this);
            this.searchField.removeKeyListener(this);
            this.searchField.getDocument().removeDocumentListener(this);
            this.initSearch(ae);
            this.searchField.addActionListener(this);
            this.searchField.addKeyListener(this);
            this.searchField.getDocument().addDocumentListener(this);
            JComponent parent = (JComponent)this.comp.getParent();
            Rectangle rect = parent.getVisibleRect();
            int x = rect.x + rect.width - this.popup.getPreferredSize().width;
            int y = rect.y + rect.height - this.popup.getPreferredSize().height;
            this.popup.show(this.comp, x, y);
            this.searchField.requestFocus();
        }
    }

    protected void initSearch(ActionEvent ae) {
        this.searchField.setText(ae.getActionCommand());
        this.changed(null);
    }

    private void changed(Position.Bias bias) {
        this.popup.pack();
        this.searchField.requestFocus();
        Color color = this.changed(this.comp, this.searchField.getText(), bias) ? Color.BLACK : Color.RED;
        this.searchField.setForeground(color);
        this.lastKeyPressed = System.currentTimeMillis();
    }

    protected abstract boolean changed(JComponent var1, String var2, Position.Bias var3);

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changed(null);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changed(null);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        this.shiftDown = ke.isShiftDown();
        this.controlDown = ke.isControlDown();
        switch (ke.getKeyCode()) {
            case 38: {
                this.changed(Position.Bias.Backward);
                break;
            }
            case 40: {
                this.changed(Position.Bias.Forward);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void install(final JComponent comp) {
        comp.addKeyListener(new KeyAdapter(){
            private static final int ALT_KEY = 65535;
            private boolean isSearchEnabled = true;

            @Override
            public void keyPressed(KeyEvent e) {
                char ch = e.getKeyChar();
                if ('\uffff' == ch) {
                    this.isSearchEnabled = false;
                }
                if (Character.isLetterOrDigit(ch) && this.isSearchEnabled) {
                    ActionEvent ae = new ActionEvent(comp, 1001, String.valueOf(ch));
                    FindAction.this.actionPerformed(ae);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                char ch = e.getKeyChar();
                if ('\uffff' == ch) {
                    this.isSearchEnabled = true;
                }
            }
        });
        new Thread("GTK-File-Chooser Popup-Monitor"){

            @Override
            public void run() {
                try {
                    while (!FindAction.this.stop) {
                        if (FindAction.this.popup.isShowing()) {
                            long timeWaited = System.currentTimeMillis() - FindAction.this.lastKeyPressed;
                            long timeRemaining = Math.max(5000L - timeWaited, 0L);
                            if (timeRemaining == 0L) {
                                FindAction.this.popup.setVisible(false);
                                continue;
                            }
                            3.sleep(timeRemaining);
                            continue;
                        }
                        3.sleep(5000L);
                    }
                }
                catch (InterruptedException exc) {
                    throw new RuntimeException(exc);
                }
            }
        }.start();
        comp.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("ancestor".equals(evt.getPropertyName()) && evt.getNewValue() == null) {
                    FindAction.this.stop = true;
                }
            }
        });
    }
}

