/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;

public class ExpanderIcon
implements Icon {
    private int w = 18;
    private int h = 18;
    private int mx = 5;
    private int my = 2;
    private boolean down = false;
    public boolean filled = false;

    public ExpanderIcon(boolean down, boolean filled) {
        this.down = down;
        this.filled = filled;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath triangle = new GeneralPath();
        if (this.down) {
            triangle.moveTo(this.my, this.mx);
            triangle.lineTo(this.w - this.my, this.mx);
            triangle.lineTo(this.w / 2, this.h - this.mx);
            triangle.closePath();
        } else {
            triangle.moveTo(this.mx, this.my);
            triangle.lineTo(this.w - this.mx, this.h / 2);
            triangle.lineTo(this.mx, this.h - this.my);
            triangle.closePath();
        }
        if (this.filled) {
            g2d.fill(triangle);
        } else {
            g2d.draw(triangle);
        }
        g2d.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.down ? this.h : this.w;
    }

    @Override
    public int getIconHeight() {
        return this.down ? this.w : this.h;
    }

    public static enum Orientation {
        RIGHT,
        DOWN;

    }
}

