/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public abstract class Autocompleter {
    public static final String ACTION_PERFORMED_ACCEPT_SUGGESTION = "accept_suggestion";
    private static final String AUTOCOMPLETER = "AUTOCOMPLETER";
    private DocumentListener documentListener;
    private JList list;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private JPopupMenu popup;
    private JTextField textComp;

    public Autocompleter(JTextField comp) {
        this.textComp = comp;
        this.textComp.putClientProperty(AUTOCOMPLETER, this);
        this.list = new JList(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = Autocompleter.this.textComp.getWidth() - ((Autocompleter)Autocompleter.this).textComp.getInsets().right;
                return dim;
            }
        };
        this.list.setCellRenderer(this.getCellRenderer());
        this.addListListeners();
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setBorder(null);
        this.list.setFocusable(false);
        scroll.getVerticalScrollBar().setFocusable(false);
        scroll.getHorizontalScrollBar().setFocusable(false);
        this.popup = new JPopupMenu();
        this.popup.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.popup.add(scroll);
        AbstractAction showAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Autocompleter.this.textComp.isEnabled()) {
                    if (Autocompleter.this.popup.isVisible()) {
                        Autocompleter.this.selectNextPossibleValue();
                    } else {
                        Autocompleter.this.showPopup(true);
                    }
                }
            }
        };
        this.textComp.registerKeyboardAction(showAction, KeyStroke.getKeyStroke(40, 0), 0);
        this.documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!Autocompleter.this.textComp.hasFocus()) {
                    return;
                }
                Autocompleter.this.showPopup(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!Autocompleter.this.textComp.hasFocus()) {
                    return;
                }
                if (e.getDocument().getLength() > 0) {
                    Autocompleter.this.showPopup(false);
                } else {
                    Autocompleter.this.popup.setVisible(false);
                }
            }
        };
        this.textComp.getDocument().addDocumentListener(this.documentListener);
        AbstractAction upAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Autocompleter.this.textComp.isEnabled() && Autocompleter.this.popup.isVisible()) {
                    Autocompleter.this.selectPreviousPossibleValue();
                }
            }
        };
        this.textComp.registerKeyboardAction(upAction, KeyStroke.getKeyStroke(38, 0), 0);
        this.textComp.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Autocompleter.this.textComp.isEnabled()) {
                    Autocompleter.this.popup.setVisible(false);
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Autocompleter.this.textComp.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        this.list.setRequestFocusEnabled(false);
    }

    protected ListCellRenderer getCellRenderer() {
        return new DefaultListCellRenderer();
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public JTextComponent getTextComponent() {
        return this.textComp;
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    private void acceptSuggestion() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Autocompleter.this.popup.setVisible(false);
                String selected = (String)Autocompleter.this.list.getSelectedValue();
                if (selected == null) {
                    return;
                }
                int caretPosition = Autocompleter.this.textComp.getCaretPosition();
                if (caretPosition >= selected.length()) {
                    return;
                }
                try {
                    String append = Autocompleter.this.completion(selected, caretPosition);
                    Autocompleter.this.textComp.getDocument().removeDocumentListener(Autocompleter.this.documentListener);
                    Autocompleter.this.textComp.getDocument().insertString(caretPosition, append, null);
                    Autocompleter.this.textComp.getDocument().addDocumentListener(Autocompleter.this.documentListener);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                ActionEvent e = new ActionEvent(this, 1001, Autocompleter.ACTION_PERFORMED_ACCEPT_SUGGESTION);
                Autocompleter.this.fireActionEvent(e);
            }
        });
    }

    protected String completion(String selected, int caretPosition) {
        return selected.substring(caretPosition);
    }

    private void addListListeners() {
        this.list.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = Autocompleter.this.list.locationToIndex(e.getPoint());
                Autocompleter.this.list.setSelectedIndex(index);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Autocompleter.this.acceptSuggestion();
            }
        });
    }

    private void selectNextPossibleValue() {
        int si = this.list.getSelectedIndex();
        if (si < this.list.getModel().getSize() - 1) {
            this.list.setSelectedIndex(si + 1);
            this.list.ensureIndexIsVisible(si + 1);
        }
    }

    private void selectPreviousPossibleValue() {
        int si = this.list.getSelectedIndex();
        if (si > 0) {
            this.list.setSelectedIndex(si - 1);
            this.list.ensureIndexIsVisible(si - 1);
        }
    }

    private void selectText(final int selectionStart, final int selectionEnd) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Autocompleter.this.textComp.select(selectionStart, selectionEnd);
            }
        });
    }

    private void setSuggestions(List<String> suggestions) {
        this.list.setListData(suggestions.toArray(new String[suggestions.size()]));
    }

    private void showPopup(boolean completeSingle) {
        if (!this.textComp.isShowing()) {
            return;
        }
        this.popup.setVisible(false);
        List<String> suggestions = this.updateSuggestions(this.textComp.getText());
        if (this.textComp.isEnabled() && suggestions != null && suggestions.size() > 0) {
            this.setSuggestions(suggestions);
            AbstractAction acceptAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Autocompleter.this.acceptSuggestion();
                }
            };
            this.textComp.registerKeyboardAction(acceptAction, KeyStroke.getKeyStroke(10, 0), 0);
            int size = this.list.getModel().getSize();
            if (size == 1 && completeSingle) {
                this.list.setSelectedIndex(0);
                int selectionStart = this.textComp.getCaretPosition() + 1;
                int selectionEnd = ((String)this.list.getSelectedValue()).length();
                this.acceptSuggestion();
                this.textComp.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
                this.selectText(selectionStart, selectionEnd);
                return;
            }
            this.list.setVisibleRowCount(size < 10 ? size : 10);
            try {
                int pos = (int)this.textComp.getAlignmentX();
                int offset = this.textComp.getInsets().left;
                int x = this.textComp.getUI().modelToView((JTextComponent)this.textComp, (int)pos).x - offset;
                this.popup.show(this.textComp, x, this.textComp.getHeight());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else {
            this.popup.setVisible(false);
        }
        this.textComp.requestFocus();
    }

    protected void fireActionEvent(ActionEvent evt) {
        for (ActionListener l : this.listeners) {
            l.actionPerformed(evt);
        }
    }

    protected abstract List<String> updateSuggestions(String var1);
}

