/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Strftime
extends DateFormat {
    protected static Map<Character, String> translate = new HashMap<Character, String>();
    private final SimpleDateFormat simpleDateFormat;

    public Strftime(String origFormat) {
        this(origFormat, Locale.getDefault());
    }

    public Strftime(String origFormat, Locale locale) {
        String convertedFormat = this.convertDateFormat(origFormat);
        this.simpleDateFormat = new SimpleDateFormat(convertedFormat, locale);
        this.setCalendar(this.simpleDateFormat.getCalendar());
        this.setNumberFormat(this.simpleDateFormat.getNumberFormat());
    }

    private String convertDateFormat(String pattern) {
        char lastChar;
        boolean inside = false;
        boolean mark = false;
        boolean modifiedCommand = false;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '%' && !mark) {
                mark = true;
                continue;
            }
            if (mark) {
                if (modifiedCommand) {
                    modifiedCommand = false;
                    mark = false;
                    continue;
                }
                inside = this.translateCommand(buf, pattern, i, inside);
                if (c == 'O' || c == 'E') {
                    modifiedCommand = true;
                    continue;
                }
                mark = false;
                continue;
            }
            if (!inside && c != ' ') {
                buf.append("'");
                inside = true;
            }
            buf.append(c);
        }
        if (buf.length() > 0 && (lastChar = buf.charAt(buf.length() - 1)) != '\'' && inside) {
            buf.append('\'');
        }
        return buf.toString();
    }

    private String quote(String str, boolean insideQuotes) {
        String retVal = str;
        if (!insideQuotes) {
            retVal = '\'' + retVal + '\'';
        }
        return retVal;
    }

    private boolean translateCommand(StringBuffer buf, String pattern, int index, boolean oldInside) {
        char firstChar = pattern.charAt(index);
        boolean newInside = oldInside;
        if (firstChar == 'O' || firstChar == 'E') {
            if (index + 1 < pattern.length()) {
                newInside = this.translateCommand(buf, pattern, index + 1, oldInside);
            } else {
                buf.append(this.quote("%" + firstChar, oldInside));
            }
        } else {
            String command = translate.get(Character.valueOf(firstChar));
            if (command == null) {
                buf.append(this.quote("%" + firstChar, oldInside));
            } else {
                if (oldInside) {
                    buf.append('\'');
                }
                buf.append(command);
                newInside = false;
            }
        }
        return newInside;
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this.simpleDateFormat.format(date, toAppendTo, fieldPosition);
    }

    @Override
    public Date parse(String text, ParsePosition pos) {
        return this.simpleDateFormat.parse(text, pos);
    }

    static {
        translate.put(Character.valueOf('a'), "EEE");
        translate.put(Character.valueOf('A'), "EEEE");
        translate.put(Character.valueOf('b'), "MMM");
        translate.put(Character.valueOf('B'), "MMMM");
        translate.put(Character.valueOf('c'), "EEE d MMM yyyy HH:mm:ss z");
        translate.put(Character.valueOf('d'), "dd");
        translate.put(Character.valueOf('D'), "MM/dd/yy");
        translate.put(Character.valueOf('e'), "dd");
        translate.put(Character.valueOf('F'), "yyyy-MM-dd");
        translate.put(Character.valueOf('g'), "yy");
        translate.put(Character.valueOf('G'), "yyyy");
        translate.put(Character.valueOf('H'), "HH");
        translate.put(Character.valueOf('h'), "MMM");
        translate.put(Character.valueOf('I'), "hh");
        translate.put(Character.valueOf('j'), "DDD");
        translate.put(Character.valueOf('k'), "HH");
        translate.put(Character.valueOf('l'), "hh");
        translate.put(Character.valueOf('m'), "MM");
        translate.put(Character.valueOf('M'), "mm");
        translate.put(Character.valueOf('n'), "\n");
        translate.put(Character.valueOf('p'), "a");
        translate.put(Character.valueOf('P'), "a");
        translate.put(Character.valueOf('r'), "hh:mm:ss a");
        translate.put(Character.valueOf('R'), "HH:mm");
        translate.put(Character.valueOf('S'), "ss");
        translate.put(Character.valueOf('t'), "\t");
        translate.put(Character.valueOf('T'), "HH:mm:ss");
        translate.put(Character.valueOf('V'), "ww");
        translate.put(Character.valueOf('X'), "HH:mm:ss");
        translate.put(Character.valueOf('x'), "MM/dd/yy");
        translate.put(Character.valueOf('y'), "yy");
        translate.put(Character.valueOf('Y'), "yyyy");
        translate.put(Character.valueOf('Z'), "z");
        translate.put(Character.valueOf('z'), "Z");
        translate.put(Character.valueOf('%'), "%");
    }
}

