/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import eu.kostia.gtkjfilechooser.BasicPath;

public class RemovableDevice
extends BasicPath {
    private static final long serialVersionUID = 1L;
    private RemovableDeviceType type;

    public void setName(String name) {
        this.name = name;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public RemovableDeviceType getType() {
        return this.type;
    }

    public void setType(RemovableDeviceType type) {
        this.type = type;
    }

    @Override
    public String getIconName() {
        return "devices/" + this.type.toIconName();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RemovableDevice [name=");
        builder.append(this.name);
        builder.append(", location=");
        builder.append(this.location);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append(", iconName=");
        builder.append(this.getIconName());
        builder.append("]");
        return builder.toString();
    }

    public static enum RemovableDeviceType {
        GNOME_DEV_HARDDISK_USB,
        GNOME_DEV_REMOVABLE_USB,
        GNOME_DEV_DISC_DVDROM,
        GNOME_DEV_MEDIA_SDMMC,
        GNOME_DEV_REMOVABLE;


        public String toIconName() {
            return this.toString().toLowerCase().replace('_', '-');
        }

        public static RemovableDeviceType getType(String dev) {
            if (dev.startsWith("/dev/sdb")) {
                return GNOME_DEV_HARDDISK_USB;
            }
            if (dev.startsWith("/dev/sdc")) {
                return GNOME_DEV_REMOVABLE_USB;
            }
            if (dev.startsWith("/dev/sr")) {
                return GNOME_DEV_DISC_DVDROM;
            }
            if (dev.startsWith("/dev/mmc")) {
                return GNOME_DEV_MEDIA_SDMMC;
            }
            return GNOME_DEV_REMOVABLE;
        }
    }
}

