/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import eu.kostia.gtkjfilechooser.BasicActionDispatcher;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class NavigationKeyBinding
extends BasicActionDispatcher {
    public static final String LOCATION_POPUP = "location-popup";
    public static final String UP_FOLDER = "up-folder";
    public static final String DOWN_FOLDER = "down-folder";
    public static final String HOME_FOLDER = "home-folder";
    public static final String DESKTOP_FOLDER = "desktop-folder";
    public static final String QUICK_BOOKMARK = "quick-bookmark";
    private JComponent component;

    public NavigationKeyBinding(JComponent component) {
        this.component = component;
        this.bindKeyAction();
    }

    private void bindKeyAction() {
        KeyStroke altDigit;
        int i;
        KeyStroke ctrlL = KeyStroke.getKeyStroke(76, 128);
        this.bind(ctrlL, -1, LOCATION_POPUP);
        KeyStroke altUp = KeyStroke.getKeyStroke(38, 512);
        this.bind(altUp, -1, UP_FOLDER);
        KeyStroke altDown = KeyStroke.getKeyStroke(40, 512);
        this.bind(altDown, -1, DOWN_FOLDER);
        KeyStroke altHome = KeyStroke.getKeyStroke(36, 512);
        this.bind(altHome, -1, HOME_FOLDER);
        KeyStroke altD = KeyStroke.getKeyStroke(68, 512);
        this.bind(altD, -1, DESKTOP_FOLDER);
        for (i = 48; i <= 57; ++i) {
            altDigit = KeyStroke.getKeyStroke(i, 512);
            this.bind(altDigit, i - 48, QUICK_BOOKMARK);
        }
        for (i = 96; i <= 105; ++i) {
            altDigit = KeyStroke.getKeyStroke(i, 512);
            this.bind(altDigit, i - 96, QUICK_BOOKMARK);
        }
    }

    private void bind(KeyStroke key, final int id, final String actionName) {
        if (actionName == null) {
            throw new IllegalArgumentException("The action must have a name.");
        }
        this.component.getInputMap(2).put(key, actionName + "_" + id);
        this.component.getActionMap().put(actionName + "_" + id, new AbstractAction(actionName){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent evt = new ActionEvent(NavigationKeyBinding.this, id, actionName);
                NavigationKeyBinding.this.fireActionEvent(evt);
            }
        });
    }
}

