/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import eu.kostia.gtkjfilechooser.ui.GtkFileChooserUI;
import java.lang.reflect.Array;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Log {
    private static final Logger LOG = Logger.getLogger(GtkFileChooserUI.class.getName());
    private static final boolean DEBUG = false;

    public static void debug0(Object ... msgs) {
    }

    public static void debug(Object ... msgs) {
        if (LOG.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder();
            Log.appendMessages(sb, msgs);
            LOG.finest(sb.toString());
        }
    }

    public static void log(Level level, Object ... msgs) {
        if (LOG.isLoggable(Level.WARNING)) {
            StringBuilder sb = new StringBuilder();
            Log.appendMessages(sb, msgs);
            LOG.log(level, sb.toString());
        }
    }

    public static void log(Level level, Throwable thrown, Object ... msgs) {
        if (LOG.isLoggable(Level.WARNING)) {
            StringBuilder sb = new StringBuilder();
            Log.appendMessages(sb, msgs);
            LOG.log(level, sb.toString(), thrown);
        }
    }

    private static void appendMessages(StringBuilder sb, Object ... msgs) {
        for (Object msg : msgs) {
            if (msg == null) {
                sb.append("null");
                continue;
            }
            if (msg.getClass().isArray()) {
                int len = Array.getLength(msg);
                for (int i = 0; i < len; ++i) {
                    sb.append(Array.get(msg, i));
                    if (i == len - 1) continue;
                    sb.append(", ");
                }
                continue;
            }
            sb.append(String.valueOf(msg));
        }
    }

    private static String getInvokingLocation() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String location = null;
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement s = stackTrace[i];
            if (!Log.class.getName().equals(s.getClassName()) || !"debug".equals(s.getMethodName())) continue;
            StackTraceElement next = stackTrace[i + 1];
            location = next.getClassName() + "." + next.getMethodName() + "(" + next.getFileName() + ":" + next.getLineNumber() + ")";
        }
        return location;
    }

    public static void main(String[] args) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Log.debug("ciao");
            }
        }).start();
    }
}

