/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import eu.kostia.gtkjfilechooser.I18N;
import eu.kostia.gtkjfilechooser.Strftime;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static String toPrettyFormat(Date date) {
        return DateUtil.toPrettyFormat(date, new Date());
    }

    static String toPrettyFormat(Date d, Date today) {
        long days_diff = DateUtil.toJulianDayNumber(today) - DateUtil.toJulianDayNumber(d);
        if (days_diff == 0L) {
            return String.format("%tR", d);
        }
        if (days_diff == 1L) {
            String mgsstr = I18N._("Yesterday at %H:%M");
            return new Strftime(mgsstr).format(d);
        }
        if (days_diff > 1L && days_diff < 7L) {
            return String.format("%tA", d);
        }
        return DateFormat.getDateInstance(3).format(d);
    }

    public static long toJulianDayNumber(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int Y = cal.get(1);
        int M = cal.get(2) + 1;
        int D = cal.get(5);
        return 1461 * (Y + 4800 + (M - 14) / 12) / 4 + 367 * (M - 2 - 12 * ((M - 14) / 12)) / 12 - 3 * ((Y + 4900 + (M - 14) / 12) / 100) / 4 + D - 32075;
    }
}

