/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import eu.kostia.gtkjfilechooser.BasicPath;
import eu.kostia.gtkjfilechooser.UrlUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class BookmarkManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private File bookmarkfile = new File(System.getProperty("user.home") + File.separator + ".gtk-bookmarks");

    public GtkBookmark add(File dir, String name) {
        if (!dir.exists()) {
            throw new IllegalArgumentException(dir + " doesn't exist.");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " isn't a directory.");
        }
        if (name == null) {
            name = dir.getName();
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(this.bookmarkfile, true));
            GtkBookmark gtkBookmark = new GtkBookmark(name, dir);
            pw.println(gtkBookmark.toGtkString());
            GtkBookmark gtkBookmark2 = gtkBookmark;
            return gtkBookmark2;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public void delete(String name) {
        String[] lines = null;
        PrintWriter pw = null;
        try {
            lines = this.toStringArray(this.bookmarkfile);
            pw = new PrintWriter(new FileWriter(this.bookmarkfile, false));
            for (String line : lines) {
                String currentName = null;
                int spaceIndex = line.indexOf(32);
                if (spaceIndex != -1) {
                    currentName = line.substring(spaceIndex + 1);
                } else {
                    int lastSeparator = line.lastIndexOf(File.separatorChar);
                    currentName = line.substring(lastSeparator + 1);
                }
                currentName = UrlUtil.decode(currentName);
                if (currentName.equals(name)) continue;
                pw.println(line);
            }
        }
        catch (Exception e) {
            throw new IOError(e);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public void rename(String oldName, String newName) {
        String[] lines = null;
        PrintWriter pw = null;
        try {
            lines = this.toStringArray(this.bookmarkfile);
            pw = new PrintWriter(new FileWriter(this.bookmarkfile, false));
            for (String line : lines) {
                String currentName = null;
                String location = null;
                int spaceIndex = line.indexOf(32);
                if (spaceIndex != -1) {
                    currentName = line.substring(spaceIndex + 1);
                    location = line.substring(0, spaceIndex);
                } else {
                    int lastSeparator = line.lastIndexOf(File.separatorChar);
                    currentName = line.substring(lastSeparator + 1);
                    location = line;
                }
                if (currentName.equals(oldName)) {
                    pw.println(location + " " + newName);
                    continue;
                }
                pw.println(line);
            }
        }
        catch (Exception e) {
            throw new IOError(e);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public List<GtkBookmark> getAll() {
        ArrayList<GtkBookmark> bookmarks = new ArrayList<GtkBookmark>();
        if (!this.bookmarkfile.exists()) {
            return new ArrayList<GtkBookmark>();
        }
        Scanner sc = null;
        try {
            sc = new Scanner(this.bookmarkfile);
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                if (line.indexOf("/.Trash/") != -1) continue;
                String name = null;
                String dir = null;
                int spaceIndex = line.indexOf(32);
                if (spaceIndex != -1) {
                    name = line.substring(spaceIndex + 1);
                    dir = line.substring(0, spaceIndex);
                } else {
                    int lastSeparator = line.lastIndexOf(File.separatorChar);
                    name = line.substring(lastSeparator + 1);
                    dir = line;
                }
                if (!dir.startsWith("file://")) continue;
                dir = dir.substring("file://".length());
                bookmarks.add(new GtkBookmark(UrlUtil.decode(name), UrlUtil.decode(dir)));
            }
        }
        catch (Exception e) {
            throw new IOError(e);
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
        return bookmarks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] toStringArray(File source) throws IOException {
        Scanner sc = new Scanner(source);
        try {
            ArrayList<String> lines = new ArrayList<String>();
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                lines.add(line);
            }
            String[] stringArray = lines.toArray(new String[lines.size()]);
            return stringArray;
        }
        finally {
            sc.close();
        }
    }

    public class GtkBookmark
    extends BasicPath {
        private static final long serialVersionUID = 1L;

        public GtkBookmark() {
        }

        public GtkBookmark(String name, String location) {
            this.setName(name);
            this.setLocation(location);
        }

        public GtkBookmark(String name, File location) {
            this.setName(name);
            this.setLocation(location.getAbsolutePath());
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public String toGtkString() {
            String loc = UrlUtil.encode(this.getLocation());
            return "file://" + loc + " " + this.getName();
        }

        public String toString() {
            return this.getName() + " = " + this.getLocation();
        }

        @Override
        public String getIconName() {
            return "gtk-directory";
        }
    }
}

