/*
 * Decompiled with CFR 0.152.
 */
package endrov.starter;

import endrov.core.EvBuild;
import endrov.util.io.EvFileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OldStart {
    private static boolean printJar = false;
    public String mainClass = "";
    private final String javaver = System.getProperty("java.specification.version");
    private final String arch = System.getProperty("os.arch").toLowerCase();
    private final int javaVerMajor = Integer.parseInt(this.javaver.substring(0, this.javaver.indexOf(46)));
    private final int javaVerMinor = Integer.parseInt(this.javaver.substring(this.javaver.indexOf(46) + 1));
    private String OS = System.getProperty("os.name").toLowerCase();
    private String javaexe = "java";
    private LinkedList<String> platformExt = new LinkedList();
    public List<String> jarfiles = new LinkedList<String>();
    public List<String> binfiles = new LinkedList<String>();

    public static void main(String[] args) {
        new OldStart().run(args);
    }

    public void collectSystemInfo(String path) {
        this.collectSystemInfo(new File(path));
    }

    public void collectSystemInfo(File path) {
        this.platformExt.clear();
        if (this.arch.equals("ppc")) {
            this.platformExt.add("ppc");
        } else {
            this.platformExt.add("x86");
        }
        if (this.OS.equals("mac os x")) {
            this.platformExt.add("mac");
        } else if (this.OS.startsWith("windows")) {
            this.platformExt.add("windows");
        } else if (this.OS.startsWith("linux")) {
            this.platformExt.add("linux");
        } else if (this.OS.startsWith("solaris")) {
            this.platformExt.add("solaris");
        } else {
            JOptionPane.showMessageDialog(null, "Your OS + CPU combination is not supported at this moment. We would be happy if you got in\ntouch so we can support for your platform. If you want to do it yourself it is easy: Get\nlibraries for your platform (JAI and JOGL), edit endrov/starter/StartGUI.java and recompile.");
            System.exit(1);
        }
        String libpath = System.getProperty("java.library.path");
        if (libpath != null) {
            StringTokenizer stok = new StringTokenizer(libpath, File.pathSeparator);
            while (stok.hasMoreTokens()) {
                String s = stok.nextToken();
                if (s.equals(".")) continue;
                this.binfiles.add(s);
                File[] fileArray = new File(s).listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.getName().endsWith(".jar") || f.getName().endsWith(".zip")) {
                        this.jarfiles.add(f.getAbsolutePath());
                    }
                    ++n2;
                }
            }
        }
        this.jarfiles.add(path.getAbsolutePath());
        OldStart.collectJars(this.jarfiles, this.binfiles, new File(path, "libs"), this.platformExt);
        System.out.println(this.binfiles);
    }

    public String getJarString() {
        String jarstring = "";
        for (String s : this.jarfiles) {
            if (!jarstring.equals("")) {
                jarstring = String.valueOf(jarstring) + File.pathSeparatorChar;
            }
            jarstring = String.valueOf(jarstring) + s;
        }
        return jarstring;
    }

    public String getBinString() {
        String binstring = "";
        for (String s : this.binfiles) {
            if (!binstring.equals("")) {
                binstring = String.valueOf(binstring) + File.pathSeparatorChar;
            }
            binstring = String.valueOf(binstring) + s;
        }
        return binstring;
    }

    private static void addJar(List<String> v, String toadd) {
        v.add(toadd);
        if (printJar) {
            System.out.println("Adding java library: " + toadd);
        }
    }

    private static void collectJars(List<String> v, List<String> binfiles, File p, Collection<String> platformExt) {
        if (p.exists()) {
            File[] fileArray = p.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File sub = fileArray[n2];
                if (sub.isFile() && (sub.getName().endsWith(".jar") || sub.getName().endsWith(".zip"))) {
                    OldStart.addJar(v, sub.getAbsolutePath());
                } else if (sub.isFile() && sub.getName().endsWith(".paths")) {
                    try {
                        String line;
                        BufferedReader input = new BufferedReader(new FileReader(sub));
                        while ((line = input.readLine()) != null) {
                            if (line.startsWith("j:")) {
                                OldStart.addJar(v, line.substring(2));
                                continue;
                            }
                            binfiles.add(line.substring(2));
                        }
                        input.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (sub.isDirectory() && sub.getName().endsWith("_inc") && !sub.getName().startsWith(".") && !sub.getName().equals("unused")) {
                    OldStart.collectJars(v, binfiles, sub, platformExt);
                } else {
                    for (String oneExt : platformExt) {
                        if (!sub.isDirectory() || !sub.getName().equals("bin_" + oneExt)) continue;
                        OldStart.collectJars(v, binfiles, sub, platformExt);
                        String toadd = sub.getAbsolutePath();
                        binfiles.add(toadd);
                        if (!printJar) continue;
                        System.out.println("Adding binary directory: " + toadd);
                    }
                }
                ++n2;
            }
        }
    }

    public void run(String[] argsa) {
        boolean printMacStarter = false;
        boolean hasSpecifiedLibdir = false;
        boolean printCommand = false;
        File javaenvFile = null;
        File basedir = new File(".");
        boolean oldway = false;
        LinkedList<String> args = new LinkedList<String>();
        int argi = 0;
        while (argi < argsa.length) {
            String curarg = argsa[argi];
            if (curarg.equals("--printcommand")) {
                printCommand = true;
            } else if (curarg.equals("--printjar")) {
                printJar = true;
            } else if (curarg.equals("--macstarter")) {
                this.OS = "mac os x";
                printMacStarter = true;
            } else if (args.contains("--version")) {
                System.out.println("Endrov " + EvBuild.version);
                System.exit(0);
            } else if (curarg.equals("--cp2")) {
                this.jarfiles.add(argsa[argi + 1]);
                ++argi;
            } else if (curarg.equals("--libpath2")) {
                this.binfiles.add(argsa[argi + 1]);
                ++argi;
            } else if (curarg.equals("--basedir")) {
                basedir = new File(argsa[argi + 1]);
                ++argi;
            } else if (curarg.equals("--main")) {
                this.mainClass = argsa[argi + 1];
                ++argi;
            } else if (curarg.equals("--javaenv")) {
                javaenvFile = new File(argsa[argi + 1]);
                ++argi;
            } else if (curarg.equals("--archinfo")) {
                System.out.println("This system runs OS:" + this.OS + " with java:" + this.javaver + " on arch:" + this.arch);
            } else if (curarg.equals("--oldway")) {
                oldway = true;
            } else {
                args.add(curarg);
            }
            ++argi;
        }
        this.collectSystemInfo(basedir);
        if (oldway) {
            this.run2normal(hasSpecifiedLibdir, printCommand, printMacStarter, javaenvFile, basedir, argsa);
        }
    }

    private void run2normal(boolean hasSpecifiedLibdir, boolean printCommand, boolean printMacStarter, File javaenvFile, File basedir, String[] argsa) {
        if (this.javaVerMajor > 1 || this.javaVerMajor == 1 && this.javaVerMinor >= 5) {
            try {
                String line;
                Object tok;
                LinkedList<String> cmdarg = new LinkedList<String>();
                cmdarg.add(this.javaexe);
                cmdarg.add("-cp");
                cmdarg.add(this.getJarString());
                String libdir = this.getBinString();
                if (!libdir.equals("") && !hasSpecifiedLibdir) {
                    cmdarg.add("-Djava.library.path=" + libdir);
                }
                if (javaenvFile == null) {
                    javaenvFile = new File(new File("config"), "javaenv." + this.platformExt + ".txt");
                }
                if (javaenvFile.exists()) {
                    BufferedReader envReader = new BufferedReader(new FileReader(javaenvFile));
                    String line2 = envReader.readLine();
                    if (line2 != null) {
                        StringTokenizer envTokenizer = new StringTokenizer(line2, " ");
                        while (envTokenizer.hasMoreTokens()) {
                            tok = envTokenizer.nextToken();
                            cmdarg.add((String)tok);
                            System.out.println("Java environment flag: " + (String)tok);
                        }
                    }
                    envReader.close();
                }
                cmdarg.add(this.mainClass);
                tok = argsa;
                int envTokenizer = argsa.length;
                int line2 = 0;
                while (line2 < envTokenizer) {
                    String s = tok[line2];
                    cmdarg.add(s);
                    ++line2;
                }
                if (printMacStarter) {
                    StringTokenizer t = new StringTokenizer(this.getJarString(), ":");
                    File dot = new File(".");
                    int dotlen = dot.getAbsolutePath().length() - 1;
                    Object tot = "";
                    while (t.hasMoreTokens()) {
                        String s = t.nextToken();
                        if (!((String)tot).equals("")) {
                            tot = String.valueOf(tot) + ":";
                        }
                        tot = String.valueOf(tot) + "$APPLICATION/../" + s.substring(dotlen);
                    }
                    System.out.println((String)tot);
                    File dotdir = new File(".");
                    String loclibdir = libdir.replace(String.valueOf(dotdir.getAbsolutePath()) + "/", "");
                    String[] stringArray = new String[]{"Endrov.app", "ImServ.app", "OSTdaemon.app"};
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String app = stringArray[n2];
                        String template = EvFileUtil.readFile((File)new File(String.valueOf(app) + "/Contents/Resources/preinfo.txt"));
                        File out = new File(String.valueOf(app) + "/Contents/Info.plist");
                        EvFileUtil.writeFile((File)out, (String)template.replace("JARLIST", (CharSequence)tot).replace("SOLIST", loclibdir));
                        System.out.println("Wrote to " + out);
                        ++n2;
                    }
                    FileWriter fw = new FileWriter(new File("Endrov.app/Contents/Resources/jars.txt"));
                    fw.write((String)tot);
                    fw.flush();
                    fw.close();
                    System.exit(0);
                }
                ProcessBuilder pb = new ProcessBuilder("");
                pb.environment().put("LD_LIBRARY_PATH", libdir);
                pb.command(cmdarg);
                if (printCommand) {
                    String totalCmd = "";
                    for (String s : pb.command()) {
                        totalCmd = String.valueOf(totalCmd) + s + " ";
                    }
                    System.out.println(totalCmd);
                }
                final Process p = pb.start();
                new Thread(){

                    public synchronized void run() {
                        BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        try {
                            String line;
                            while ((line = br.readLine()) != null) {
                                if (line.startsWith("Could not create the Java Virtual Machine")) {
                                    JOptionPane.showMessageDialog(null, "Trouble creating virtual machine. Try to reduce the ammount of memory allocated");
                                }
                                System.err.println(line);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println("Process exited");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Was unable to exec command. Full error:\n" + e.getMessage());
                e.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(null, "Your version of Java is too old. It must be at least 1.5");
        }
    }
}

