/*
 * Decompiled with CFR 0.152.
 */
package endrov.starter;

import java.io.File;

public class EvSystemUtil {
    public static final String javaver = System.getProperty("java.specification.version");
    public static final String arch = System.getProperty("os.arch").toLowerCase();
    public static final int javaVerMajor = Integer.parseInt(javaver.substring(0, javaver.indexOf(46)));
    public static final int javaVerMinor = Integer.parseInt(javaver.substring(javaver.indexOf(46) + 1));
    public static String OS = System.getProperty("os.name").toLowerCase();

    static File getGlobalConfigDir() {
        String e = System.getenv("XDG_CONFIG_HOME");
        if (e == null) {
            if (EvSystemUtil.isWindows()) {
                return new File("C:\\config");
            }
            if (EvSystemUtil.isMac()) {
                return new File(new File(EvSystemUtil.getHomeDir(), "Library"), "Application Support");
            }
            return new File(EvSystemUtil.getHomeDir(), ".config");
        }
        return new File(e);
    }

    public static File getGlobalConfigEndrovDir() {
        return new File(EvSystemUtil.getGlobalConfigDir(), "endrov");
    }

    public static File getPersonalConfigFileName() {
        return new File(EvSystemUtil.getGlobalConfigEndrovDir(), "config.xml");
    }

    public static File getSystemConfigFileName() {
        return new File(EvSystemUtil.getGlobalConfigEndrovDir(), "sysconfig.xml");
    }

    public static File getJavaenvWriteFileName() {
        return new File(EvSystemUtil.getGlobalConfigEndrovDir(), "javaenv.txt");
    }

    public static File getJavaenvReadFileName() {
        File f = EvSystemUtil.getJavaenvReadFileName();
        if (f.exists()) {
            return f;
        }
        String platformExt = OS.equals("mac os x") ? "mac" : (OS.startsWith("windows") ? "windows" : (OS.startsWith("linux") ? "linux" : (OS.startsWith("sunos") ? "solaris" : "other")));
        return new File(new File("config"), "javaenv." + platformExt + ".txt");
    }

    public static File getLogFileName() {
        return new File(EvSystemUtil.getGlobalConfigEndrovDir(), "log.txt");
    }

    public static File getHomeDir() {
        if (EvSystemUtil.isWindows()) {
            return new File("C:\\");
        }
        String e = System.getenv("HOME");
        if (e != null) {
            return new File(e);
        }
        return new File("/");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toUpperCase().indexOf("LINUX") != -1;
    }

    public static boolean isX86() {
        return System.getProperty("os.arch").contains("86");
    }

    public static boolean isPPC() {
        return System.getProperty("os.arch").contains("ppc");
    }
}

