/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.bufr.BufrData;
import ucar.bufr.BufrDataSection;
import ucar.bufr.BufrIdentificationSection;
import ucar.bufr.BufrInput;
import ucar.bufr.BufrRecord;
import ucar.bufr.Index;
import ucar.unidata.io.RandomAccessFile;

public class BufrIndexer {
    protected static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final String line = "--------------------------------------------------------------------";
    static boolean extendIndex;
    static ArrayList previousObs;
    static String outfile;
    private static final Pattern idxlength;

    public static final Index writeFileIndex(RandomAccessFile inputRaf, PrintStream ps, boolean makeIndex) throws IOException {
        Date now = Calendar.getInstance().getTime();
        long start = System.currentTimeMillis();
        int count = 0;
        Index index = makeIndex ? new Index() : null;
        try {
            if (extendIndex) {
                long seek = BufrIndexer.checkLengthAndGetObs(new File(inputRaf.getLocation().concat(".bfx")), Long.toString(inputRaf.length()));
                if (seek == -1L) {
                    return index;
                }
                inputRaf.seek(seek);
            } else {
                inputRaf.seek(0L);
            }
            if (ps == null) {
                if (outfile != null) {
                    if (!outfile.endsWith(".bfx")) {
                        outfile = outfile.concat(".bfx");
                    }
                    ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(outfile, false)));
                } else {
                    ps = System.out;
                }
            }
            BufrInput bi = new BufrInput(inputRaf);
            bi.scan(false, false);
            ps.println("type = BUFR");
            ps.println("bufr_edition = 3");
            ps.println("location = " + inputRaf.getLocation());
            ps.println("length = " + inputRaf.length());
            ps.println("created = " + dateFormat.format(now));
            ps.println("index_version = 1.1");
            if (makeIndex) {
                index.addGlobalAttribute("type", "BUFR");
                index.addGlobalAttribute("bufr_edition", "3");
                index.addGlobalAttribute("location", inputRaf.getLocation());
                index.addGlobalAttribute("length", Long.toString(inputRaf.length()));
                index.addGlobalAttribute("created", dateFormat.format(now));
                index.addGlobalAttribute("index_version", "1.1");
            }
            ArrayList records = bi.getRecords();
            ArrayList dorder = null;
            HashMap bufrdatas = null;
            BufrData bd = null;
            int maxLevelDim = -1;
            for (int i = 0; i < records.size(); ++i) {
                float[] alt;
                float[] lon;
                float[] lat;
                BufrRecord record = (BufrRecord)records.get(i);
                BufrIdentificationSection ids = record.getIds();
                if (i == 0) {
                    ps.println("header = " + record.getHeader());
                    ps.println("reference_time = " + ids.getReferenceTime());
                    ps.println("center_id = " + ids.getCenter_id() + " " + ids.getCenter_idName(ids.getCenter_id()));
                    ps.println("sub_center_id = " + ids.getSubCenter_id() + " " + ids.getCenter_idName(ids.getSubCenter_id()));
                    String cat = Integer.toString(ids.getCategory());
                    ps.println("category = " + cat + " " + (String)BufrDataSection.tableA.get(cat));
                    ps.println("table = " + ids.getMasterTableFilename());
                    ps.println("compressdata = " + ids.isCompressed());
                    ps.println(line);
                    if (makeIndex) {
                        index.addGlobalAttribute("header", record.getHeader());
                        index.addGlobalAttribute("reference_time", ids.getReferenceTime());
                        index.addGlobalAttribute("center_id", ids.getCenter_idName(ids.getCenter_id()));
                        index.addGlobalAttribute("sub_center_id", ids.getCenter_idName(ids.getSubCenter_id()));
                        index.addGlobalAttribute("category", ids.getCategory() + " " + (String)BufrDataSection.tableA.get(cat));
                        index.addGlobalAttribute("table", ids.getMasterTableFilename());
                        index.addGlobalAttribute("compressdata", Boolean.toString(ids.isCompressed()));
                    }
                    if (extendIndex) {
                        for (int j = 0; j < previousObs.size(); ++j) {
                            ps.println((String)previousObs.get(j));
                        }
                    }
                }
                dorder = record.getDorder();
                bufrdatas = record.getBufrDatas();
                bd = (BufrData)bufrdatas.get("0-4-250");
                long[] obs = bd.getLongData();
                String[] loc = null;
                bd = (BufrData)bufrdatas.get("0-1-18");
                if (bd != null) {
                    loc = bd.getStringData();
                } else {
                    bd = (BufrData)bufrdatas.get("0-1-8");
                    if (bd != null) {
                        loc = bd.getStringData();
                    } else {
                        bd = (BufrData)bufrdatas.get("0-1-2");
                        if (bd != null) {
                            float[] floc = bd.getFloatData();
                            loc = new String[floc.length];
                            for (int k = 0; k < floc.length; ++k) {
                                loc[k] = Integer.toString((int)floc[k]);
                            }
                        } else {
                            bd = (BufrData)bufrdatas.get("0-1-7");
                            if (bd != null) {
                                float[] floc = bd.getFloatData();
                                loc = new String[1];
                                for (int k = 0; k < 1; ++k) {
                                    loc[k] = Integer.toString((int)floc[k]);
                                }
                            } else {
                                loc = BufrIndexer.createLocations(bufrdatas);
                            }
                        }
                    }
                }
                int dim = -1;
                bd = (BufrData)bufrdatas.get("0-7-6");
                if (bd != null) {
                    float[] level = bd.getFloatData();
                    dim = level.length;
                    if (maxLevelDim < dim) {
                        maxLevelDim = dim;
                    }
                } else {
                    bd = (BufrData)bufrdatas.get("0-7-5");
                    if (bd != null) {
                        if (bd.getVarCount() == 3) {
                            dim = 43;
                            maxLevelDim = 43;
                        }
                    } else {
                        bd = (BufrData)bufrdatas.get("0-7-4");
                        if (bd != null) {
                            maxLevelDim = dim = bd.getVarCount();
                        } else {
                            dim = 1;
                            maxLevelDim = 1;
                        }
                    }
                }
                bd = (BufrData)bufrdatas.get("0-5-2");
                if (bd != null) {
                    lat = bd.getFloatData();
                    bd = (BufrData)bufrdatas.get("0-6-2");
                    lon = bd.getFloatData();
                } else {
                    bd = (BufrData)bufrdatas.get("0-5-1");
                    if (bd == null) continue;
                    lat = bd.getFloatData();
                    bd = (BufrData)bufrdatas.get("0-6-1");
                    lon = bd.getFloatData();
                }
                bd = (BufrData)bufrdatas.get("0-7-1");
                if (bd != null) {
                    alt = bd.getFloatData();
                } else {
                    bd = (BufrData)bufrdatas.get("0-7-2");
                    if (bd != null) {
                        alt = bd.getFloatData();
                    } else {
                        alt = new float[lat.length];
                        for (int k = 0; k < lat.length; ++k) {
                            alt[k] = -1.0f;
                        }
                    }
                }
                long offsetDDS = record.getOffsetDDS();
                long[] offset = record.getOffset();
                int[] oBitPos = record.getBitPos();
                int[] oBitBuf = record.getBitBuf();
                GregorianCalendar cal = new GregorianCalendar();
                for (int j = 0; j < loc.length; ++j) {
                    cal.setTimeInMillis(obs[j] * 1000L);
                    String theTime = dateFormat.format(cal.getTime());
                    ps.println(loc[j] + " " + theTime + " " + dim + " " + lat[j] + " " + lon[j] + " " + (int)alt[j] + " " + offsetDDS + " " + offset[j] + " " + oBitPos[j] + " " + oBitBuf[j]);
                    if (makeIndex) {
                        index.addObservation(loc[j], theTime, dim, lat[j], lon[j], (int)alt[j], offsetDDS, offset[j], oBitPos[j], oBitBuf[j]);
                    }
                    ++count;
                }
            }
            if (makeIndex) {
                index.finish();
            }
            ps.println(line);
            for (int j = 0; j < dorder.size(); ++j) {
                String bKey = (String)dorder.get(j);
                bd = (BufrData)bufrdatas.get(bKey);
                if (bd.getVarCount() < 5) {
                    ps.println(bd.getKey() + "\t" + bd.getVarCount() + "\t" + bd.isNumeric() + "\t" + bd.getName() + "\t" + bd.getUnits());
                    if (!makeIndex) continue;
                    index.addParameter(bd.getKey(), bd.getVarCount(), bd.isNumeric(), bd.getName(), bd.getUnits());
                    continue;
                }
                ps.println(bd.getKey() + "\t" + maxLevelDim + "\t" + bd.isNumeric() + "\t" + bd.getName() + "\t" + bd.getUnits());
                if (!makeIndex) continue;
                index.addParameter(bd.getKey(), maxLevelDim, bd.isNumeric(), bd.getName(), bd.getUnits());
            }
        }
        catch (IOException ioe) {
            ps.println("IOException : " + ioe);
        }
        ps.close();
        return index;
    }

    private static String[] createLocations(HashMap bufrdatas) {
        float[] lon;
        float[] lat;
        BufrData bd = (BufrData)bufrdatas.get("0-5-1");
        if (bd != null) {
            lat = bd.getFloatData();
            bd = (BufrData)bufrdatas.get("0-6-1");
            lon = bd.getFloatData();
        } else {
            bd = (BufrData)bufrdatas.get("0-5-2");
            if (bd == null) {
                return null;
            }
            lat = bd.getFloatData();
            bd = (BufrData)bufrdatas.get("0-6-2");
            lon = bd.getFloatData();
        }
        String[] loc = new String[lon.length];
        for (int i = 0; i < lon.length; ++i) {
            loc[i] = Float.toString(lat[i]) + Float.toString(lon[i]);
            loc[i] = loc[i].replaceAll("\\.", "");
        }
        return loc;
    }

    private static long checkLengthAndGetObs(File indexFile, String length) throws IOException {
        return BufrIndexer.open(indexFile.getPath(), length);
    }

    private static long open(String location, String length) throws IOException {
        InputStream ios = null;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        return BufrIndexer.open(ios, length);
    }

    private static long open(InputStream ios, String length) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        String lastLine = "";
        long fileLength = -1L;
        while ((line = dataIS.readLine()) != null) {
            Matcher m = idxlength.matcher(line);
            if (m.find()) {
                if (length.equals(m.group(1))) {
                    return -1L;
                }
                fileLength = Long.parseLong(m.group(1));
            }
            if (!line.startsWith("--")) continue;
            break;
        }
        previousObs = new ArrayList();
        while ((line = dataIS.readLine()) != null && !line.startsWith("--")) {
            previousObs.add(line);
            lastLine = line;
        }
        dataIS.close();
        return fileLength;
    }

    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Bufr Parameters:");
        System.out.println("<BufrFileToRead> reads/scans for index");
        System.out.println("<IndexFile.idx> where to write index, default STDOUT");
        System.out.println();
        System.out.println("java " + className + " <BufrFileToRead> <IndexFile>");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        BufrIndexer indexer = new BufrIndexer();
        if (args.length < 1) {
            Class<?> cl = indexer.getClass();
            BufrIndexer.usage(cl.getName());
            System.exit(0);
        }
        RandomAccessFile raf = null;
        PrintStream ps = null;
        String infile = args[0];
        raf = new RandomAccessFile(infile, "r");
        raf.order(0);
        if (args.length == 2) {
            if (args[1].equals("true") || args[1].equals("false")) {
                extendIndex = args[1].equals("true");
            } else {
                outfile = args[1];
            }
        } else if (args.length == 3) {
            extendIndex = args[1].equals("true");
            outfile = args[2];
        }
        BufrIndexer.writeFileIndex(raf, ps, false);
        extendIndex = false;
        previousObs = null;
        outfile = null;
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        extendIndex = false;
        previousObs = null;
        outfile = null;
        idxlength = Pattern.compile("length = (\\d+)$");
    }
}

