/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

import ucar.bufr.Descriptor;

public final class BufrData {
    private final String fxy;
    private final String name;
    private final String units;
    private final boolean numeric;
    private int index = 0;
    private int varCount = 1;
    private int size = 0;
    private String[] stringData;
    private float[] floatData;
    private long[] longData;

    public BufrData(Descriptor des) {
        this.fxy = des.getKey();
        this.name = des.getName();
        this.units = des.getUnits();
        this.numeric = des.isNumeric();
    }

    public final String getKey() {
        return this.fxy;
    }

    public final String getName() {
        return this.name;
    }

    public final String getUnits() {
        return this.units;
    }

    public final boolean isNumeric() {
        return this.numeric;
    }

    public final void setValue(String value) {
        if (this.index < this.stringData.length) {
            this.stringData[this.index++] = value;
        } else {
            String[] tmp = new String[this.stringData.length + this.size];
            System.arraycopy(this.stringData, 0, tmp, 0, this.stringData.length);
            this.stringData = tmp;
            this.stringData[this.index++] = value;
        }
    }

    public final void setValue(float value) {
        if (this.index < this.floatData.length) {
            this.floatData[this.index++] = value;
        } else {
            float[] tmp = new float[this.floatData.length + this.size];
            System.arraycopy(this.floatData, 0, tmp, 0, this.floatData.length);
            this.floatData = tmp;
            System.out.println("Allocation =" + this.floatData.length);
            this.floatData[this.index++] = value;
        }
    }

    public final void setValue(long value) {
        if (this.index < this.longData.length) {
            this.longData[this.index++] = value;
        } else {
            long[] tmp = new long[this.longData.length + this.size];
            System.arraycopy(this.longData, 0, tmp, 0, this.longData.length);
            this.longData = tmp;
            this.longData[this.index++] = value;
        }
    }

    public final String[] getStringData() {
        return this.stringData;
    }

    public final float[] getFloatData() {
        return this.floatData;
    }

    public final long[] getLongData() {
        return this.longData;
    }

    public final void setAllocation(int size) {
        this.size = size;
        if (this.index == 0) {
            if (this.numeric) {
                this.floatData = new float[this.varCount * size];
            } else {
                this.stringData = new String[this.varCount * size];
            }
        } else if (this.numeric) {
            if (this.varCount * size < this.floatData.length) {
                return;
            }
            float[] tmp = new float[this.varCount * size * 10];
            System.arraycopy(this.floatData, 0, tmp, 0, this.floatData.length);
            this.floatData = tmp;
        } else {
            if (this.varCount * size < this.stringData.length) {
                return;
            }
            String[] tmp = new String[this.varCount * size * 5];
            System.arraycopy(this.stringData, 0, tmp, 0, this.stringData.length);
            this.stringData = tmp;
        }
    }

    public final void setAllocationLong(int size) {
        this.longData = new long[this.varCount * size];
    }

    public final void setData(float[] floatData) {
        this.floatData = floatData;
    }

    public final void shrinkData() {
        int shrinkSize = this.varCount * this.size;
        if (this.numeric) {
            if (shrinkSize >= this.floatData.length) {
                return;
            }
            float[] tmp = new float[shrinkSize];
            System.arraycopy(this.floatData, 0, tmp, 0, shrinkSize);
            this.floatData = tmp;
        } else {
            if (shrinkSize >= this.stringData.length) {
                return;
            }
            String[] tmp = new String[shrinkSize];
            System.arraycopy(this.stringData, 0, tmp, 0, shrinkSize);
            this.stringData = tmp;
        }
    }

    public final void incrementVarCount() {
        ++this.varCount;
    }

    public final int getVarCount() {
        return this.varCount;
    }
}

