/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class SliderPanel
extends JPanel {
    private static final long serialVersionUID = -6039226355990936685L;
    private SpringLayout springLayout_ = new SpringLayout();
    private JTextField textField_;
    private double lowerLimit_ = 0.0;
    private double upperLimit_ = 10.0;
    private final int STEPS = 1000;
    private double factor_ = 1.0;
    private boolean integer_ = false;
    private ChangeListener sliderChangeListener_;
    private JScrollBar slider_;

    public SliderPanel() {
        this.setLayout(this.springLayout_);
        this.setPreferredSize(new Dimension(304, 18));
        this.textField_ = new JTextField();
        this.textField_.setFont(new Font("", 0, 10));
        this.textField_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SliderPanel.this.onEditChange();
            }
        });
        this.add(this.textField_);
        this.springLayout_.putConstraint("East", (Component)this.textField_, 40, "West", (Component)this);
        this.springLayout_.putConstraint("West", (Component)this.textField_, 0, "West", (Component)this);
        this.springLayout_.putConstraint("South", (Component)this.textField_, 0, "South", (Component)this);
        this.springLayout_.putConstraint("North", (Component)this.textField_, 0, "North", (Component)this);
        this.sliderChangeListener_ = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SliderPanel.this.onSliderMove();
            }
        };
        this.slider_ = new JScrollBar(0);
        this.slider_.getModel().addChangeListener(this.sliderChangeListener_);
        this.add(this.slider_);
        this.springLayout_.putConstraint("East", (Component)this.slider_, 0, "East", (Component)this);
        this.springLayout_.putConstraint("West", (Component)this.slider_, 41, "West", (Component)this);
        this.springLayout_.putConstraint("South", (Component)this.slider_, 0, "South", (Component)this);
        this.springLayout_.putConstraint("North", (Component)this.slider_, 0, "North", (Component)this);
    }

    public String getText() {
        this.setText(this.textField_.getText());
        return this.textField_.getText();
    }

    public void enableEdit(boolean bl) {
        this.textField_.setEditable(bl);
    }

    public void setLimits(double d, double d2) {
        this.integer_ = false;
        this.factor_ = (d2 - d) / 1000.0;
        this.upperLimit_ = d2;
        this.lowerLimit_ = d;
        this.slider_.setMinimum(0);
        this.slider_.setMaximum(1000);
        this.slider_.setVisibleAmount(0);
    }

    public void setLimits(int n, int n2) {
        this.integer_ = true;
        this.upperLimit_ = n2;
        this.lowerLimit_ = n;
        this.slider_.setMinimum(0);
        this.factor_ = 1.0;
        int n3 = n2 - n + 1;
        if (n2 > 1000) {
            this.factor_ = ((double)n2 - (double)n) / 1000.0;
            n3 = 1001;
        }
        this.slider_.setMaximum(n3);
        this.slider_.setVisibleAmount(1);
    }

    private void setSliderValue(double d) {
        this.slider_.setValue((int)((d - this.lowerLimit_) / this.factor_));
    }

    private void onSliderMove() {
        double d = (double)this.slider_.getValue() * this.factor_ + this.lowerLimit_;
        if (this.integer_) {
            this.textField_.setText(NumberUtils.intToDisplayString((int)d));
        } else {
            this.textField_.setText(NumberUtils.doubleToDisplayString(d));
        }
    }

    protected void onEditChange() {
        try {
            double d = this.enforceLimits(NumberUtils.displayStringToDouble(this.textField_.getText()));
            this.slider_.getModel().removeChangeListener(this.sliderChangeListener_);
            this.setSliderValue(d);
            this.slider_.getModel().addChangeListener(this.sliderChangeListener_);
        }
        catch (ParseException parseException) {
            this.handleException(parseException);
        }
    }

    public void setText(String string) {
        try {
            double d;
            if (this.integer_) {
                d = this.enforceLimits(NumberUtils.displayStringToInt(string));
                this.textField_.setText(NumberUtils.intToDisplayString((int)d));
            } else {
                d = this.enforceLimits(NumberUtils.displayStringToDouble(string));
                this.textField_.setText(NumberUtils.doubleToDisplayString(d));
            }
            this.slider_.getModel().removeChangeListener(this.sliderChangeListener_);
            this.setSliderValue(d);
            this.slider_.getModel().addChangeListener(this.sliderChangeListener_);
        }
        catch (ParseException parseException) {
            this.handleException(parseException);
        }
    }

    private double enforceLimits(double d) {
        double d2 = d;
        if (d2 < this.lowerLimit_) {
            d2 = this.lowerLimit_;
        }
        if (d2 > this.upperLimit_) {
            d2 = this.upperLimit_;
        }
        return d2;
    }

    private int enforceLimits(int n) {
        int n2 = n;
        if ((double)n2 < this.lowerLimit_) {
            n2 = (int)this.lowerLimit_;
        }
        if ((double)n2 > this.upperLimit_) {
            n2 = (int)this.upperLimit_;
        }
        return n2;
    }

    public void addEditActionListener(ActionListener actionListener) {
        this.textField_.addActionListener(actionListener);
    }

    public void addSliderMouseListener(MouseAdapter mouseAdapter) {
        JScrollBar jScrollBar;
        this.slider_.addMouseListener(mouseAdapter);
        if (JavaUtils.isWindows() && (jScrollBar = this.slider_) instanceof Container) {
            Container container = jScrollBar;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                if (!(component instanceof JButton)) continue;
                component.addMouseListener(mouseAdapter);
            }
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.slider_ != null) {
            this.slider_.setBackground(color);
        }
        if (this.textField_ != null) {
            this.textField_.setBackground(color);
        }
    }

    public void setEnabled(boolean bl) {
        this.textField_.setEnabled(bl);
        this.slider_.setEnabled(bl);
    }

    private void handleException(Exception exception) {
        ReportingUtils.showError(exception);
    }
}

