/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mmcorej.CMMCore;

public class ReportingUtils {
    private static CMMCore core_ = null;
    private static JFrame owningFrame_;
    private static boolean show_;

    public static void SetContainingFrame(JFrame jFrame) {
        owningFrame_ = jFrame;
    }

    public static void setCore(CMMCore cMMCore) {
        core_ = cMMCore;
    }

    public static void showErrorOn(boolean bl) {
        show_ = bl;
    }

    public static void logMessage(String string) {
        if (core_ == null) {
            System.out.println(string);
        } else {
            core_.logMessage(string);
        }
    }

    public static void showMessage(String string) {
        JOptionPane.showMessageDialog(null, string);
    }

    public static void logError(Throwable throwable, String string) {
        if (throwable != null) {
            String string2 = ReportingUtils.getStackTraceAsString(throwable);
            ReportingUtils.logMessage(string + "\n" + throwable.toString() + " in " + Thread.currentThread().toString() + "\n" + string2 + "\n");
        } else {
            ReportingUtils.logMessage("Error: " + string);
        }
    }

    public static void logError(Throwable throwable) {
        ReportingUtils.logError(throwable, "");
    }

    public static void logError(String string) {
        ReportingUtils.logError(null, string);
    }

    public static void showError(Throwable throwable, String string) {
        ReportingUtils.logError(throwable, string);
        if (!show_) {
            return;
        }
        String string2 = throwable != null && throwable.getMessage() != null && string.length() > 0 ? "Error: " + string + "\n" + throwable.getMessage() : (throwable != null && throwable.getMessage() != null ? throwable.getMessage() : (string.length() > 0 ? "Error: " + string : (throwable != null ? "Error: " + throwable.getStackTrace()[0] : "Unknown error (please check CoreLog.txt file for more information)")));
        int n = 30;
        String[] stringArray = string2.split("\n");
        if (stringArray.length < n) {
            JOptionPane.showMessageDialog(null, string2, "Micro-Manager Error", 0);
        } else {
            JTextArea jTextArea = new JTextArea(string2);
            jTextArea.setRows(n);
            jTextArea.setColumns(50);
            jTextArea.setLineWrap(true);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            JOptionPane.showMessageDialog(null, jScrollPane, "Micro-Manager Error", 0);
        }
    }

    public static void showError(Throwable throwable) {
        ReportingUtils.showError(throwable, "");
    }

    public static void showError(String string) {
        ReportingUtils.showError(null, string);
    }

    private static String getStackTraceAsString(Throwable throwable) {
        String string = "";
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            string = string + "  at " + stackTraceElement.toString() + "\n";
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            return string + "Caused by: " + throwable2.toString() + "\n" + ReportingUtils.getStackTraceAsString(throwable2);
        }
        return string;
    }

    public static void showError(ActionEvent actionEvent) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static void displayNonBlockingMessage(String string) {
        if (null != owningFrame_) {
            Calendar calendar = Calendar.getInstance();
            final JOptionPane jOptionPane = new JOptionPane(calendar.getTime().toString() + " " + string, 2, 2);
            final JDialog jDialog = new JDialog(owningFrame_, "\u0152\u00baManager Warning: ", false);
            jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if (jDialog.isVisible() && propertyChangeEvent.getSource() == jOptionPane && string.equals("value")) {
                        jDialog.setVisible(false);
                    }
                }
            });
            jDialog.setContentPane(jOptionPane);
            jDialog.pack();
            jDialog.setLocationRelativeTo(owningFrame_);
            jDialog.setVisible(true);
        }
    }

    static {
        show_ = true;
    }
}

