/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.micromanager.utils.ReportingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaUtils {
    private static final String BACKING_STORE_AVAIL = "BackingStoreAvail";
    private static final Class<?>[] parameters = new Class[]{URL.class};

    public static List<Class<?>> findClasses(File file, int n) throws ClassNotFoundException {
        ArrayList arrayList = new ArrayList();
        if (!file.exists()) {
            return arrayList;
        }
        File[] fileArray = file.listFiles();
        try {
            URL uRL = file.toURI().toURL();
            for (File file2 : fileArray) {
                if (file2.isDirectory() && n > 0) {
                    try {
                        JavaUtils.addFile(file2);
                    }
                    catch (IOException iOException) {
                        ReportingUtils.logError(iOException);
                    }
                    arrayList.addAll(JavaUtils.findClasses(file2, n - 1));
                    continue;
                }
                if (file2.getName().endsWith(".class")) {
                    try {
                        JavaUtils.addFile(file2);
                    }
                    catch (IOException iOException) {
                        ReportingUtils.logError(iOException);
                    }
                    try {
                        arrayList.add(Class.forName(JavaUtils.stripFilenameExtension(file2.getName())));
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        ReportingUtils.logError(noClassDefFoundError, "Not found:" + uRL + "  :  " + file2.getName());
                    }
                    continue;
                }
                if (!file2.getName().endsWith(".jar")) continue;
                try {
                    JarEntry jarEntry;
                    JavaUtils.addURL(new URL("jar:file:" + file2.getAbsolutePath() + "!/"));
                    JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file2));
                    do {
                        String string;
                        if ((jarEntry = jarInputStream.getNextJarEntry()) == null || !(string = jarEntry.getName()).endsWith(".class")) continue;
                        String string2 = JavaUtils.stripFilenameExtension(string).replace("/", ".");
                        try {
                            arrayList.add(Class.forName(string2));
                        }
                        catch (Throwable throwable) {
                            ReportingUtils.logError(throwable, "Failed to load " + string2 + " " + throwable.getCause());
                            for (StackTraceElement stackTraceElement : throwable.getCause().getStackTrace()) {
                                ReportingUtils.logMessage(stackTraceElement.toString());
                            }
                        }
                    } while (jarEntry != null);
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            ReportingUtils.logError(malformedURLException);
        }
        return arrayList;
    }

    private static String stripFilenameExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static void addFile(String string) throws IOException {
        File file = new File(string);
        JavaUtils.addFile(file);
    }

    public static void addFile(File file) throws IOException {
        JavaUtils.addURL(file.toURI().toURL());
    }

    public static void addURL(URL uRL) throws IOException {
        URLClassLoader uRLClassLoader = (URLClassLoader)JavaUtils.class.getClassLoader();
        Class<URLClassLoader> clazz = URLClassLoader.class;
        try {
            Method method = clazz.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)uRLClassLoader, uRL);
        }
        catch (Throwable throwable) {
            ReportingUtils.logError(throwable);
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public static Object invokeRestrictedMethod(Object object, Class clazz, String string) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return JavaUtils.invokeRestrictedMethod(object, clazz, string, new Object[]{null});
    }

    public static Object invokeRestrictedMethod(Object object, Class clazz, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] classArray;
        Object[] objectArray2;
        int n;
        if (objectArray != null) {
            n = objectArray.length;
            objectArray2 = new Object[n / 2];
            classArray = new Class[n / 2];
        } else {
            n = 0;
            objectArray2 = null;
            classArray = null;
        }
        for (int i = 0; i < n / 2; ++i) {
            objectArray2[i] = objectArray[i * 2];
            classArray[i] = (Class)objectArray[i * 2 + 1];
        }
        return JavaUtils.invokeRestrictedMethod(object, clazz, string, objectArray2, classArray);
    }

    public static Object invokeRestrictedMethod(Object object, Class clazz, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = clazz.getDeclaredMethod(string, classArray);
        boolean bl = method.isAccessible();
        method.setAccessible(true);
        Object object2 = objectArray == null ? method.invoke(object, new Object[0]) : method.invoke(object, objectArray);
        method.setAccessible(bl);
        return object2;
    }

    public static Object getRestrictedFieldValue(Object object, Class clazz, String string) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(string);
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            ReportingUtils.logError(illegalAccessException);
            return null;
        }
    }

    public static void setRestrictedFieldValue(Object object, Class clazz, String string, Object object2) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(string);
        field.setAccessible(true);
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            ReportingUtils.logError(illegalAccessException);
        }
    }

    public static boolean backingStoreAvailable(Preferences preferences) {
        try {
            boolean bl = preferences.getBoolean(BACKING_STORE_AVAIL, false);
            preferences.putBoolean(BACKING_STORE_AVAIL, !bl);
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
        return true;
    }

    public static void putObjectInPrefs(Preferences preferences, String string, Serializable serializable) {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object).writeObject(serializable);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception, "Failed to save object in Preferences.");
            return;
        }
        object = byteArrayOutputStream.toByteArray();
        preferences.putByteArray(string, (byte[])object);
    }

    public static Object getObjectFromPrefs(Preferences preferences, String string, Object object) {
        byte[] byArray = preferences.getByteArray(string, new byte[0]);
        if (byArray.length == 0) {
            return object;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception, "Failed to get object from preferences.");
            return object;
        }
    }

    public static Dimension getScreenDimensions() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        Rectangle rectangle = graphicsDeviceArray[0].getDefaultConfiguration().getBounds();
        return new Dimension(rectangle.width, rectangle.height);
    }

    public static File createDirectory(String string) throws Exception {
        File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            throw new Exception("Unable to create directory.");
        }
        return file;
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("nix") >= 0 || string.indexOf("nux") >= 0;
    }

    public static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            ReportingUtils.logError(interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(String string, String string2) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write(string2);
        }
        catch (IOException iOException) {
            ReportingUtils.logError(iOException);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    ReportingUtils.logError(iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            try {
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append(System.getProperty("line.separator"));
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            ReportingUtils.logError(iOException);
        }
        return stringBuilder.toString();
    }

    public static long getAvailableUnusedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
    }

    public static <T> T[] copyOfRange(T[] TArray, int n, int n2) {
        if (TArray.length >= n && 0 <= n) {
            if (n <= n2) {
                int n3 = n2 - n;
                int n4 = Math.min(n3, TArray.length - n);
                Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n3);
                System.arraycopy(TArray, n, objectArray, 0, n4);
                return objectArray;
            }
            throw new IllegalArgumentException();
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static String getApplicationDataPath() {
        if (JavaUtils.isMac()) {
            return System.getenv("HOME") + "/Library/Application Support/Micro-Manager/";
        }
        if (JavaUtils.isWindows()) {
            String string = System.getProperty("os.name").toLowerCase();
            if (string.indexOf("xp") >= 0) {
                return System.getenv("USERPROFILE") + "/Local Settings/Application Data/Micro-Manager/";
            }
            if (string.indexOf("windows 7") >= 0 || string.indexOf("windows vista") >= 0) {
                return System.getenv("USERPROFILE") + "/AppData/Local/Micro-Manager/";
            }
        }
        if (JavaUtils.isUnix()) {
            return System.getenv("HOME") + "/.config/Micro-Manager/";
        }
        return null;
    }

    public static void printAllStackTraces() {
        System.err.println("\n\nDumping all stack traces:");
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Thread thread : map.keySet()) {
            System.err.println("Thread " + thread.getName());
            StackTraceElement[] stackTraceElementArray = map.get(thread);
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                System.err.println("\tat " + stackTraceElementArray[i]);
            }
        }
        System.err.println("End all stack traces. =============");
    }
}

