/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.micromanager.utils.HotKeyAction;
import org.micromanager.utils.ReportingUtils;

public class HotKeys {
    Preferences root_ = Preferences.userNodeForPackage(this.getClass());
    private static Preferences prefs_;
    private static final int STOP = -1;
    private static final String KEY = "Key";
    private static final String TYPE = "Type";
    private static final String GUICOMMAND = "GuiCommand";
    private static final String FILENAME = "FileName";
    public static final LinkedHashMap<Integer, HotKeyAction> keys_;
    public static boolean active_;

    public HotKeys() {
        prefs_ = this.root_.node(this.root_.absolutePath() + "/HotKeys");
    }

    public void loadSettings() {
        if (prefs_ == null) {
            return;
        }
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        do {
            if ((n2 = prefs_.getInt(KEY + n, -1)) != -1) {
                HotKeyAction hotKeyAction;
                n3 = prefs_.getInt(TYPE + n, 0);
                if (n3 == 0) {
                    n4 = prefs_.getInt(GUICOMMAND + n, 0);
                    hotKeyAction = new HotKeyAction(n4);
                    keys_.put(n2, hotKeyAction);
                } else {
                    File file = new File(prefs_.get(FILENAME + n, ""));
                    hotKeyAction = new HotKeyAction(file);
                    keys_.put(n2, hotKeyAction);
                }
            }
            ++n;
        } while (n2 != -1);
    }

    public void saveSettings() {
        if (prefs_ == null) {
            return;
        }
        Iterator<Map.Entry<Integer, HotKeyAction>> iterator = keys_.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry<Integer, HotKeyAction> entry = iterator.next();
            prefs_.putInt(KEY + n, entry.getKey());
            HotKeyAction hotKeyAction = entry.getValue();
            prefs_.putInt(TYPE + n, hotKeyAction.type_);
            if (hotKeyAction.type_ == 0) {
                prefs_.putInt(GUICOMMAND + n, hotKeyAction.guiCommand_);
            } else {
                prefs_.put(FILENAME + n, hotKeyAction.beanShellScript_.getAbsolutePath());
            }
            ++n;
        }
        prefs_.putInt(KEY + n, -1);
    }

    public static void load(File file) throws FileNotFoundException {
        if (file == null || !file.canRead()) {
            return;
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        keys_.clear();
        try {
            while (dataInputStream.available() > 0) {
                int n = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                int n3 = 0;
                String string = "";
                if (n2 == 0) {
                    n3 = dataInputStream.readInt();
                    HotKeyAction hotKeyAction = new HotKeyAction(n3);
                    keys_.put(n, hotKeyAction);
                    continue;
                }
                int n4 = dataInputStream.readInt();
                for (int i = 0; i < n4; ++i) {
                    string = string + dataInputStream.readChar();
                }
                HotKeyAction hotKeyAction = new HotKeyAction(new File(string));
                keys_.put(n, hotKeyAction);
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            ReportingUtils.showError("Error while reading in Shortcuts");
        }
    }

    public static void save(File file) throws FileNotFoundException {
        if (file == null || !file.canWrite()) {
            return;
        }
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        Iterator<Map.Entry<Integer, HotKeyAction>> iterator = keys_.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            try {
                Map.Entry<Integer, HotKeyAction> entry = iterator.next();
                dataOutputStream.writeInt(entry.getKey());
                HotKeyAction hotKeyAction = entry.getValue();
                dataOutputStream.writeInt(hotKeyAction.type_);
                if (hotKeyAction.type_ == 0) {
                    dataOutputStream.writeInt(hotKeyAction.guiCommand_);
                } else {
                    dataOutputStream.writeInt(hotKeyAction.beanShellScript_.getAbsolutePath().length());
                    dataOutputStream.writeChars(hotKeyAction.beanShellScript_.getAbsolutePath());
                }
                ++n;
            }
            catch (IOException iOException) {
                ReportingUtils.showError("Error while saving Shortcuts");
            }
        }
        try {
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            ReportingUtils.showError("Error while closing Shortcuts file");
        }
    }

    static {
        keys_ = new LinkedHashMap();
        active_ = true;
    }
}

