/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

public class HistogramUtils {
    int[] histogram_;
    int totalPoints_;
    double fractionToReject_;

    public HistogramUtils(int[] nArray, int n) {
        this.histogram_ = nArray;
        this.totalPoints_ = n;
        this.fractionToReject_ = 0.0027;
    }

    public HistogramUtils(int[] nArray) {
        this.histogram_ = nArray;
        this.totalPoints_ = 0;
        this.fractionToReject_ = 0.0027;
    }

    public HistogramUtils(int[] nArray, int n, double d) {
        this.histogram_ = nArray;
        this.totalPoints_ = n;
        this.fractionToReject_ = d;
    }

    public HistogramUtils(int[] nArray, double d) {
        this.histogram_ = nArray;
        this.totalPoints_ = 0;
        this.fractionToReject_ = d;
    }

    public int getMin() {
        int n = 0;
        if (null != this.histogram_) {
            for (int i = 0; i < this.histogram_.length; ++i) {
                if (0 >= this.histogram_[i]) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public int getMax() {
        int n = 0;
        if (null != this.histogram_) {
            for (int i = this.histogram_.length - 1; 0 <= i; --i) {
                if (0 >= this.histogram_[i]) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    int sumTotalPoints() {
        int n = 0;
        for (int i = 0; i < this.histogram_.length; ++i) {
            n += this.histogram_[i];
        }
        return n;
    }

    public int getMinAfterRejectingOutliers() {
        int n = 0;
        if (this.totalPoints_ < 1) {
            this.totalPoints_ = this.sumTotalPoints();
        }
        int n2 = (int)(0.5 + (double)this.totalPoints_ * this.fractionToReject_);
        int n3 = 0;
        for (int i = 0; i < this.histogram_.length; ++i) {
            if ((n3 += this.histogram_[i]) <= n2) continue;
            n = Math.max(0, i);
            break;
        }
        return n;
    }

    public int getMaxAfterRejectingOutliers() {
        int n = 0;
        if (this.totalPoints_ < 1) {
            this.totalPoints_ = this.sumTotalPoints();
        }
        int n2 = (int)(0.5 + (double)this.totalPoints_ * this.fractionToReject_);
        int n3 = 0;
        for (int i = this.histogram_.length - 1; i >= 0; --i) {
            if ((n3 += this.histogram_[i]) <= n2) continue;
            n = Math.min(i, this.histogram_.length - 1);
            break;
        }
        return n;
    }

    public double getFractionToReject() {
        return this.fractionToReject_;
    }

    public int getTotalPoints() {
        if (null != this.histogram_ && this.totalPoints_ < 1) {
            this.totalPoints_ = this.sumTotalPoints();
        }
        return this.totalPoints_;
    }

    public void setFractionToReject(double d) {
        this.fractionToReject_ = d;
    }
}

