/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import ij.WindowManager;
import ij.gui.ImageWindow;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.prefs.Preferences;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.micromanager.utils.ImageFocusListener;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.ReportingUtils;

public class GUIUtils {
    private static String DIALOG_POSITION = "dialogPosition";

    public static void setComboSelection(JComboBox jComboBox, String string) {
        int n;
        ActionListener[] actionListenerArray = jComboBox.getActionListeners();
        for (n = 0; n < actionListenerArray.length; ++n) {
            jComboBox.removeActionListener(actionListenerArray[n]);
        }
        jComboBox.setSelectedItem(string);
        for (n = 0; n < actionListenerArray.length; ++n) {
            jComboBox.addActionListener(actionListenerArray[n]);
        }
    }

    public static void replaceComboContents(JComboBox jComboBox, String[] stringArray) {
        int n;
        ActionListener[] actionListenerArray = jComboBox.getActionListeners();
        for (n = 0; n < actionListenerArray.length; ++n) {
            jComboBox.removeActionListener(actionListenerArray[n]);
        }
        if (jComboBox.getItemCount() > 0) {
            jComboBox.removeAllItems();
        }
        for (n = 0; n < stringArray.length; ++n) {
            jComboBox.addItem(stringArray[n]);
        }
        for (n = 0; n < actionListenerArray.length; ++n) {
            jComboBox.addActionListener(actionListenerArray[n]);
        }
    }

    public static void preventDisplayAdapterChangeExceptions() {
        try {
            if (JavaUtils.isWindows()) {
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                Class<?> clazz = classLoader.loadClass("sun.awt.Win32GraphicsEnvironment");
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                clazz.getDeclaredMethod("displayChanged", new Class[0]).invoke(clazz.cast(graphicsEnvironment), new Object[0]);
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    public static void setClickCountToStartEditing(JTable jTable, int n) {
        ((DefaultCellEditor)jTable.getDefaultEditor(String.class)).setClickCountToStart(n);
    }

    public static void stopEditingOnLosingFocus(final JTable jTable) {
        jTable.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                Component component = focusEvent.getOppositeComponent();
                try {
                    if (jTable != component && !jTable.isAncestorOf(component)) {
                        jTable.getDefaultEditor(String.class).stopCellEditing();
                    }
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                }
            }
        });
    }

    public static void recallPosition(final JFrame jFrame) {
        Preferences preferences = Preferences.userNodeForPackage(jFrame.getClass());
        Point point = (Point)JavaUtils.getObjectFromPrefs(preferences, DIALOG_POSITION, null);
        if (point == null) {
            Dimension dimension = JavaUtils.getScreenDimensions();
            point = new Point((dimension.width - jFrame.getWidth()) / 2, (dimension.height - jFrame.getHeight()) / 2);
        }
        jFrame.setLocation(point);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GUIUtils.storePosition(jFrame);
            }
        });
    }

    private static void storePosition(JFrame jFrame) {
        Preferences preferences = Preferences.userNodeForPackage(jFrame.getClass());
        JavaUtils.putObjectInPrefs(preferences, DIALOG_POSITION, jFrame.getLocation());
    }

    public static void registerImageFocusListener(final ImageFocusListener imageFocusListener) {
        AWTEventListener aWTEventListener = new AWTEventListener(){
            private ImageWindow currentImageWindow_ = null;

            public void eventDispatched(AWTEvent aWTEvent) {
                ImageWindow imageWindow;
                if (aWTEvent instanceof WindowEvent && 0 != (aWTEvent.getID() & 0xCF) && aWTEvent.getSource() instanceof ImageWindow && this.currentImageWindow_ != (imageWindow = WindowManager.getCurrentWindow())) {
                    imageFocusListener.focusReceived(imageWindow);
                    this.currentImageWindow_ = imageWindow;
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(aWTEventListener, 524288L);
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }

    public static void invokeLater(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

