/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.micromanager.utils.JavaUtils;

public class FileDialogs {
    public static File show(Window window, String string, File file, boolean bl, boolean bl2, String string2, String[] stringArray, boolean bl3) {
        File file2 = null;
        GeneralFileFilter generalFileFilter = new GeneralFileFilter(string2, stringArray);
        if (JavaUtils.isMac()) {
            int n;
            if (bl) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
            }
            int n2 = n = bl2 ? 0 : 1;
            FileDialog fileDialog = window instanceof Dialog ? new FileDialog((Dialog)window, string, n) : (window instanceof Frame ? new FileDialog((Frame)window, string, n) : new FileDialog((Dialog)null, string, n));
            if (file != null) {
                if (file.isDirectory()) {
                    fileDialog.setDirectory(file.getAbsolutePath());
                } else {
                    fileDialog.setDirectory(file.getParent());
                }
                if (!bl2 && bl3) {
                    fileDialog.setFile(file.getName());
                }
            }
            if (stringArray != null) {
                fileDialog.setFilenameFilter(generalFileFilter);
            }
            fileDialog.setVisible(true);
            if (bl) {
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            }
            if (fileDialog.getFile() != null) {
                file2 = new File(fileDialog.getDirectory() + "/" + fileDialog.getFile());
                if (n == 1 && !generalFileFilter.accept(file2)) {
                    file2 = new File(file2.getAbsolutePath() + "." + stringArray[0]);
                }
            }
            fileDialog.dispose();
        } else {
            int n;
            JFileChooser jFileChooser = new JFileChooser();
            if (file != null) {
                if (!bl2 && bl3 || file.isDirectory()) {
                    jFileChooser.setSelectedFile(file);
                } else {
                    jFileChooser.setSelectedFile(file.getParentFile());
                }
            }
            jFileChooser.setDialogTitle(string);
            if (bl) {
                jFileChooser.setFileSelectionMode(2);
            }
            if (stringArray != null) {
                jFileChooser.setFileFilter(generalFileFilter);
            }
            if ((n = bl2 ? jFileChooser.showOpenDialog(window) : jFileChooser.showSaveDialog(window)) == 0) {
                file2 = jFileChooser.getSelectedFile();
            }
        }
        return file2;
    }

    public static File show(Window window, String string, FileType fileType, boolean bl, boolean bl2) {
        File file;
        Preferences preferences = Preferences.userNodeForPackage(FileDialogs.class);
        String string2 = preferences.get(fileType.name, fileType.defaultFileName);
        File file2 = null;
        if (string2 != null) {
            file2 = new File(string2);
        }
        if ((file = FileDialogs.show(window, string, file2, bl, bl2, fileType.description, fileType.suffixes, fileType.suggestFileOnSave)) != null) {
            preferences.put(fileType.name, file.getAbsolutePath());
        }
        return file;
    }

    public static void storePath(FileType fileType, File file) {
        Preferences.userNodeForPackage(FileDialogs.class).put(fileType.name, file.getAbsolutePath());
    }

    public static File openFile(Window window, String string, FileType fileType) {
        return FileDialogs.show(window, string, fileType, false, true);
    }

    public static File openDir(Window window, String string, FileType fileType) {
        return FileDialogs.show(window, string, fileType, true, true);
    }

    public static File save(Window window, String string, FileType fileType) {
        return FileDialogs.show(window, string, fileType, false, false);
    }

    private static class GeneralFileFilter
    extends FileFilter
    implements FilenameFilter {
        private final String fileDescription_;
        private final String[] fileSuffixes_;

        public GeneralFileFilter(String string, String[] stringArray) {
            this.fileDescription_ = string;
            this.fileSuffixes_ = stringArray;
        }

        public boolean accept(File file) {
            String string = file.getName();
            int n = string.lastIndexOf(".");
            String string2 = string.substring(1 + n).toLowerCase();
            if (this.fileSuffixes_ == null || this.fileSuffixes_.length == 0) {
                return true;
            }
            if (!JavaUtils.isMac() && file.isDirectory()) {
                return true;
            }
            for (int i = 0; i < this.fileSuffixes_.length; ++i) {
                if (this.fileSuffixes_[i] == null || !this.fileSuffixes_[i].toLowerCase().contentEquals(string2)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.fileDescription_;
        }

        public boolean accept(File file, String string) {
            return this.accept(new File(file, string));
        }
    }

    public static class FileType {
        final String name;
        final String[] suffixes;
        final String description;
        final boolean suggestFileOnSave;
        final String defaultFileName;

        public FileType(String string, String string2, String string3, boolean bl, String ... stringArray) {
            this.name = string;
            this.description = string2;
            this.suffixes = stringArray;
            this.defaultFileName = string3;
            this.suggestFileOnSave = bl;
        }
    }
}

