/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import mmcorej.CMMCore;
import mmcorej.StrVector;
import org.micromanager.utils.Calibration;
import org.micromanager.utils.ReportingUtils;

public class CalibrationList {
    private ArrayList<Calibration> calibrationList_ = new ArrayList();
    private String label_ = new String("Undefined");
    private Hashtable<String, String> properties_ = new Hashtable();
    private CMMCore core_;

    public CalibrationList(CMMCore cMMCore) {
        this.core_ = cMMCore;
    }

    public void getCalibrationsFromCore() {
        this.calibrationList_.clear();
        StrVector strVector = this.core_.getAvailablePixelSizeConfigs();
        int n = 0;
        while ((long)n < strVector.size()) {
            try {
                Calibration calibration = new Calibration();
                calibration.setConfiguration(this.core_.getPixelSizeConfigData(strVector.get(n)));
                calibration.setLabel(strVector.get(n));
                calibration.setPixelSizeUm(this.core_.getPixelSizeUmByID(strVector.get(n)));
                this.calibrationList_.add(calibration);
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
            ++n;
        }
    }

    public void add(Calibration calibration) {
        this.calibrationList_.add(calibration);
    }

    public int size() {
        return this.calibrationList_.size();
    }

    public Calibration get(int n) {
        return this.calibrationList_.get(n);
    }

    public void setProperty(String string, String string2) {
        this.properties_.put(string, string2);
    }

    private void handleException(Exception exception) {
        String string = "Exception occurred: " + exception.getMessage();
        JOptionPane.showMessageDialog(null, string);
    }

    public String[] getPropertyNames() {
        String[] stringArray = new String[this.properties_.size()];
        int n = 0;
        Enumeration<String> enumeration = this.properties_.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = enumeration.nextElement();
        }
        return stringArray;
    }

    public boolean hasProperty(String string) {
        return this.properties_.containsKey(string);
    }

    public String getProperty(String string) {
        if (this.properties_.containsKey(string)) {
            return this.properties_.get(string);
        }
        return null;
    }

    public String getLabel() {
        return this.label_;
    }

    public void setLabel(String string) {
        this.label_ = string;
    }
}

