/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.util.Vector;
import mmcorej.CMMCore;
import mmcorej.DeviceType;
import mmcorej.StrVector;
import org.micromanager.api.Autofocus;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.AutofocusPropertyEditor;
import org.micromanager.utils.CoreAutofocus;
import org.micromanager.utils.MMException;
import org.micromanager.utils.ReportingUtils;

public class AutofocusManager {
    private ScriptInterface app_;
    private Vector<Autofocus> afs_ = new Vector();
    private Vector<String> afPluginClassNames_ = new Vector();
    private Autofocus currentAfDevice_ = null;
    private AutofocusPropertyEditor afDlg_;

    public AutofocusManager(ScriptInterface scriptInterface) {
        this.app_ = scriptInterface;
    }

    public void selectDevice(String string) throws MMException {
        for (Autofocus autofocus : this.afs_) {
            if (!autofocus.getDeviceName().equals(string)) continue;
            this.currentAfDevice_ = autofocus;
            return;
        }
        throw new MMException(string + " not loaded.");
    }

    public void setAFPluginClassName(String string) {
        if (!this.afPluginClassNames_.contains(string)) {
            this.afPluginClassNames_.add(string);
        }
    }

    public Autofocus getDevice() {
        return this.currentAfDevice_;
    }

    public void refresh() throws MMException {
        Object object;
        this.afs_.clear();
        CMMCore cMMCore = this.app_.getMMCore();
        StrVector strVector = cMMCore.getLoadedDevicesOfType(DeviceType.AutoFocusDevice);
        int n = 0;
        while ((long)n < strVector.size()) {
            object = new CoreAutofocus();
            try {
                cMMCore.setAutoFocusDevice(strVector.get(n));
                ((CoreAutofocus)object).setApp(this.app_);
                if (((CoreAutofocus)object).getDeviceName().length() != 0) {
                    this.afs_.add((Autofocus)object);
                    if (this.currentAfDevice_ == null) {
                        this.currentAfDevice_ = object;
                    }
                }
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
            }
            ++n;
        }
        try {
            for (n = 0; n < this.afPluginClassNames_.size(); ++n) {
                object = this.afPluginClassNames_.get(n);
                if (((String)object).length() == 0) continue;
                Autofocus autofocus = null;
                try {
                    autofocus = this.loadAutofocusPlugin((String)object);
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                    this.afPluginClassNames_.remove(object);
                    --n;
                }
                if (autofocus == null) continue;
                this.afs_.add(autofocus);
                if (this.currentAfDevice_ == null) {
                    this.currentAfDevice_ = autofocus;
                }
                autofocus.setApp(this.app_);
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
        boolean bl = false;
        for (Autofocus autofocus : this.afs_) {
            if (!autofocus.getDeviceName().equals(this.currentAfDevice_.getDeviceName())) continue;
            bl = true;
            this.currentAfDevice_ = autofocus;
        }
        if (!bl && this.afs_.size() > 0) {
            this.currentAfDevice_ = this.afs_.get(0);
        }
        if (this.afDlg_ != null) {
            this.afDlg_.rebuild();
        }
    }

    public void showOptionsDialog() {
        if (this.afDlg_ == null) {
            this.afDlg_ = new AutofocusPropertyEditor(this);
        }
        this.afDlg_.setVisible(true);
        if (this.currentAfDevice_ != null) {
            this.currentAfDevice_.applySettings();
            this.currentAfDevice_.saveSettings();
        }
    }

    public void closeOptionsDialog() {
        if (this.afDlg_ != null) {
            this.afDlg_.cleanup();
        }
    }

    public String[] getAfDevices() {
        String[] stringArray = new String[this.afs_.size()];
        int n = 0;
        for (Autofocus autofocus : this.afs_) {
            stringArray[n++] = autofocus.getDeviceName();
        }
        return stringArray;
    }

    private Autofocus loadAutofocusPlugin(String string) throws MMException {
        String string2 = new String(string + " module.");
        Autofocus autofocus = null;
        try {
            Class<?> clazz = Class.forName(string);
            autofocus = (Autofocus)clazz.newInstance();
            return autofocus;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ReportingUtils.logError(classNotFoundException);
            string2 = string + " autofocus plugin not found.";
        }
        catch (InstantiationException instantiationException) {
            ReportingUtils.logError(instantiationException);
            string2 = string + " instantiation to Autofocus interface failed.";
        }
        catch (IllegalAccessException illegalAccessException) {
            ReportingUtils.logError(illegalAccessException);
            string2 = "Illegal access exception!";
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ReportingUtils.logError(noClassDefFoundError);
            string2 = string + " class definition nor found.";
        }
        ReportingUtils.logMessage(string2);
        throw new MMException(string2);
    }

    public boolean hasDevice(String string) {
        for (Autofocus autofocus : this.afs_) {
            if (!autofocus.getDeviceName().equals(string)) continue;
            return true;
        }
        return false;
    }
}

