/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.util.ArrayList;
import java.util.prefs.Preferences;
import org.micromanager.api.Autofocus;
import org.micromanager.utils.MMException;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;

public abstract class AutofocusBase
implements Autofocus {
    private ArrayList<PropertyItem> properties_;
    Preferences prefs_;
    private static final String AF_UNIMPLEMENTED_FUNCTION = "Operation not supported.";

    public AutofocusBase() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this.prefs_ = preferences.node(preferences.absolutePath() + "/settings");
        this.properties_ = new ArrayList();
    }

    protected void createProperty(String string) {
        PropertyItem propertyItem = new PropertyItem();
        propertyItem.name = string;
        propertyItem.device = this.getDeviceName();
        this.properties_.add(propertyItem);
    }

    protected void createProperty(String string, String string2) {
        PropertyItem propertyItem = new PropertyItem();
        propertyItem.name = string;
        propertyItem.value = string2;
        propertyItem.device = this.getDeviceName();
        this.properties_.add(propertyItem);
    }

    protected void createProperty(String string, String string2, String[] stringArray) {
        PropertyItem propertyItem = new PropertyItem();
        propertyItem.allowed = stringArray;
        propertyItem.name = string;
        propertyItem.value = string2;
        propertyItem.device = this.getDeviceName();
        this.properties_.add(propertyItem);
    }

    protected void addProperty(PropertyItem propertyItem) {
        this.properties_.add(propertyItem);
    }

    public String[] getPropertyNames() {
        String[] stringArray = new String[this.properties_.size()];
        for (int i = 0; i < this.properties_.size(); ++i) {
            stringArray[i] = this.properties_.get((int)i).name;
        }
        return stringArray;
    }

    public String getPropertyValue(String string) throws MMException {
        for (int i = 0; i < this.properties_.size(); ++i) {
            if (!string.equals(this.properties_.get((int)i).name)) continue;
            return this.properties_.get((int)i).value;
        }
        throw new MMException("Unknown property: " + string);
    }

    public PropertyItem getProperty(String string) throws MMException {
        for (int i = 0; i < this.properties_.size(); ++i) {
            if (!string.equals(this.properties_.get((int)i).name)) continue;
            return this.properties_.get(i);
        }
        throw new MMException("Unknown property: " + string);
    }

    public void setProperty(PropertyItem propertyItem) throws MMException {
        for (int i = 0; i < this.properties_.size(); ++i) {
            if (!propertyItem.name.equals(this.properties_.get((int)i).name)) continue;
            this.properties_.set(i, propertyItem);
            return;
        }
        this.properties_.add(propertyItem);
    }

    public void setPropertyValue(String string, String string2) throws MMException {
        for (int i = 0; i < this.properties_.size(); ++i) {
            if (!string.equals(this.properties_.get((int)i).name)) continue;
            this.properties_.get((int)i).value = string2;
            return;
        }
        throw new MMException("Unknown property: " + string);
    }

    public PropertyItem[] getProperties() {
        return this.properties_.toArray(new PropertyItem[this.properties_.size()]);
    }

    public void saveSettings() {
        for (int i = 0; i < this.properties_.size(); ++i) {
            this.prefs_.put(this.properties_.get((int)i).name, this.properties_.get((int)i).value);
        }
    }

    public void loadSettings() {
        for (int i = 0; i < this.properties_.size(); ++i) {
            this.properties_.get((int)i).value = this.prefs_.get(this.properties_.get((int)i).name, this.properties_.get((int)i).value);
        }
    }

    public void dumpProperties(String string) {
        ReportingUtils.logMessage(string);
        for (int i = 0; i < this.properties_.size(); ++i) {
            this.properties_.get(i).dump();
        }
    }

    public void enableContinuousFocus(boolean bl) throws MMException {
        throw new MMException(AF_UNIMPLEMENTED_FUNCTION);
    }

    public boolean isContinuousFocusEnabled() throws MMException {
        return false;
    }

    public boolean isContinuousFocusLocked() throws MMException {
        return false;
    }
}

