/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.navigation;

import ij.IJ;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JOptionPane;
import mmcorej.CMMCore;
import mmcorej.MMCoreJ;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.utils.ReportingUtils;

public final class XYZKeyListener
implements KeyListener {
    private CMMCore core_;
    private MMStudioMainFrame gui_;
    private ImageCanvas canvas_;
    private static boolean isRunning_ = false;
    private boolean mirrorX_;
    private boolean mirrorY_;
    private boolean transposeXY_;
    private boolean correction_;
    private static final double zmoveIncrement_ = 0.2;
    public static int ctrlZStep = 1;
    public static int normalZStep = 3;
    public static int shiftZStep = 10;
    public static int ctrlXYStep = 1;
    public static int normalXYStep = 10;
    private int step;
    private double stepX;
    private double stepY;

    public XYZKeyListener(CMMCore cMMCore, MMStudioMainFrame mMStudioMainFrame) {
        this.core_ = cMMCore;
        this.gui_ = mMStudioMainFrame;
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.core_.logMessage(Integer.toString(keyEvent.getKeyCode()));
        block0 : switch (keyEvent.getKeyCode()) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.stepX = this.stepY = (double)normalXYStep;
                if (keyEvent.isControlDown()) {
                    this.stepX = this.stepY = (double)ctrlXYStep;
                } else if (keyEvent.isShiftDown()) {
                    this.stepX = this.core_.getImageWidth();
                    this.stepY = this.core_.getImageHeight();
                } else if (keyEvent.isAltDown()) {
                    this.stepX = this.core_.getImageWidth() / 2L;
                    this.stepY = this.core_.getImageHeight() / 2L;
                }
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        this.IncrementXY(-this.stepX, 0.0);
                        break;
                    }
                    case 39: {
                        this.IncrementXY(this.stepX, 0.0);
                        break;
                    }
                    case 38: {
                        this.IncrementXY(0.0, this.stepY);
                        break;
                    }
                    case 40: {
                        this.IncrementXY(0.0, -this.stepY);
                    }
                }
                break;
            }
            case 33: 
            case 34: 
            case 49: 
            case 50: 
            case 74: 
            case 85: {
                this.step = normalZStep;
                if (keyEvent.isControlDown()) {
                    this.step = ctrlZStep;
                } else if (keyEvent.isShiftDown()) {
                    this.step = shiftZStep;
                }
                switch (keyEvent.getKeyCode()) {
                    case 33: 
                    case 49: 
                    case 85: {
                        this.IncrementZ(-this.step);
                        break block0;
                    }
                    case 34: 
                    case 50: 
                    case 74: {
                        this.IncrementZ(this.step);
                    }
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void start() {
        if (WindowManager.getCurrentWindow() != null) {
            this.start(WindowManager.getCurrentWindow());
        }
    }

    public void start(ImageWindow imageWindow) {
        if (isRunning_) {
            this.stop();
        }
        isRunning_ = true;
        if (imageWindow != null) {
            this.attach(imageWindow);
        }
        this.getOrientation();
    }

    public void stop() {
        if (this.canvas_ != null) {
            this.canvas_.removeKeyListener((KeyListener)this);
            this.canvas_.addKeyListener((KeyListener)IJ.getInstance());
        }
        isRunning_ = false;
    }

    public boolean isRunning() {
        return isRunning_;
    }

    public void attach(ImageWindow imageWindow) {
        if (!isRunning_) {
            return;
        }
        this.canvas_ = imageWindow.getCanvas();
        this.canvas_.removeKeyListener((KeyListener)IJ.getInstance());
        this.canvas_.addKeyListener((KeyListener)this);
    }

    public void IncrementXY(double d, double d2) {
        this.getOrientation();
        String string = this.core_.getXYStageDevice();
        if (string == null) {
            return;
        }
        try {
            if (this.core_.deviceBusy(string)) {
                return;
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return;
        }
        double d3 = this.core_.getPixelSizeUm();
        if (!(d3 > 0.0)) {
            JOptionPane.showMessageDialog(null, "Please provide pixel size calibration data before using this function");
            return;
        }
        double d4 = d * d3;
        double d5 = d2 * d3;
        double d6 = d4;
        double d7 = d5;
        if (!this.correction_) {
            if (this.transposeXY_) {
                d6 = d5;
                d7 = d4;
            }
            if (this.mirrorX_) {
                d6 = -d6;
            }
            if (this.mirrorY_) {
                d7 = -d7;
            }
        }
        try {
            this.core_.setRelativeXYPosition(string, d6, d7);
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return;
        }
        this.gui_.updateXYPosRelative(d6, d7);
    }

    public void IncrementZ(int n) {
        String string = this.core_.getFocusDevice();
        if (string == null) {
            return;
        }
        double d = 0.2;
        double d2 = this.core_.getPixelSizeUm();
        if (d2 > 0.0) {
            d = d2;
        }
        try {
            this.core_.setRelativePosition(string, d * (double)n);
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return;
        }
    }

    public void getOrientation() {
        String string = this.core_.getCameraDevice();
        if (string == null) {
            JOptionPane.showMessageDialog(null, "This function does not work without a camera");
            return;
        }
        try {
            String string2 = this.core_.getProperty(string, "TransposeCorrection");
            this.correction_ = !string2.equals("0");
            string2 = this.core_.getProperty(string, MMCoreJ.getG_Keyword_Transpose_MirrorX());
            this.mirrorX_ = !string2.equals("0");
            string2 = this.core_.getProperty(string, MMCoreJ.getG_Keyword_Transpose_MirrorY());
            this.mirrorY_ = !string2.equals("0");
            string2 = this.core_.getProperty(string, MMCoreJ.getG_Keyword_Transpose_SwapXY());
            this.transposeXY_ = !string2.equals("0");
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return;
        }
    }
}

