/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.micromanager.graph.GraphData;
import org.micromanager.utils.ReportingUtils;

public class GraphPanel
extends JPanel {
    private static final long serialVersionUID = -1280955888510181945L;
    private GraphData data_;
    protected GraphData.Bounds bounds_;
    private float xMargin_ = 50.0f;
    private float yMargin_ = 50.0f;
    boolean textVisible_ = true;
    boolean gridVisible_ = true;
    private int TEXT_SIZE = 10;
    private float TEXT_OFFSET_X = 40.0f;
    private float TEXT_OFFSET_Y = 20.0f;
    float cursorLoPos_;
    float cursorHiPos_;
    double gamma_;
    private boolean fillTrace_ = false;
    private Color traceColor_ = Color.black;

    public GraphPanel() {
        this.data_ = new GraphData();
        this.setAutoBounds();
        this.cursorLoPos_ = (float)this.bounds_.xMin;
        this.cursorHiPos_ = (float)this.bounds_.xMax;
        this.gamma_ = 1.0;
    }

    public void setData(GraphData graphData) {
        this.data_ = graphData;
    }

    public void setGamma(double d) {
        this.gamma_ = d;
    }

    public void setTraceStyle(boolean bl, Color color) {
        this.fillTrace_ = bl;
        this.traceColor_ = color;
    }

    public final void setAutoBounds() {
        this.bounds_ = this.data_.getBounds();
        this.AdjustCursors();
    }

    public void setMargins(float f, float f2) {
        this.xMargin_ = f;
        this.yMargin_ = f2;
    }

    public void setCursors(double d, double d2, double d3) {
        this.cursorLoPos_ = (float)d;
        this.cursorHiPos_ = (float)d2;
        this.gamma_ = d3;
    }

    public void setTextVisible(boolean bl) {
        this.textVisible_ = bl;
    }

    public void setGridVisible(boolean bl) {
        this.gridVisible_ = bl;
    }

    public GraphData.Bounds getGraphBounds() {
        return this.bounds_;
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.bounds_.xMin = d;
        this.bounds_.xMax = d2;
        this.bounds_.yMin = d3;
        this.bounds_.yMax = d4;
        this.AdjustCursors();
    }

    public void setBounds(GraphData.Bounds bounds) {
        this.bounds_ = bounds;
        this.AdjustCursors();
    }

    private void AdjustCursors() {
        this.cursorLoPos_ = Math.max(this.cursorLoPos_, (float)this.bounds_.xMin);
    }

    protected void drawGraph(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.data_.getSize() < 2) {
            return;
        }
        Color color = graphics2D.getColor();
        graphics2D.setColor(this.traceColor_);
        float f = 1.0f;
        float f2 = 1.0f;
        if (this.bounds_.getRangeY() == 0.0) {
            if (this.bounds_.yMax > 0.0) {
                this.bounds_.yMin = 0.0;
            } else if (this.bounds_.yMax < 0.0) {
                this.bounds_.yMax = 0.0;
            }
        }
        if (this.bounds_.getRangeX() <= 0.0 || this.bounds_.getRangeY() <= 1.0E-10) {
            return;
        }
        f = (float)((double)rectangle.width / this.bounds_.getRangeX());
        f2 = (float)((double)rectangle.height / this.bounds_.getRangeY());
        GeneralPath generalPath = new GeneralPath(0, this.data_.getSize() + 1);
        Point2D.Float float_ = this.getDevicePoint(new Point2D.Float(0.0f, 0.0f), rectangle, f, f2);
        generalPath.moveTo(float_.x, float_.y);
        Point2D.Float float_2 = this.getDevicePoint(new Point2D.Float(1.0f, 0.0f), rectangle, f, f2);
        float f3 = (float_2.x - float_.x) / 2.0f;
        for (int i = 0; i < this.data_.getSize(); ++i) {
            Point2D.Float float_3 = this.getDevicePoint(this.data_.getPoint(i), rectangle, f, f2);
            generalPath.lineTo(float_3.x - f3, float_3.y);
            generalPath.lineTo(float_3.x + f3, float_3.y);
        }
        float_ = this.getDevicePoint(new Point2D.Float((float)this.data_.getPoint(this.data_.getSize() - 1).getX(), 0.0f), rectangle, f, f2);
        generalPath.lineTo(float_.x, float_.y);
        if (this.fillTrace_) {
            graphics2D.fill(generalPath);
        } else {
            graphics2D.draw(generalPath);
        }
        graphics2D.setColor(color);
    }

    public void drawCursor(Graphics2D graphics2D, Rectangle rectangle, float f) {
    }

    public void drawMapping(Graphics2D graphics2D, Rectangle rectangle, float f, float f2, double d) {
    }

    public Point2D.Float getDevicePointUnclippedXMax(Point2D.Float float_, Rectangle rectangle, float f, float f2) {
        Point2D.Float float_2 = new Point2D.Float((float)((double)float_.x - this.bounds_.xMin) * f + (float)rectangle.x, (float)rectangle.height - (float)((double)float_.y - this.bounds_.yMin) * f2 + (float)rectangle.y);
        float_2.x = Math.max(float_2.x, (float)rectangle.x);
        float_2.y = Math.max(Math.min(float_2.y, (float)rectangle.y + (float)rectangle.height), (float)rectangle.y);
        return float_2;
    }

    public Point2D.Float getDevicePoint(Point2D.Float float_, Rectangle rectangle, float f, float f2) {
        Point2D.Float float_2 = new Point2D.Float((float)((double)float_.x - this.bounds_.xMin) * f + (float)rectangle.x, (float)rectangle.height - (float)((double)float_.y - this.bounds_.yMin) * f2 + (float)rectangle.y);
        float_2.x = Math.max(Math.min(float_2.x, (float)rectangle.x + (float)rectangle.width), (float)rectangle.x);
        float_2.y = Math.max(Math.min(float_2.y, (float)rectangle.y + (float)rectangle.height), (float)rectangle.y);
        return float_2;
    }

    public Point2D.Float getPositionPoint(int n, int n2) {
        Rectangle rectangle = this.getBox();
        Point2D.Float float_ = new Point2D.Float((float)((double)((float)(n - rectangle.x) / (float)rectangle.width) * (this.bounds_.xMax - this.bounds_.xMin)), (float)((double)((float)(rectangle.y + rectangle.height - n2) / (float)rectangle.height) * (this.bounds_.yMax - this.bounds_.yMin)));
        return float_;
    }

    private void drawGrid(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.data_.getSize() < 2) {
            ReportingUtils.logMessage("Invalid size " + this.data_.getSize());
            return;
        }
        if (this.bounds_.getRangeY() == 0.0) {
            if (this.bounds_.yMax > 0.0) {
                this.bounds_.yMin = 0.0;
            } else if (this.bounds_.yMax < 0.0) {
                this.bounds_.yMax = 0.0;
            }
        }
        if (this.bounds_.getRangeX() <= 0.0 || this.bounds_.getRangeY() <= 0.0) {
            return;
        }
        int n = 5;
        int n2 = 5;
        int n3 = rectangle.width / n;
        int n4 = rectangle.height / n2;
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(Color.gray);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.draw(rectangle);
        if (this.gridVisible_) {
            int n5;
            int n6;
            for (n6 = 1; n6 < n; ++n6) {
                n5 = rectangle.x + n3 * n6;
                graphics2D.draw(new Line2D.Float(n5, rectangle.y + rectangle.height, n5, rectangle.y));
            }
            for (n6 = 1; n6 < n; ++n6) {
                n5 = rectangle.y + n4 * n6;
                graphics2D.draw(new Line2D.Float(rectangle.x, n5, rectangle.x + rectangle.width, n5));
            }
        }
        graphics2D.setColor(Color.black);
        if (this.textVisible_) {
            Font font = new Font("Arial", 0, this.TEXT_SIZE);
            Font font2 = graphics2D.getFont();
            graphics2D.setFont(font);
            DecimalFormat decimalFormat = new DecimalFormat("#0.00");
            graphics2D.drawString(decimalFormat.format(this.bounds_.xMin), (float)rectangle.x, (float)(rectangle.y + rectangle.height) + this.TEXT_OFFSET_Y);
            graphics2D.drawString(decimalFormat.format(this.bounds_.xMax).toString(), (float)(rectangle.x + rectangle.width), (float)(rectangle.y + rectangle.height) + this.TEXT_OFFSET_Y);
            graphics2D.drawString(decimalFormat.format(this.bounds_.yMin).toString(), (float)rectangle.x - this.TEXT_OFFSET_X, (float)(rectangle.y + rectangle.height));
            graphics2D.drawString(decimalFormat.format(this.bounds_.yMax).toString(), (float)rectangle.x - this.TEXT_OFFSET_X, (float)rectangle.y);
            graphics2D.setFont(font2);
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    public Rectangle getBox() {
        Rectangle rectangle = this.getBounds();
        rectangle.x = (int)this.xMargin_;
        rectangle.y = (int)this.yMargin_;
        rectangle.height = (int)((float)rectangle.height - 2.0f * this.yMargin_);
        rectangle.width = (int)((float)rectangle.width - 2.0f * this.xMargin_);
        return rectangle;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle rectangle = this.getBox();
        Color color = graphics2D.getColor();
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setPaint(Color.black);
        graphics2D.setStroke(new BasicStroke(2.0f));
        this.drawGraph(graphics2D, rectangle);
        this.drawGrid(graphics2D, rectangle);
        this.drawCursor(graphics2D, rectangle, this.cursorLoPos_);
        this.drawCursor(graphics2D, rectangle, this.cursorHiPos_);
        this.drawMapping(graphics2D, rectangle, this.cursorLoPos_, this.cursorHiPos_, this.gamma_);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }
}

