/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import java.awt.geom.Point2D;

public class GraphData {
    private double[] xVals_ = new double[100];
    private double[] yVals_ = new double[100];
    private double xBinSize_;

    public GraphData() {
        for (int i = 0; i < this.xVals_.length; ++i) {
            this.xVals_[i] = i;
            this.yVals_[i] = 0.0;
        }
    }

    public Bounds getBounds() {
        int n;
        Bounds bounds = new Bounds();
        bounds.xMax = Double.MIN_VALUE;
        bounds.xMin = Double.MAX_VALUE;
        bounds.yMax = Double.MIN_VALUE;
        bounds.yMin = Double.MAX_VALUE;
        for (n = 0; n < this.xVals_.length; ++n) {
            if (this.xVals_[n] > bounds.xMax) {
                bounds.xMax = this.xVals_[n];
            }
            if (!(this.xVals_[n] < bounds.xMin)) continue;
            bounds.xMin = this.xVals_[n];
        }
        for (n = 0; n < this.yVals_.length; ++n) {
            if (this.yVals_[n] > bounds.yMax) {
                bounds.yMax = this.yVals_[n];
            }
            if (!(this.yVals_[n] < bounds.yMin)) continue;
            bounds.yMin = this.yVals_[n];
        }
        return bounds;
    }

    public int getSize() {
        return this.xVals_.length;
    }

    public double getXBinSize() {
        return this.xBinSize_;
    }

    public void setXBinSize(double d) {
        this.xBinSize_ = d;
    }

    public Point2D.Float getPoint(int n) {
        double d = this.xVals_[n];
        double d2 = n < this.yVals_.length ? this.yVals_[n] : 0.0;
        return new Point2D.Float((float)d, (float)d2);
    }

    public void setData(double[] dArray, double[] dArray2) {
        this.xVals_ = dArray;
        this.yVals_ = dArray2;
    }

    public void setData(double[] dArray) {
        this.yVals_ = dArray;
        this.xVals_ = new double[dArray.length];
        for (int i = 0; i < this.xVals_.length; ++i) {
            this.xVals_[i] = i;
        }
    }

    public void setData(int[] nArray) {
        this.yVals_ = new double[nArray.length];
        this.xVals_ = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.yVals_[i] = nArray[i];
            this.xVals_[i] = i;
        }
    }

    public class Bounds {
        public double xMin = 0.0;
        public double xMax = 0.0;
        public double yMin = 0.0;
        public double yMax = 0.0;

        public Bounds() {
            GraphData.this.xBinSize_ = 1.0;
        }

        double getRangeX() {
            return this.xMax - this.xMin;
        }

        double getRangeY() {
            return this.yMax - this.yMin;
        }
    }
}

