/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import ij.CompositeImage;
import ij.ImagePlus;
import ij.gui.Overlay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.micromanager.acquisition.MetadataPanel;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.graph.HistogramControlsState;
import org.micromanager.graph.MultiChannelHistograms;
import org.micromanager.internalinterfaces.Histograms;
import org.micromanager.utils.MMScaleBar;

public class ContrastPanel
extends JPanel {
    private static final String PREF_AUTOSTRETCH = "stretch_contrast";
    private static final String PREF_REJECT_OUTLIERS = "reject_outliers";
    private static final String PREF_REJECT_FRACTION = "reject_fraction";
    private static final String PREF_LOG_HIST = "log_hist";
    private static final String PREF_SYNC_CHANNELS = "sync_channels";
    private static final String PREF_SLOW_HIST = "slow_hist";
    private JScrollPane histDisplayScrollPane_;
    private JComboBox displayModeCombo_;
    private JCheckBox autostretchCheckBox_;
    private JCheckBox rejectOutliersCheckBox_;
    private JSpinner rejectPercentSpinner_;
    private JCheckBox logHistCheckBox_;
    private JCheckBox sizeBarCheckBox_;
    private JComboBox sizeBarComboBox_;
    private JComboBox sizeBarColorComboBox_;
    private JCheckBox syncChannelsCheckBox_;
    private JCheckBox slowHistCheckBox_;
    private JLabel displayModeLabel_;
    private MetadataPanel mdPanel_;
    private Preferences prefs_;
    private Color overlayColor_ = Color.white;
    private Histograms currentHistograms_;
    private VirtualAcquisitionDisplay currentDisplay_;

    public ContrastPanel(MetadataPanel metadataPanel) {
        this.mdPanel_ = metadataPanel;
        this.initializeGUI();
        this.prefs_ = Preferences.userNodeForPackage(this.getClass());
        this.initializeHistogramDisplayArea();
    }

    private void initializeHistogramDisplayArea() {
        this.histDisplayScrollPane_.setHorizontalScrollBarPolicy(31);
        this.showCurrentHistograms();
        this.configureControls();
    }

    private void showCurrentHistograms() {
        this.histDisplayScrollPane_.setViewportView(this.currentHistograms_ != null ? (JPanel)((Object)this.currentHistograms_) : new JPanel());
        if (this.currentDisplay_ != null && this.currentDisplay_.getImageCache().getNumChannels() > 1) {
            this.histDisplayScrollPane_.setVerticalScrollBarPolicy(20);
        } else {
            this.histDisplayScrollPane_.setVerticalScrollBarPolicy(21);
        }
        this.repaint();
    }

    public HistogramControlsState createDefaultControlsState() {
        HistogramControlsState histogramControlsState = new HistogramControlsState();
        histogramControlsState.autostretch = this.prefs_.getBoolean(PREF_AUTOSTRETCH, true);
        histogramControlsState.percentToIgnore = this.prefs_.getDouble(PREF_REJECT_FRACTION, 2.0);
        histogramControlsState.logHist = this.prefs_.getBoolean(PREF_LOG_HIST, false);
        histogramControlsState.ignoreOutliers = this.prefs_.getBoolean(PREF_REJECT_OUTLIERS, false);
        histogramControlsState.syncChannels = this.prefs_.getBoolean(PREF_SYNC_CHANNELS, false);
        histogramControlsState.slowHist = this.prefs_.getBoolean(PREF_SLOW_HIST, false);
        histogramControlsState.scaleBar = false;
        histogramControlsState.scaleBarColorIndex = 0;
        histogramControlsState.scaleBarLocationIndex = 0;
        return histogramControlsState;
    }

    private void configureControls() {
        this.loadControlsStates();
        if (this.currentDisplay_ == null) {
            this.displayModeLabel_.setEnabled(false);
            this.displayModeCombo_.setEnabled(false);
            this.sizeBarCheckBox_.setEnabled(false);
            this.sizeBarComboBox_.setEnabled(false);
            this.sizeBarColorComboBox_.setEnabled(false);
            this.autostretchCheckBox_.setEnabled(false);
            this.slowHistCheckBox_.setEnabled(false);
            this.logHistCheckBox_.setEnabled(false);
            this.rejectOutliersCheckBox_.setEnabled(false);
            this.rejectPercentSpinner_.setEnabled(false);
            this.syncChannelsCheckBox_.setEnabled(false);
        } else if (this.currentDisplay_.getImageCache().getNumChannels() == 1) {
            this.displayModeLabel_.setEnabled(false);
            this.displayModeCombo_.setEnabled(false);
            this.sizeBarCheckBox_.setEnabled(true);
            this.sizeBarComboBox_.setEnabled(this.sizeBarCheckBox_.isSelected());
            this.sizeBarColorComboBox_.setEnabled(this.sizeBarCheckBox_.isSelected());
            this.syncChannelsCheckBox_.setEnabled(false);
            this.logHistCheckBox_.setEnabled(true);
            this.slowHistCheckBox_.setEnabled(true);
            this.autostretchCheckBox_.setEnabled(true);
            if (this.autostretchCheckBox_.isSelected()) {
                this.rejectOutliersCheckBox_.setEnabled(true);
                this.rejectPercentSpinner_.setEnabled(this.rejectOutliersCheckBox_.isSelected());
            } else {
                this.rejectOutliersCheckBox_.setEnabled(false);
                this.rejectPercentSpinner_.setEnabled(false);
            }
        } else {
            this.displayModeLabel_.setEnabled(true);
            this.displayModeCombo_.setEnabled(true);
            this.sizeBarCheckBox_.setEnabled(true);
            this.sizeBarComboBox_.setEnabled(this.sizeBarCheckBox_.isSelected());
            this.sizeBarColorComboBox_.setEnabled(this.sizeBarCheckBox_.isSelected());
            this.logHistCheckBox_.setEnabled(true);
            this.slowHistCheckBox_.setEnabled(true);
            this.syncChannelsCheckBox_.setEnabled(true);
        }
    }

    private void loadControlsStates() {
        HistogramControlsState histogramControlsState = this.currentDisplay_ != null ? this.currentDisplay_.getHistogramControlsState() : this.createDefaultControlsState();
        this.logHistCheckBox_.setSelected(histogramControlsState.logHist);
        this.rejectPercentSpinner_.setValue(histogramControlsState.percentToIgnore);
        this.autostretchCheckBox_.setSelected(histogramControlsState.autostretch);
        this.rejectOutliersCheckBox_.setSelected(histogramControlsState.ignoreOutliers);
        this.syncChannelsCheckBox_.setSelected(histogramControlsState.syncChannels);
        this.slowHistCheckBox_.setSelected(histogramControlsState.slowHist);
        boolean bl = histogramControlsState.scaleBar;
        int n = histogramControlsState.scaleBarColorIndex;
        int n2 = histogramControlsState.scaleBarLocationIndex;
        this.sizeBarCheckBox_.setSelected(bl);
        this.sizeBarColorComboBox_.setSelectedIndex(n);
        this.sizeBarComboBox_.setSelectedIndex(n2);
        if (this.currentDisplay_ != null && this.currentDisplay_.getImagePlus() instanceof CompositeImage) {
            CompositeImage compositeImage = (CompositeImage)this.currentDisplay_.getImagePlus();
            boolean[] blArray = new boolean[compositeImage.getActiveChannels().length];
            System.arraycopy(compositeImage.getActiveChannels(), 0, blArray, 0, blArray.length);
            int n3 = ((CompositeImage)this.currentDisplay_.getImagePlus()).getMode() - 2;
            if (n3 == -1) {
                n3 = 2;
            }
            this.displayModeCombo_.setSelectedIndex(n3);
            for (int i = 0; i < blArray.length; ++i) {
                compositeImage.getActiveChannels()[i] = blArray[i];
            }
            compositeImage.updateAndDraw();
            this.currentDisplay_.updateAndDraw();
        } else {
            this.displayModeCombo_.setSelectedIndex(1);
        }
    }

    private void saveCheckBoxStates() {
        this.prefs_.putBoolean(PREF_AUTOSTRETCH, this.autostretchCheckBox_.isSelected());
        this.prefs_.putBoolean(PREF_LOG_HIST, this.logHistCheckBox_.isSelected());
        this.prefs_.putDouble(PREF_REJECT_FRACTION, (Double)this.rejectPercentSpinner_.getValue());
        this.prefs_.putBoolean(PREF_REJECT_OUTLIERS, this.rejectOutliersCheckBox_.isSelected());
        this.prefs_.putBoolean(PREF_SYNC_CHANNELS, this.syncChannelsCheckBox_.isSelected());
        this.prefs_.putBoolean(PREF_SLOW_HIST, this.slowHistCheckBox_.isSelected());
        if (this.currentDisplay_ == null) {
            return;
        }
        HistogramControlsState histogramControlsState = this.currentDisplay_.getHistogramControlsState();
        histogramControlsState.autostretch = this.autostretchCheckBox_.isSelected();
        histogramControlsState.ignoreOutliers = this.rejectOutliersCheckBox_.isSelected();
        histogramControlsState.logHist = this.logHistCheckBox_.isSelected();
        histogramControlsState.percentToIgnore = (Double)this.rejectPercentSpinner_.getValue();
        histogramControlsState.slowHist = this.slowHistCheckBox_.isSelected();
        histogramControlsState.syncChannels = this.syncChannelsCheckBox_.isSelected();
        histogramControlsState.scaleBar = this.sizeBarCheckBox_.isSelected();
        histogramControlsState.scaleBarColorIndex = this.sizeBarColorComboBox_.getSelectedIndex();
        histogramControlsState.scaleBarLocationIndex = this.sizeBarComboBox_.getSelectedIndex();
    }

    private void initializeGUI() {
        JPanel jPanel = new JPanel();
        this.displayModeLabel_ = new JLabel();
        this.displayModeCombo_ = new JComboBox();
        this.autostretchCheckBox_ = new JCheckBox();
        this.rejectOutliersCheckBox_ = new JCheckBox();
        this.rejectPercentSpinner_ = new JSpinner();
        this.logHistCheckBox_ = new JCheckBox();
        this.sizeBarCheckBox_ = new JCheckBox();
        this.sizeBarComboBox_ = new JComboBox();
        this.sizeBarColorComboBox_ = new JComboBox();
        this.histDisplayScrollPane_ = new JScrollPane();
        this.setPreferredSize(new Dimension(400, 594));
        this.displayModeCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"Color", "Grayscale", "Composite"}));
        this.displayModeCombo_.setToolTipText("<html>Choose display mode:<br> - Composite = Multicolor overlay<br> - Color = Single channel color view<br> - Grayscale = Single channel grayscale view</li></ul></html>");
        this.displayModeCombo_.setSelectedIndex(2);
        this.displayModeCombo_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContrastPanel.this.displayModeComboActionPerformed();
            }
        });
        this.displayModeLabel_.setText("Display mode:");
        this.autostretchCheckBox_.setText("Autostretch");
        this.autostretchCheckBox_.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ContrastPanel.this.autostretchCheckBoxStateChanged();
            }
        });
        this.rejectOutliersCheckBox_.setText("ignore %");
        this.rejectOutliersCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContrastPanel.this.rejectOutliersCheckBoxAction();
            }
        });
        this.rejectPercentSpinner_.setFont(new Font("Lucida Grande", 0, 10));
        this.rejectPercentSpinner_.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ContrastPanel.this.rejectPercentageChanged();
            }
        });
        this.rejectPercentSpinner_.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ContrastPanel.this.rejectPercentageChanged();
            }
        });
        this.rejectPercentSpinner_.setModel(new SpinnerNumberModel(0.02, 0.0, 100.0, 0.1));
        this.logHistCheckBox_.setText("Log hist");
        this.logHistCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContrastPanel.this.logScaleCheckBoxActionPerformed();
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)jPanel);
        jPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(24, Short.MAX_VALUE).add((Component)this.displayModeLabel_).addPreferredGap(0).add((Component)this.displayModeCombo_, -2, 134, -2).addPreferredGap(0).add((Component)this.autostretchCheckBox_).addPreferredGap(0).add((Component)this.rejectOutliersCheckBox_).add(6, 6, 6).add((Component)this.rejectPercentSpinner_, -2, 63, -2).addPreferredGap(0).add((Component)this.logHistCheckBox_)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(4).add((Component)this.autostretchCheckBox_).add((Component)this.rejectOutliersCheckBox_).add((Component)this.rejectPercentSpinner_, -2, -1, -2).add((Component)this.logHistCheckBox_)).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.displayModeCombo_, -2, -1, -2).add((Component)this.displayModeLabel_)));
        this.sizeBarCheckBox_.setText("Scale Bar");
        this.sizeBarCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContrastPanel.this.sizeBarCheckBoxActionPerformed();
            }
        });
        this.sizeBarComboBox_.setModel(new DefaultComboBoxModel<String>(new String[]{"Top-Left", "Top-Right", "Bottom-Left", "Bottom-Right"}));
        this.sizeBarComboBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContrastPanel.this.sizeBarComboBoxActionPerformed();
            }
        });
        this.sizeBarColorComboBox_.setModel(new DefaultComboBoxModel<String>(new String[]{"White", "Black", "Yellow", "Gray"}));
        this.sizeBarColorComboBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContrastPanel.this.overlayColorComboBox_ActionPerformed();
            }
        });
        this.syncChannelsCheckBox_ = new JCheckBox("Sync channels");
        this.syncChannelsCheckBox_.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ContrastPanel.this.syncChannelsCheckboxAction();
            }
        });
        this.slowHistCheckBox_ = new JCheckBox("Slow hist");
        this.slowHistCheckBox_.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ContrastPanel.this.slowHistCheckboxAction();
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.sizeBarCheckBox_).addPreferredGap(1).add((Component)this.sizeBarComboBox_, -2, 134, -2).addPreferredGap(0).add((Component)this.sizeBarColorComboBox_, -2, 105, -2).addPreferredGap(1).add((Component)this.syncChannelsCheckBox_, -2, -1, -2).add((Component)this.slowHistCheckBox_, -2, -1, -2)).add((Component)jPanel, -2, -1, -2).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.histDisplayScrollPane_, -1, 620, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.sizeBarCheckBox_).add((Component)this.sizeBarComboBox_, -2, -1, -2).add((Component)this.sizeBarColorComboBox_, -2, -1, -2).add((Component)this.syncChannelsCheckBox_, -2, -1, -2).add((Component)this.slowHistCheckBox_, -2, -1, -2)).addPreferredGap(1).add((Component)jPanel, -2, -1, -2).addContainerGap(589, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(79, 79, 79).add((Component)this.histDisplayScrollPane_, -1, 571, Short.MAX_VALUE))));
    }

    public void setDisplayMode(int n) {
        if (n == 1) {
            this.displayModeCombo_.setSelectedIndex(2);
        } else if (n == 2) {
            this.displayModeCombo_.setSelectedIndex(0);
        } else if (n == 3) {
            this.displayModeCombo_.setSelectedIndex(1);
        }
    }

    private void showSizeBar() {
        MMScaleBar mMScaleBar;
        boolean bl = this.sizeBarCheckBox_.isSelected();
        if (this.currentDisplay_ == null) {
            return;
        }
        ImagePlus imagePlus = this.currentDisplay_.getHyperImage();
        if (bl && (mMScaleBar = new MMScaleBar(imagePlus)) != null) {
            Overlay overlay = new Overlay();
            overlay.setStrokeColor(this.overlayColor_);
            String string = (String)this.sizeBarComboBox_.getSelectedItem();
            if (string.equals("Top-Right")) {
                mMScaleBar.setPosition(MMScaleBar.Position.TOPRIGHT);
            }
            if (string.equals("Top-Left")) {
                mMScaleBar.setPosition(MMScaleBar.Position.TOPLEFT);
            }
            if (string.equals("Bottom-Right")) {
                mMScaleBar.setPosition(MMScaleBar.Position.BOTTOMRIGHT);
            }
            if (string.equals("Bottom-Left")) {
                mMScaleBar.setPosition(MMScaleBar.Position.BOTTOMLEFT);
            }
            mMScaleBar.addToOverlay(overlay);
            overlay.setStrokeColor(this.overlayColor_);
            imagePlus.setOverlay(overlay);
        }
        imagePlus.setHideOverlay(!bl);
        this.saveCheckBoxStates();
    }

    private void overlayColorComboBox_ActionPerformed() {
        if (this.sizeBarColorComboBox_.getSelectedItem().equals("Black")) {
            this.overlayColor_ = Color.black;
        } else if (this.sizeBarColorComboBox_.getSelectedItem().equals("White")) {
            this.overlayColor_ = Color.white;
        } else if (this.sizeBarColorComboBox_.getSelectedItem().equals("Yellow")) {
            this.overlayColor_ = Color.yellow;
        } else if (this.sizeBarColorComboBox_.getSelectedItem().equals("Gray")) {
            this.overlayColor_ = Color.gray;
        }
        if (this.sizeBarCheckBox_.isSelected()) {
            this.showSizeBar();
        }
    }

    private void syncChannelsCheckboxAction() {
        if (!this.syncChannelsCheckBox_.isEnabled()) {
            return;
        }
        boolean bl = this.syncChannelsCheckBox_.isSelected();
        if (bl) {
            this.autostretchCheckBox_.setSelected(false);
            this.autostretchCheckBox_.setEnabled(false);
            if (this.currentHistograms_ != null) {
                ((MultiChannelHistograms)this.currentHistograms_).setChannelContrastFromFirst();
                ((MultiChannelHistograms)this.currentHistograms_).setChannelDisplayModeFromFirst();
            }
        } else {
            this.autostretchCheckBox_.setEnabled(true);
        }
        this.saveCheckBoxStates();
    }

    private void slowHistCheckboxAction() {
        this.saveCheckBoxStates();
    }

    public void displayModeComboActionPerformed() {
        if (this.currentDisplay_ == null || !(this.currentDisplay_.getHyperImage() instanceof CompositeImage)) {
            return;
        }
        int n = this.displayModeCombo_.getSelectedIndex();
        int n2 = n == 0 ? 2 : (n == 1 ? 3 : 1);
        CompositeImage compositeImage = (CompositeImage)this.currentDisplay_.getHyperImage();
        if (n == 2 && this.currentDisplay_.getImageCache().getNumChannels() > 7) {
            JOptionPane.showMessageDialog(this, "Images with more than 7 channels cannot be displayed in Composite mode");
            this.displayModeCombo_.setSelectedIndex(compositeImage.getMode() - 2);
            return;
        }
        compositeImage.setMode(n2);
        compositeImage.updateAndDraw();
        this.currentDisplay_.updateAndDraw();
        this.saveCheckBoxStates();
    }

    private void autostretchCheckBoxStateChanged() {
        this.rejectOutliersCheckBox_.setEnabled(this.autostretchCheckBox_.isSelected());
        boolean bl = this.rejectOutliersCheckBox_.isSelected() && this.autostretchCheckBox_.isSelected();
        this.rejectPercentSpinner_.setEnabled(bl);
        this.saveCheckBoxStates();
        if (this.autostretchCheckBox_.isSelected()) {
            if (this.currentHistograms_ != null) {
                this.currentHistograms_.autoscaleAllChannels();
            }
        } else {
            this.rejectOutliersCheckBox_.setSelected(false);
        }
    }

    private void rejectOutliersCheckBoxAction() {
        this.saveCheckBoxStates();
        this.rejectPercentSpinner_.setEnabled(this.rejectOutliersCheckBox_.isSelected());
        if (this.currentHistograms_ != null) {
            this.currentHistograms_.rejectOutliersChangeAction();
        }
    }

    private void rejectPercentageChanged() {
        this.saveCheckBoxStates();
        if (this.currentHistograms_ != null) {
            this.currentHistograms_.rejectOutliersChangeAction();
        }
    }

    private void logScaleCheckBoxActionPerformed() {
        this.saveCheckBoxStates();
        if (this.currentHistograms_ != null) {
            this.currentHistograms_.calcAndDisplayHistAndStats(true);
        }
    }

    public void sizeBarCheckBoxActionPerformed() {
        boolean bl = this.sizeBarCheckBox_.isSelected();
        this.sizeBarComboBox_.setEnabled(bl);
        this.sizeBarColorComboBox_.setEnabled(bl);
        this.showSizeBar();
    }

    private void sizeBarComboBoxActionPerformed() {
        if (this.sizeBarCheckBox_.isSelected()) {
            this.showSizeBar();
        }
    }

    public void autostretch() {
        if (this.currentHistograms_ != null) {
            this.currentHistograms_.autostretch();
        }
    }

    public void imageChanged() {
        if (this.currentHistograms_ != null) {
            ((JPanel)((Object)this.currentHistograms_)).repaint();
        }
    }

    public synchronized void displayChanged(VirtualAcquisitionDisplay virtualAcquisitionDisplay) {
        this.currentDisplay_ = virtualAcquisitionDisplay;
        this.currentHistograms_ = virtualAcquisitionDisplay != null ? virtualAcquisitionDisplay.getHistograms() : null;
        this.configureControls();
        this.showCurrentHistograms();
    }

    public void disableAutostretch() {
        this.autostretchCheckBox_.setSelected(false);
    }
}

