/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import mmcorej.MMCoreJ;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.DeviceSetupDlg;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.Setting;
import org.micromanager.utils.MMPropertyTableModel;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;

class PropertyTableModel
extends AbstractTableModel
implements MMPropertyTableModel {
    private static final long serialVersionUID = 1L;
    public final String[] COLUMN_NAMES = new String[]{"Device", "Property", "Value"};
    public static final int ALL = 0;
    public static final int PREINIT = 1;
    public static final int COMPORT = 2;
    MicroscopeModel model_;
    Device[] devices_;
    PropertyItem[] props_;
    String[] devNames_;
    DeviceSetupDlg setupDlg_;

    public PropertyTableModel(MicroscopeModel microscopeModel, int n) {
        this.setupDlg_ = null;
        this.updateValues(microscopeModel, n, null);
    }

    public PropertyTableModel(MicroscopeModel microscopeModel, Device device, DeviceSetupDlg deviceSetupDlg) {
        this.setupDlg_ = deviceSetupDlg;
        this.updateValues(microscopeModel, 1, device);
    }

    public void updateValues(MicroscopeModel microscopeModel, int n, Device device) {
        int n2;
        this.model_ = microscopeModel;
        if (device == null) {
            this.devices_ = n == 2 ? microscopeModel.getAvailableSerialPorts() : microscopeModel.getDevices();
        } else {
            this.devices_ = new Device[1];
            this.devices_[0] = device;
        }
        this.model_.dumpComPortsSetupProps();
        ArrayList<PropertyItem> arrayList = new ArrayList<PropertyItem>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n2 = 0; n2 < this.devices_.length; ++n2) {
            for (int i = 0; i < this.devices_[n2].getNumberOfProperties(); ++i) {
                PropertyItem propertyItem;
                PropertyItem propertyItem2 = this.devices_[n2].getProperty(i);
                if (n == 1) {
                    if (propertyItem2.readOnly || !propertyItem2.preInit || this.devices_[n2].isSerialPort() || propertyItem2.readOnly) continue;
                    arrayList.add(propertyItem2);
                    arrayList2.add(this.devices_[n2].getName());
                    propertyItem = this.devices_[n2].findSetupProperty(propertyItem2.name);
                    if (propertyItem == null) continue;
                    propertyItem2.value = propertyItem.value;
                    continue;
                }
                if (n == 2) {
                    if (!this.devices_[n2].isSerialPort() || !this.model_.isPortInUse(this.devices_[n2]) || propertyItem2.readOnly) continue;
                    arrayList.add(propertyItem2);
                    arrayList2.add(this.devices_[n2].getName());
                    propertyItem = this.devices_[n2].findSetupProperty(propertyItem2.name);
                    if (propertyItem == null) continue;
                    propertyItem2.value = propertyItem.value;
                    continue;
                }
                if (propertyItem2.readOnly || this.devices_[n2].isSerialPort()) continue;
                arrayList.add(propertyItem2);
                arrayList2.add(this.devices_[n2].getName());
                propertyItem = this.devices_[n2].findSetupProperty(propertyItem2.name);
                if (propertyItem == null) continue;
                propertyItem2.value = propertyItem.value;
            }
        }
        this.props_ = new PropertyItem[arrayList.size()];
        this.devNames_ = new String[arrayList2.size()];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            this.props_[n2] = (PropertyItem)arrayList.get(n2);
            this.devNames_[n2] = (String)arrayList2.get(n2);
        }
    }

    public int getRowCount() {
        return this.props_.length;
    }

    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    public String getColumnName(int n) {
        return this.COLUMN_NAMES[n];
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.devNames_[n];
        }
        if (n2 == 1) {
            return this.props_[n].name;
        }
        return this.props_[n].value;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 2) {
            try {
                this.props_[n].value = (String)object;
                this.fireTableCellUpdated(n, n2);
                if (this.props_[n].name.compareTo(MMCoreJ.getG_Keyword_Port()) == 0 && this.setupDlg_ != null) {
                    this.setupDlg_.rebuildComTable(this.props_[n].value);
                }
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception.getMessage());
            }
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 2 && !this.props_[n].readOnly;
    }

    public void refresh() {
        this.fireTableDataChanged();
    }

    public PropertyItem getPropertyItem(int n) {
        return this.props_[n];
    }

    public Setting getSetting(int n) {
        return new Setting(this.devNames_[n], this.props_[n].name, this.props_[n].value);
    }

    public PropertyItem getProperty(Setting setting) {
        for (int i = 0; i < this.devices_.length; ++i) {
            if (this.devices_[i].getName().compareTo(setting.deviceName_) != 0) continue;
            return this.devices_[i].findSetupProperty(setting.propertyName_);
        }
        return null;
    }
}

