/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.MMCoreJ;
import mmcorej.PropertySetting;
import mmcorej.StrVector;
import org.micromanager.conf2.ConfigGroup;
import org.micromanager.conf2.ConfigPreset;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.Label;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.Setting;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroscopeModel {
    ArrayList<Device> devices_ = new ArrayList();
    Device[] availableDevices_ = new Device[0];
    Device[] availableComPorts_;
    Device[] availableHubs_;
    Vector<String> badLibraries_ = new Vector();
    Hashtable<String, Device> comPortInUse_;
    boolean modified_ = false;
    String fileName_ = "";
    Hashtable<String, ConfigGroup> configGroups_;
    ConfigGroup pixelSizeGroup_;
    ArrayList<String> synchroDevices_;
    public static final String DEVLIST_FILE_NAME = "MMDeviceList.txt";
    public static final String PIXEL_SIZE_GROUP = "PixelSizeGroup";
    boolean sendConfiguration_ = false;

    public static boolean generateDeviceListFile(StringBuffer stringBuffer, CMMCore cMMCore) {
        try {
            int n;
            Object object;
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(DEVLIST_FILE_NAME);
            CMMCore cMMCore2 = null == cMMCore ? new CMMCore() : cMMCore;
            cMMCore2.enableDebugLog(true);
            StrVector strVector = MicroscopeModel.getDeviceLibraries(cMMCore2);
            ArrayList<Device> arrayList = new ArrayList<Device>();
            int n2 = 0;
            while ((long)n2 < strVector.size()) {
                try {
                    object = Device.getLibraryContents(strVector.get(n2), cMMCore2);
                    for (n = 0; n < ((Device[])object).length; ++n) {
                        arrayList.add(object[n]);
                    }
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                }
                ++n2;
            }
            if (null == cMMCore) {
                cMMCore2.delete();
            }
            File file = new File(stringBuffer.toString());
            try {
                object = new BufferedWriter(new FileWriter(file.getAbsolutePath()));
                for (n = 0; n < arrayList.size(); ++n) {
                    Device device = (Device)arrayList.get(n);
                    if (device.isSerialPort()) continue;
                    String string = device.getDescription().replaceAll(",", ";");
                    ((Writer)object).write(device.getLibrary() + "," + device.getAdapterName() + "," + string + "," + device.getTypeAsInt());
                    ((BufferedWriter)object).newLine();
                }
                ((BufferedWriter)object).close();
            }
            catch (IOException iOException) {
                ReportingUtils.showError(iOException, "Unable to open the output file: " + stringBuffer);
                return false;
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
        return true;
    }

    public MicroscopeModel() {
        this.availableHubs_ = new Device[0];
        this.configGroups_ = new Hashtable();
        this.synchroDevices_ = new ArrayList();
        this.availableComPorts_ = new Device[0];
        this.pixelSizeGroup_ = new ConfigGroup(PIXEL_SIZE_GROUP);
        Device device = new Device(MMCoreJ.getG_Keyword_CoreDevice(), "Default", "MMCore", "Core controller");
        this.devices_.add(device);
        this.addMissingProperties();
        this.addSystemConfigs();
    }

    public boolean isModified() {
        return this.modified_;
    }

    public void setModified(boolean bl) {
        this.modified_ = bl;
    }

    public String getFileName() {
        return this.fileName_;
    }

    public void setFileName(String string) {
        this.fileName_ = string;
    }

    public void loadDeviceDataFromHardware(CMMCore cMMCore) throws Exception {
        int n;
        for (n = 0; n < this.devices_.size(); ++n) {
            Device device = this.devices_.get(n);
            device.loadDataFromHardware(cMMCore);
        }
        for (n = 0; n < this.availableComPorts_.length; ++n) {
            this.availableComPorts_[n].loadDataFromHardware(cMMCore);
        }
    }

    public void loadStateLabelsFromHardware(CMMCore cMMCore) throws Exception {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device device = this.devices_.get(i);
            if (device.getNumberOfSetupLabels() != 0) continue;
            device.getSetupLabelsFromHardware(cMMCore);
        }
    }

    public static StrVector getDeviceLibraries(CMMCore cMMCore) throws Exception {
        return CMMCore.getDeviceLibraries();
    }

    public void loadAvailableDeviceList(CMMCore cMMCore) {
        try {
            ArrayList<Device> arrayList = new ArrayList<Device>();
            ArrayList<Device> arrayList2 = new ArrayList<Device>();
            this.availableDevices_ = new Device[0];
            ArrayList<Device> arrayList3 = new ArrayList<Device>();
            this.badLibraries_ = new Vector();
            StrVector strVector = MicroscopeModel.getDeviceLibraries(cMMCore);
            int n = 0;
            while ((long)n < strVector.size()) {
                boolean bl = false;
                if (!this.isLibraryAvailable(strVector.get(n))) {
                    ReportingUtils.logMessage(strVector.get(n));
                    Device[] deviceArray = new Device[]{};
                    try {
                        deviceArray = Device.getLibraryContents(strVector.get(n), cMMCore);
                        for (int i = 0; i < deviceArray.length; ++i) {
                            ReportingUtils.logMessage("   " + deviceArray[i].getAdapterName() + ", " + deviceArray[i].getDescription());
                            if (!deviceArray[i].isSerialPort()) {
                                arrayList.add(deviceArray[i]);
                            } else {
                                deviceArray[i].setName(deviceArray[i].getAdapterName());
                                if (!arrayList2.contains(deviceArray[i])) {
                                    arrayList2.add(deviceArray[i]);
                                }
                            }
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        ReportingUtils.logError(null, "Unable to load " + strVector.get(n) + " library.");
                    }
                }
                if (!bl) {
                    this.badLibraries_.add(strVector.get(n));
                }
                ++n;
            }
            this.availableDevices_ = new Device[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                this.availableDevices_[n] = (Device)arrayList.get(n);
                if (!this.availableDevices_[n].isHub()) continue;
                arrayList3.add(this.availableDevices_[n]);
            }
            this.availableHubs_ = new Device[arrayList3.size()];
            arrayList3.toArray(this.availableHubs_);
            this.availableComPorts_ = new Device[arrayList2.size()];
            this.comPortInUse_ = new Hashtable();
            for (n = 0; n < arrayList2.size(); ++n) {
                this.availableComPorts_[n] = (Device)arrayList2.get(n);
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    public Device[] getAvailableDeviceList() {
        return this.availableDevices_;
    }

    public Device[] getAvailableHubs() {
        return this.availableHubs_;
    }

    public Device[] getAvailableDevicesCompact() {
        ArrayList<Device> arrayList = new ArrayList<Device>();
        for (int i = 0; i < this.availableDevices_.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < this.availableHubs_.length; ++j) {
                if (this.availableHubs_[j].getLibrary().compareTo(this.availableDevices_[i].getLibrary()) != 0 || this.availableDevices_[i].isHub()) continue;
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(this.availableDevices_[i]);
        }
        return arrayList.toArray(new Device[arrayList.size()]);
    }

    public Device[] getAvailableSerialPorts() {
        return this.availableComPorts_;
    }

    public String[] getBadLibraries() {
        return this.badLibraries_.toArray(new String[this.badLibraries_.size()]);
    }

    public boolean isPortInUse(int n) {
        return this.comPortInUse_.containsKey(this.availableComPorts_[n].getName());
    }

    public boolean isPortInUse(Device device) {
        return this.comPortInUse_.containsKey(device.getName());
    }

    void useSerialPort(int n, boolean bl) {
        if (bl) {
            this.comPortInUse_.put(this.availableComPorts_[n].getName(), this.availableComPorts_[n]);
        } else {
            this.comPortInUse_.remove(this.availableComPorts_[n].getName());
        }
    }

    void useSerialPort(Device device, boolean bl) {
        if (bl) {
            this.comPortInUse_.put(device.getName(), device);
        } else {
            this.comPortInUse_.remove(device.getName());
        }
    }

    public void addSetupProperty(String string, PropertyItem propertyItem) throws MMConfigFileException {
        Device device = this.findDevice(string);
        if (device == null) {
            throw new MMConfigFileException("Device " + string + " not defined.");
        }
        PropertyItem propertyItem2 = device.findSetupProperty(propertyItem.name);
        if (propertyItem2 == null) {
            device.addSetupProperty(propertyItem);
        } else {
            propertyItem2.value = propertyItem.value;
        }
    }

    public void addSetupLabel(String string, Label label) throws MMConfigFileException {
        Device device = this.findDevice(string);
        if (device != null) {
            device.addSetupLabel(label);
            this.modified_ = true;
            return;
        }
        throw new MMConfigFileException("Device " + string + " not defined.");
    }

    public void applySetupLabelsToHardware(CMMCore cMMCore) throws Exception {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device device = this.devices_.get(i);
            Label[] labelArray = device.getAllSetupLabels();
            for (int j = 0; j < labelArray.length; ++j) {
                cMMCore.defineStateLabel(device.getName(), labelArray[j].state_, labelArray[j].label_);
            }
        }
    }

    public void applySetupConfigsToHardware(CMMCore cMMCore) throws Exception {
        StrVector strVector = cMMCore.getAvailableConfigGroups();
        int n = 0;
        while ((long)n < strVector.size()) {
            cMMCore.deleteConfigGroup(strVector.get(n));
            ++n;
        }
        Object[] objectArray = this.configGroups_.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ConfigGroup configGroup = (ConfigGroup)objectArray[i];
            cMMCore.defineConfigGroup(configGroup.getName());
            ConfigPreset[] configPresetArray = configGroup.getConfigPresets();
            for (int j = 0; j < configPresetArray.length; ++j) {
                for (int k = 0; k < configPresetArray[j].getNumberOfSettings(); ++k) {
                    Setting setting = configPresetArray[j].getSetting(k);
                    cMMCore.defineConfig(configGroup.getName(), configPresetArray[j].getName(), setting.deviceName_, setting.propertyName_, setting.propertyValue_);
                }
            }
        }
    }

    public void createSetupConfigsFromHardware(CMMCore cMMCore) throws MMConfigFileException {
        this.configGroups_.clear();
        StrVector strVector = cMMCore.getAvailableConfigGroups();
        try {
            int n = 0;
            while ((long)n < strVector.size()) {
                ConfigGroup configGroup = new ConfigGroup(strVector.get(n));
                StrVector strVector2 = cMMCore.getAvailableConfigs(strVector.get(n));
                int n2 = 0;
                while ((long)n2 < strVector2.size()) {
                    Configuration configuration = cMMCore.getConfigData(strVector.get(n), strVector2.get(n2));
                    ConfigPreset configPreset = new ConfigPreset(strVector2.get(n2));
                    int n3 = 0;
                    while ((long)n3 < configuration.size()) {
                        PropertySetting propertySetting = configuration.getSetting(n3);
                        Setting setting = new Setting(propertySetting.getDeviceLabel(), propertySetting.getPropertyName(), propertySetting.getPropertyValue());
                        configPreset.addSetting(setting);
                        ++n3;
                    }
                    configGroup.addConfigPreset(configPreset);
                    ++n2;
                }
                this.configGroups_.put(strVector.get(n), configGroup);
                this.modified_ = true;
                ++n;
            }
        }
        catch (Exception exception) {
            throw new MMConfigFileException(exception);
        }
    }

    public void updateLabelsInPreset(String string, String string2, String string3) {
        Enumeration<ConfigGroup> enumeration = this.configGroups_.elements();
        while (enumeration.hasMoreElements()) {
            ConfigPreset[] configPresetArray;
            ConfigGroup configGroup = enumeration.nextElement();
            for (ConfigPreset configPreset : configPresetArray = configGroup.getConfigPresets()) {
                for (int i = 0; i < configPreset.getNumberOfSettings(); ++i) {
                    Setting setting = configPreset.getSetting(i);
                    if (!setting.propertyName_.equals("Label") || !setting.deviceName_.equals(string) || !setting.propertyValue_.equals(string2)) continue;
                    setting.propertyValue_ = string3;
                }
            }
        }
    }

    public void createResolutionsFromHardware(CMMCore cMMCore) throws MMConfigFileException {
        this.pixelSizeGroup_ = new ConfigGroup(PIXEL_SIZE_GROUP);
        try {
            StrVector strVector = cMMCore.getAvailablePixelSizeConfigs();
            int n = 0;
            while ((long)n < strVector.size()) {
                Configuration configuration = cMMCore.getPixelSizeConfigData(strVector.get(n));
                ConfigPreset configPreset = new ConfigPreset(strVector.get(n));
                configPreset.setPixelSizeUm(cMMCore.getPixelSizeUmByID(strVector.get(n)));
                int n2 = 0;
                while ((long)n2 < configuration.size()) {
                    PropertySetting propertySetting = configuration.getSetting(n2);
                    Setting setting = new Setting(propertySetting.getDeviceLabel(), propertySetting.getPropertyName(), propertySetting.getPropertyValue());
                    configPreset.addSetting(setting);
                    ++n2;
                }
                this.pixelSizeGroup_.addConfigPreset(configPreset);
                ++n;
            }
            this.modified_ = true;
        }
        catch (Exception exception) {
            throw new MMConfigFileException(exception);
        }
    }

    public void applyDelaysToHardware(CMMCore cMMCore) throws Exception {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device device = this.devices_.get(i);
            cMMCore.setDeviceDelayMs(device.getName(), device.getDelay());
        }
    }

    public boolean addConfigGroup(String string) {
        ConfigGroup configGroup = new ConfigGroup(string);
        ConfigGroup configGroup2 = this.configGroups_.get(string);
        if (configGroup2 == null) {
            this.configGroups_.put(configGroup.getName(), configGroup);
            this.modified_ = true;
            return true;
        }
        return false;
    }

    public void loadFromFile(String string) throws MMConfigFileException {
        this.reset();
        File file = new File(string);
        if (!file.exists()) {
            throw new MMConfigFileException("Configuration file does not exist.");
        }
        boolean bl = false;
        try {
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(file));
            Object object = null;
            while ((object = bufferedReader.readLine()) != null) {
                Object object2;
                String[] stringArray = ((String)object).split(",");
                if (stringArray.length == 0 || stringArray[0].startsWith("#")) continue;
                if (stringArray[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_Device()))) {
                    if (stringArray.length != 4) {
                        throw new MMConfigFileException("Invalid number of parameters (4 required):\n" + (String)object);
                    }
                    object2 = new Device(stringArray[1], stringArray[2], stringArray[3], this.getDeviceDescription(stringArray[2], stringArray[3]));
                    this.devices_.add((Device)object2);
                    continue;
                }
                if (stringArray[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_Property()))) {
                    if (stringArray.length != 4 && stringArray.length != 3) {
                        throw new MMConfigFileException("Invalid number of parameters (4 required):\n" + (String)object);
                    }
                    if (stringArray.length == 3) {
                        object2 = new String[4];
                        for (int i = 0; i < 3; ++i) {
                            object2[i] = stringArray[i];
                        }
                        object2[3] = "";
                        stringArray = object2;
                    }
                    if (stringArray[1].contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreDevice()))) {
                        if (stringArray[2].contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreInitialize()))) {
                            if (stringArray[3].contentEquals(new StringBuffer().append("0"))) {
                                bl = false;
                                continue;
                            }
                            bl = true;
                            continue;
                        }
                        object2 = new PropertyItem();
                        ((PropertyItem)object2).name = stringArray[2];
                        ((PropertyItem)object2).value = stringArray[3];
                        this.addSetupProperty(stringArray[1], (PropertyItem)object2);
                        continue;
                    }
                    object2 = new PropertyItem();
                    ((PropertyItem)object2).preInit = !bl;
                    ((PropertyItem)object2).name = stringArray[2];
                    ((PropertyItem)object2).value = stringArray[3];
                    this.addSetupProperty(stringArray[1], (PropertyItem)object2);
                    continue;
                }
                if (stringArray[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_Label()))) {
                    if (stringArray.length != 4) {
                        throw new MMConfigFileException("Invalid number of parameters (4 required):\n" + (String)object);
                    }
                    object2 = new Label(stringArray[3], Integer.parseInt(stringArray[2]));
                    this.addSetupLabel(stringArray[1], (Label)object2);
                    continue;
                }
                if (stringArray[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_ImageSynchro()))) {
                    if (stringArray.length != 2) {
                        throw new MMConfigFileException("Invalid number of parameters (2 required):\n" + (String)object);
                    }
                    this.synchroDevices_.add(stringArray[1]);
                    continue;
                }
                if (stringArray[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_ConfigGroup()))) {
                    if (stringArray.length != 6 && stringArray.length != 5) {
                        throw new MMConfigFileException("Invalid number of parameters (6 required):\n" + (String)object);
                    }
                    this.addConfigGroup(stringArray[1]);
                    object2 = this.findConfigGroup(stringArray[1]);
                    if (stringArray.length == 6) {
                        ((ConfigGroup)object2).addConfigSetting(stringArray[2], stringArray[3], stringArray[4], stringArray[5]);
                        continue;
                    }
                    ((ConfigGroup)object2).addConfigSetting(stringArray[2], stringArray[3], stringArray[4], "");
                    continue;
                }
                if (stringArray[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_ConfigPixelSize()))) {
                    if (stringArray.length != 5) {
                        throw new MMConfigFileException("Invalid number of parameters (5 required):\n" + (String)object);
                    }
                    this.pixelSizeGroup_.addConfigSetting(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
                    continue;
                }
                if (stringArray[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_PixelSize_um()))) {
                    if (stringArray.length != 3) {
                        throw new MMConfigFileException("Invalid number of parameters (3 required):\n" + (String)object);
                    }
                    object2 = this.pixelSizeGroup_.findConfigPreset(stringArray[1]);
                    if (object2 == null) continue;
                    ((ConfigPreset)object2).setPixelSizeUm(Double.parseDouble(stringArray[2]));
                    continue;
                }
                if (stringArray[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_Delay()))) {
                    if (stringArray.length != 3) {
                        throw new MMConfigFileException("Invalid number of parameters (3 required):\n" + (String)object);
                    }
                    object2 = this.findDevice(stringArray[1]);
                    if (object2 == null) continue;
                    ((Device)object2).setDelay(Double.parseDouble(stringArray[2]));
                    continue;
                }
                if (!stringArray[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_ParentID()))) continue;
                if (stringArray.length != 3) {
                    throw new MMConfigFileException("Invalid number of parameters (3 required):\n" + (String)object);
                }
                object2 = this.findDevice(stringArray[1]);
                if (object2 == null) continue;
                ((Device)object2).setParentHub(stringArray[2]);
            }
        }
        catch (IOException iOException) {
            this.reset();
            throw new MMConfigFileException(iOException);
        }
        finally {
            this.modified_ = false;
            this.fileName_ = string;
            this.addMissingProperties();
            this.addSystemConfigs();
            for (int i = 0; i < this.availableComPorts_.length; ++i) {
                Device device = this.findDevice(this.availableComPorts_[i].getName());
                if (device == null) continue;
                this.useSerialPort(device, true);
            }
        }
    }

    public String getDeviceDescription(String string, String string2) {
        Device device = this.findAvailableDevice(string, string2);
        if (device != null) {
            return device.getDescription();
        }
        return "";
    }

    private Device findAvailableDevice(String string, String string2) {
        for (int i = 0; i < this.availableDevices_.length; ++i) {
            if (this.availableDevices_[i].getLibrary().compareTo(string) != 0 || this.availableDevices_[i].getAdapterName().compareTo(string2) != 0) continue;
            return this.availableDevices_[i];
        }
        return null;
    }

    private boolean isLibraryAvailable(String string) {
        for (int i = 0; i < this.availableDevices_.length; ++i) {
            if (this.availableDevices_[i].getLibrary().compareTo(string) != 0) continue;
            return true;
        }
        return false;
    }

    private void addMissingProperties() {
        PropertyItem propertyItem;
        Device device = this.findDevice(MMCoreJ.getG_Keyword_CoreDevice());
        if (device == null) {
            device = new Device(MMCoreJ.getG_Keyword_CoreDevice(), "MMCore", "CoreDevice");
        }
        if ((propertyItem = device.findSetupProperty(MMCoreJ.getG_Keyword_CoreCamera())) == null) {
            device.addSetupProperty(new PropertyItem(MMCoreJ.getG_Keyword_CoreCamera(), ""));
        }
        if ((propertyItem = device.findSetupProperty(MMCoreJ.getG_Keyword_CoreShutter())) == null) {
            device.addSetupProperty(new PropertyItem(MMCoreJ.getG_Keyword_CoreShutter(), ""));
        }
        if ((propertyItem = device.findSetupProperty(MMCoreJ.getG_Keyword_CoreFocus())) == null) {
            device.addSetupProperty(new PropertyItem(MMCoreJ.getG_Keyword_CoreFocus(), ""));
        }
        if ((propertyItem = device.findSetupProperty(MMCoreJ.getG_Keyword_CoreAutoShutter())) == null) {
            device.addSetupProperty(new PropertyItem(MMCoreJ.getG_Keyword_CoreAutoShutter(), "1"));
        }
    }

    private void addSystemConfigs() {
        ConfigPreset configPreset;
        ConfigGroup configGroup = this.findConfigGroup(MMCoreJ.getG_CFGGroup_System());
        if (configGroup == null) {
            this.addConfigGroup(MMCoreJ.getG_CFGGroup_System());
        }
        if ((configGroup = this.findConfigGroup(MMCoreJ.getG_Keyword_Channel())) == null) {
            this.addConfigGroup(MMCoreJ.getG_Keyword_Channel());
        }
        if ((configPreset = (configGroup = this.findConfigGroup(MMCoreJ.getG_CFGGroup_System())).findConfigPreset(MMCoreJ.getG_CFGGroup_System_Startup())) == null) {
            configPreset = new ConfigPreset(MMCoreJ.getG_CFGGroup_System_Startup());
            configGroup.addConfigPreset(configPreset);
        }
    }

    public void saveToFile(String string) throws MMConfigFileException {
        try {
            Object object;
            int n;
            Object object2;
            int n2;
            Object object3;
            int n3;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("# Generated by Configurator on " + GregorianCalendar.getInstance().getTime());
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("# Reset");
            bufferedWriter.newLine();
            bufferedWriter.write("Property,Core,Initialize,0");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("# Devices");
            bufferedWriter.newLine();
            for (n3 = 0; n3 < this.availableComPorts_.length; ++n3) {
                object3 = this.availableComPorts_[n3];
                if (!this.isPortInUse((Device)object3)) continue;
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_Device() + "," + ((Device)object3).getName() + "," + ((Device)object3).getLibrary() + "," + ((Device)object3).getAdapterName());
                bufferedWriter.newLine();
            }
            for (n3 = 0; n3 < this.devices_.size(); ++n3) {
                object3 = this.devices_.get(n3);
                if (((Device)object3).isCore()) continue;
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_Device() + "," + ((Device)object3).getName() + "," + ((Device)object3).getLibrary() + "," + ((Device)object3).getAdapterName());
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.write("# Pre-init settings for devices");
            bufferedWriter.newLine();
            for (n3 = 0; n3 < this.devices_.size(); ++n3) {
                object3 = this.devices_.get(n3);
                for (n2 = 0; n2 < ((Device)object3).getNumberOfSetupProperties(); ++n2) {
                    object2 = ((Device)object3).getSetupProperty(n2);
                    if (!((PropertyItem)object2).preInit) continue;
                    bufferedWriter.write(MMCoreJ.getG_CFGCommand_Property() + "," + ((Device)object3).getName() + "," + ((PropertyItem)object2).name + "," + ((PropertyItem)object2).value);
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.newLine();
            bufferedWriter.write("# Pre-init settings for COM ports");
            bufferedWriter.newLine();
            for (n3 = 0; n3 < this.availableComPorts_.length; ++n3) {
                object3 = this.availableComPorts_[n3];
                for (n2 = 0; n2 < ((Device)object3).getNumberOfSetupProperties(); ++n2) {
                    object2 = ((Device)object3).getSetupProperty(n2);
                    if (!this.isPortInUse((Device)object3) || !((PropertyItem)object2).preInit) continue;
                    bufferedWriter.write(MMCoreJ.getG_CFGCommand_Property() + "," + ((Device)object3).getName() + "," + ((PropertyItem)object2).name + "," + ((PropertyItem)object2).value);
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.newLine();
            bufferedWriter.write("# Hub (parent) references");
            bufferedWriter.newLine();
            for (n3 = 0; n3 < this.devices_.size(); ++n3) {
                object3 = this.devices_.get(n3);
                String string2 = ((Device)object3).getParentHub();
                if (string2.length() == 0) continue;
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_ParentID() + "," + ((Device)object3).getName() + "," + string2);
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.write("# Initialize");
            bufferedWriter.newLine();
            bufferedWriter.write("Property,Core,Initialize,1");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("# Delays");
            bufferedWriter.newLine();
            for (n3 = 0; n3 < this.devices_.size(); ++n3) {
                object3 = this.devices_.get(n3);
                if (!(((Device)object3).getDelay() > 0.0)) continue;
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_Delay() + "," + ((Device)object3).getName() + "," + ((Device)object3).getDelay());
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.write("# Roles");
            bufferedWriter.newLine();
            Device device = this.findDevice(MMCoreJ.getG_Keyword_CoreDevice());
            object3 = device.findSetupProperty(MMCoreJ.getG_Keyword_CoreCamera());
            if (((PropertyItem)object3).value.length() > 0) {
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_Property() + "," + MMCoreJ.getG_Keyword_CoreDevice() + "," + MMCoreJ.getG_Keyword_CoreCamera() + "," + ((PropertyItem)object3).value);
                bufferedWriter.newLine();
            }
            object3 = device.findSetupProperty(MMCoreJ.getG_Keyword_CoreShutter());
            if (((PropertyItem)object3).value.length() > 0) {
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_Property() + "," + MMCoreJ.getG_Keyword_CoreDevice() + "," + MMCoreJ.getG_Keyword_CoreShutter() + "," + ((PropertyItem)object3).value);
                bufferedWriter.newLine();
            }
            object3 = device.findSetupProperty(MMCoreJ.getG_Keyword_CoreFocus());
            if (((PropertyItem)object3).value.length() > 0) {
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_Property() + "," + MMCoreJ.getG_Keyword_CoreDevice() + "," + MMCoreJ.getG_Keyword_CoreFocus() + "," + ((PropertyItem)object3).value);
                bufferedWriter.newLine();
            }
            object3 = device.findSetupProperty(MMCoreJ.getG_Keyword_CoreAutoShutter());
            if (((PropertyItem)object3).value.length() > 0) {
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_Property() + "," + MMCoreJ.getG_Keyword_CoreDevice() + "," + MMCoreJ.getG_Keyword_CoreAutoShutter() + "," + ((PropertyItem)object3).value);
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.write("# Camera-synchronized devices");
            bufferedWriter.newLine();
            for (n = 0; n < this.synchroDevices_.size(); ++n) {
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_ImageSynchro() + "," + this.synchroDevices_.get(n));
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.write("# Labels");
            bufferedWriter.newLine();
            for (n = 0; n < this.devices_.size(); ++n) {
                object2 = this.devices_.get(n);
                if (((Device)object2).getNumberOfSetupLabels() > 0) {
                    bufferedWriter.write("# " + ((Device)object2).getName());
                    bufferedWriter.newLine();
                }
                object = ((Device)object2).getAllSetupLabels();
                for (int i = 0; i < ((Label[])object).length; ++i) {
                    bufferedWriter.write(MMCoreJ.getG_CFGCommand_Label() + "," + ((Device)object2).getName() + "," + ((Label)object[i]).state_ + "," + ((Label)object[i]).label_);
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.newLine();
            bufferedWriter.write("# Configuration presets");
            bufferedWriter.newLine();
            Object[] objectArray = this.configGroups_.values().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                object = (ConfigGroup)objectArray[i];
                bufferedWriter.write("# Group: " + ((ConfigGroup)object).getName());
                bufferedWriter.newLine();
                ConfigPreset[] configPresetArray = ((ConfigGroup)object).getConfigPresets();
                for (int j = 0; j < configPresetArray.length; ++j) {
                    bufferedWriter.write("# Preset: " + configPresetArray[j].getName());
                    bufferedWriter.newLine();
                    for (int k = 0; k < configPresetArray[j].getNumberOfSettings(); ++k) {
                        Setting setting = configPresetArray[j].getSetting(k);
                        bufferedWriter.write(MMCoreJ.getG_CFGCommand_ConfigGroup() + "," + ((ConfigGroup)object).getName() + "," + configPresetArray[j].getName() + "," + setting.deviceName_ + "," + setting.propertyName_ + "," + setting.propertyValue_);
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.write("# PixelSize settings");
            bufferedWriter.newLine();
            ConfigPreset[] configPresetArray = this.pixelSizeGroup_.getConfigPresets();
            for (int i = 0; i < configPresetArray.length; ++i) {
                bufferedWriter.write("# Resolution preset: " + configPresetArray[i].getName());
                bufferedWriter.newLine();
                for (int j = 0; j < configPresetArray[i].getNumberOfSettings(); ++j) {
                    Setting setting = configPresetArray[i].getSetting(j);
                    bufferedWriter.write(MMCoreJ.getG_CFGCommand_ConfigPixelSize() + "," + configPresetArray[i].getName() + "," + setting.deviceName_ + "," + setting.propertyName_ + "," + setting.propertyValue_);
                    bufferedWriter.newLine();
                    bufferedWriter.write(MMCoreJ.getG_CFGGroup_PixelSizeUm() + "," + configPresetArray[i].getName() + "," + Double.toString(configPresetArray[i].getPixelSize()));
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new MMConfigFileException(iOException);
        }
        this.fileName_ = string;
        this.modified_ = false;
    }

    public void dumpSetupConf() {
        Object object;
        int n;
        Device device;
        int n2;
        ReportingUtils.logMessage("\nStep 1: load devices");
        for (n2 = 0; n2 < this.devices_.size(); ++n2) {
            device = this.devices_.get(n2);
            ReportingUtils.logMessage(device.getName() + " from library " + device.getLibrary() + ", using adapter " + device.getAdapterName());
        }
        ReportingUtils.logMessage("\nStep 2: set pre-initialization properties");
        for (n2 = 0; n2 < this.devices_.size(); ++n2) {
            device = this.devices_.get(n2);
            for (n = 0; n < device.getNumberOfSetupProperties(); ++n) {
                object = device.getSetupProperty(n);
                if (!((PropertyItem)object).preInit) continue;
                ReportingUtils.logMessage(device.getName() + ", property " + ((PropertyItem)object).name + "=" + ((PropertyItem)object).value);
            }
        }
        ReportingUtils.logMessage("\nStep 3: initialize");
        ReportingUtils.logMessage("\nStep 4: define device labels");
        for (n2 = 0; n2 < this.devices_.size(); ++n2) {
            device = this.devices_.get(n2);
            ReportingUtils.logMessage(device.getName() + " labels:");
            for (n = 0; n < device.getNumberOfSetupLabels(); ++n) {
                object = device.getSetupLabelByState(n);
                ReportingUtils.logMessage("    State " + ((Label)object).state_ + "=" + ((Label)object).label_);
            }
        }
        ReportingUtils.logMessage("\nStep 5: set initial properties");
        for (n2 = 0; n2 < this.devices_.size(); ++n2) {
            device = this.devices_.get(n2);
            for (n = 0; n < device.getNumberOfSetupProperties(); ++n) {
                object = device.getSetupProperty(n);
                if (((PropertyItem)object).preInit) continue;
                ReportingUtils.logMessage(device.getName() + ", property " + ((PropertyItem)object).name + "=" + ((PropertyItem)object).value);
            }
        }
    }

    public void dumpDeviceProperties(String string) {
        Device device = this.findDevice(string);
        if (device == null) {
            return;
        }
        for (int i = 0; i < device.getNumberOfSetupProperties(); ++i) {
            PropertyItem propertyItem = device.getSetupProperty(i);
            ReportingUtils.logMessage(device.getName() + ", property " + propertyItem.name + "=" + propertyItem.value);
            for (int j = 0; j < propertyItem.allowed.length; ++j) {
                ReportingUtils.logMessage("   " + propertyItem.allowed[j]);
            }
        }
    }

    public void dumpComPortProperties(String string) {
        Device device = this.findSerialPort(string);
        if (device == null) {
            return;
        }
        for (int i = 0; i < device.getNumberOfSetupProperties(); ++i) {
            PropertyItem propertyItem = device.getSetupProperty(i);
            ReportingUtils.logMessage(device.getName() + ", property " + propertyItem.name + "=" + propertyItem.value);
            for (int j = 0; j < propertyItem.allowed.length; ++j) {
                ReportingUtils.logMessage("   " + propertyItem.allowed[j]);
            }
        }
    }

    public void dumpComPortsSetupProps() {
        for (int i = 0; i < this.availableComPorts_.length; ++i) {
            this.dumpDeviceProperties(this.availableComPorts_[i].getName());
            this.dumpComPortProperties(this.availableComPorts_[i].getName());
        }
    }

    public void reset() {
        this.devices_.clear();
        this.configGroups_.clear();
        this.synchroDevices_.clear();
        this.pixelSizeGroup_.clear();
        Device device = new Device(MMCoreJ.getG_Keyword_CoreDevice(), "Default", "MMCore", "Core controller");
        this.devices_.add(device);
        this.addMissingProperties();
        this.addSystemConfigs();
        this.modified_ = true;
    }

    public Device[] getDevices() {
        Device[] deviceArray = new Device[this.devices_.size()];
        for (int i = 0; i < deviceArray.length; ++i) {
            deviceArray[i] = this.devices_.get(i);
        }
        return deviceArray;
    }

    public Device[] getPeripheralDevices() {
        int n = 0;
        Device[] deviceArray = new Device[n];
        return deviceArray;
    }

    public Device[] getChildDevices(Device device) {
        ArrayList<Device> arrayList = new ArrayList<Device>();
        for (int i = 0; i < this.devices_.size(); ++i) {
            if (!this.devices_.get(i).getParentHub().contentEquals(device.getName())) continue;
            arrayList.add(this.devices_.get(i));
        }
        return arrayList.toArray(new Device[arrayList.size()]);
    }

    public void removePeripherals(String string, CMMCore cMMCore) {
        Device device = this.findDevice(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (device != null) {
            int n;
            for (n = 0; n < this.devices_.size(); ++n) {
                if (this.devices_.get(n).getParentHub().compareTo(device.getName()) != 0) continue;
                arrayList.add(this.devices_.get(n).getName());
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this.removeDevice((String)arrayList.get(n));
                try {
                    cMMCore.unloadDevice((String)arrayList.get(n));
                    continue;
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                }
            }
        }
    }

    public void removeDevice(String string) {
        Device device = this.findDevice(string);
        if (device != null) {
            String string2 = device.getPort();
            this.devices_.remove(device);
            if (string2.length() != 0) {
                boolean bl = false;
                for (Device device2 : this.devices_) {
                    String string3 = device2.getPort();
                    if (!string2.equals(string3)) continue;
                    bl = true;
                }
                if (!bl) {
                    this.comPortInUse_.remove(string2);
                }
            }
            this.modified_ = true;
        }
    }

    Device findDevice(String string) {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device device = this.devices_.get(i);
            if (!device.getName().contentEquals(new StringBuffer().append(string))) continue;
            return device;
        }
        return null;
    }

    boolean hasAdapterName(String string, String string2) {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device device = this.devices_.get(i);
            if (!device.getAdapterName().contentEquals(string2) || !device.getLibrary().contentEquals(string)) continue;
            return true;
        }
        return false;
    }

    boolean hasAdapterName(String string, String string2, String string3) {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device device = this.devices_.get(i);
            if (!device.getAdapterName().contentEquals(string3) || !device.getLibrary().contentEquals(string) || !device.getParentHub().contentEquals(string2)) continue;
            return true;
        }
        return false;
    }

    Device findSerialPort(String string) {
        for (int i = 0; i < this.availableComPorts_.length; ++i) {
            if (!this.availableComPorts_[i].getName().contentEquals(new StringBuffer().append(string))) continue;
            return this.availableComPorts_[i];
        }
        return null;
    }

    ConfigGroup findConfigGroup(String string) {
        return this.configGroups_.get(string);
    }

    String[] getConfigGroupList() {
        String[] stringArray = new String[this.configGroups_.size()];
        Object[] objectArray = this.configGroups_.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = ((ConfigGroup)objectArray[i]).getName();
        }
        return stringArray;
    }

    String[] getSynchroList() {
        String[] stringArray = new String[this.synchroDevices_.size()];
        for (int i = 0; i < this.synchroDevices_.size(); ++i) {
            stringArray[i] = this.synchroDevices_.get(i);
        }
        return stringArray;
    }

    public void addSynchroDevice(String string) {
        this.synchroDevices_.add(string);
        this.modified_ = true;
    }

    public void clearSynchroDevices() {
        this.synchroDevices_.clear();
        this.modified_ = true;
    }

    public void addDevice(Device device) throws MMConfigFileException {
        if (device.getName().length() == 0) {
            throw new MMConfigFileException("Empty device names are not allowed, please choose a different name.");
        }
        if (this.findDevice(device.getName()) != null) {
            throw new MMConfigFileException(device.getName() + " already defined, please choose a different name.");
        }
        this.devices_.add(device);
        this.modified_ = true;
    }

    public void changeDeviceName(String string, String string2) throws MMConfigFileException {
        Device device = this.findDevice(string);
        if (device == null) {
            throw new MMConfigFileException("Device " + string + " is not defined");
        }
        device.setName(string2);
        this.modified_ = true;
    }

    public String getDeviceSetupProperty(String string, String string2) throws MMConfigFileException {
        Device device = this.findDevice(string);
        if (device == null) {
            return null;
        }
        return device.getSetupPropertyValue(string2);
    }

    public void setDeviceSetupProperty(String string, String string2, String string3) throws MMConfigFileException {
        Device device = this.findDevice(string);
        if (device == null) {
            throw new MMConfigFileException("Device " + string + " is not defined");
        }
        device.setSetupPropertyValue(string2, string3);
        this.modified_ = true;
    }

    public void removeGroup(String string) {
        this.configGroups_.remove(string);
        this.modified_ = true;
    }

    public void renameGroup(ConfigGroup configGroup, String string) {
        this.configGroups_.remove(configGroup.getName());
        configGroup.setName(string);
        this.configGroups_.put(string, configGroup);
        this.modified_ = true;
    }

    public void removeDuplicateComPorts() {
        Device device;
        int n;
        for (n = 0; n < this.availableComPorts_.length; ++n) {
            device = this.findDevice(this.availableComPorts_[n].getName());
            if (device == null) continue;
            this.availableComPorts_[n] = device;
            this.removeDevice(device.getName());
        }
        for (n = 0; n < this.devices_.size(); ++n) {
            device = this.devices_.get(n);
            if (!device.isSerialPort()) continue;
            this.removeDevice(device.getName());
        }
    }

    public void removeInvalidConfigurations() {
        Object[] objectArray = this.configGroups_.values().toArray();
        block0: for (int i = 0; i < objectArray.length; ++i) {
            ConfigGroup configGroup = (ConfigGroup)objectArray[i];
            ConfigPreset[] configPresetArray = configGroup.getConfigPresets();
            for (int j = 0; j < configPresetArray.length; ++j) {
                for (int k = 0; k < configPresetArray[j].getNumberOfSettings(); ++k) {
                    Setting setting = configPresetArray[j].getSetting(k);
                    if (null != this.findDevice(setting.deviceName_)) continue;
                    this.removeGroup(configGroup.name_);
                    continue block0;
                }
            }
        }
    }

    public boolean getSendConfiguration() {
        return this.sendConfiguration_;
    }

    public void setSendConfiguration(boolean bl) {
        this.sendConfiguration_ = bl;
    }

    public void AddSelectedPeripherals(CMMCore cMMCore, Vector<Device> vector, Vector<String> vector2, Vector<Boolean> vector3) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector3.get(i).booleanValue()) {
                Device device = new Device(vector.get(i).getName(), vector.get(i).getLibrary(), vector.get(i).getAdapterName(), vector.get(i).getDescription());
                device.setParentHub(vector2.get(i));
                try {
                    this.addDevice(device);
                    cMMCore.loadDevice(device.getName(), device.getLibrary(), device.getAdapterName());
                    for (int j = 0; j < device.getNumberOfSetupProperties(); ++j) {
                        PropertyItem propertyItem = device.getSetupProperty(j);
                        cMMCore.setProperty(device.getName(), propertyItem.name, propertyItem.value);
                    }
                    continue;
                }
                catch (Exception exception) {
                    ReportingUtils.showError(exception);
                    continue;
                }
            }
            try {
                cMMCore.unloadDevice(vector.get(i).getName());
                continue;
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception.getMessage());
            }
        }
    }

    public boolean loadModel(CMMCore cMMCore) {
        boolean bl = true;
        try {
            int n;
            StrVector strVector = cMMCore.getLoadedDevices();
            Device[] deviceArray = this.getAvailableSerialPorts();
            for (int i = 0; i < deviceArray.length; ++i) {
                cMMCore.loadDevice(deviceArray[i].getName(), deviceArray[i].getLibrary(), deviceArray[i].getAdapterName());
            }
            Device[] deviceArray2 = this.getDevices();
            for (n = 0; n < deviceArray2.length; ++n) {
                if (deviceArray2[n].isCore()) continue;
                cMMCore.loadDevice(deviceArray2[n].getName(), deviceArray2[n].getLibrary(), deviceArray2[n].getAdapterName());
                cMMCore.setParentLabel(deviceArray2[n].getName(), deviceArray2[n].getParentHub());
            }
            for (n = 0; n < deviceArray2.length; ++n) {
                for (int i = 0; i < deviceArray2[n].getNumberOfProperties(); ++i) {
                    PropertyItem propertyItem = deviceArray2[n].getProperty(i);
                    for (int j = 0; j < deviceArray.length; ++j) {
                        if (!propertyItem.value.contentEquals(deviceArray[j].getName())) continue;
                        this.comPortInUse_.put(deviceArray[j].getName(), deviceArray[j]);
                    }
                }
            }
            this.loadDeviceDataFromHardware(cMMCore);
            this.removeDuplicateComPorts();
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            try {
                cMMCore.unloadAllDevices();
            }
            catch (Exception exception2) {
                ReportingUtils.logError(exception.getMessage());
            }
            bl = false;
        }
        return bl;
    }

    public void initializeModel(CMMCore cMMCore) {
        for (String object : this.comPortInUse_.keySet()) {
            try {
                Device exception = this.comPortInUse_.get(object);
                for (int i = 0; i < exception.getNumberOfSetupProperties(); ++i) {
                    PropertyItem propertyItem = exception.getSetupProperty(i);
                    if (!propertyItem.preInit) continue;
                    cMMCore.setProperty(exception.getName(), propertyItem.name, propertyItem.value);
                }
                cMMCore.initializeDevice(exception.getName());
                exception.loadDataFromHardware(cMMCore);
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
            }
        }
        for (Device device : this.devices_) {
            for (int i = 0; i < device.getNumberOfSetupProperties(); ++i) {
                PropertyItem propertyItem = device.getSetupProperty(i);
                if (!propertyItem.preInit) continue;
                try {
                    cMMCore.setProperty(device.getName(), propertyItem.name, propertyItem.value);
                    continue;
                }
                catch (Exception exception) {
                    ReportingUtils.showError(exception);
                }
            }
        }
        for (Device device : this.devices_) {
            if (!device.isHub() || device.isInitialized()) continue;
            try {
                cMMCore.initializeDevice(device.getName());
                device.loadDataFromHardware(cMMCore);
                device.setInitialized(true);
                device.discoverPeripherals(cMMCore);
            }
            catch (Exception exception) {
                int n = JOptionPane.showConfirmDialog(null, exception.getMessage() + "\nRemove device " + device.getName() + " from the list?", "Initialization Error", 0);
                if (n != 0) continue;
                this.removePeripherals(device.getName(), cMMCore);
                this.removeDevice(device.getName());
                try {
                    cMMCore.unloadDevice(device.getName());
                }
                catch (Exception exception2) {
                    ReportingUtils.showError(exception2);
                }
            }
        }
        for (Device device : this.devices_) {
            if (device.isInitialized() || device.isCore()) continue;
            try {
                String string = device.getParentHub();
                if (string.length() != 0) {
                    cMMCore.setParentLabel(device.getName(), string);
                }
                cMMCore.initializeDevice(device.getName());
                device.loadDataFromHardware(cMMCore);
                device.setInitialized(true);
            }
            catch (Exception exception) {
                int n = JOptionPane.showConfirmDialog(null, exception.getMessage() + "\nRemove device " + device.getName() + " from the list?", "Initialization Error", 0);
                if (n != 0) continue;
                this.removePeripherals(device.getName(), cMMCore);
                this.removeDevice(device.getName());
                try {
                    cMMCore.unloadDevice(device.getName());
                }
                catch (Exception exception3) {
                    ReportingUtils.showError(exception3);
                }
            }
        }
    }
}

