/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.PagePanel;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.ReportingUtils;

public class FinishPage
extends PagePanel {
    private static final long serialVersionUID = 1L;
    private JButton browseButton_;
    private JTextField fileNameField_;
    private boolean overwrite_ = false;
    JCheckBox sendCheck_;

    public FinishPage(Preferences preferences) {
        this.title_ = "Save configuration and exit";
        this.setHelpFileName("conf_finish_page.html");
        this.prefs_ = preferences;
        this.setLayout(null);
        JLabel jLabel = new JLabel();
        jLabel.setText("Configuration file:");
        jLabel.setBounds(14, 11, 123, 21);
        this.add(jLabel);
        this.fileNameField_ = new JTextField();
        this.fileNameField_.setBounds(12, 30, 429, 24);
        this.add(this.fileNameField_);
        this.browseButton_ = new JButton();
        this.browseButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FinishPage.this.browseConfigurationFile();
            }
        });
        this.browseButton_.setText("Browse...");
        this.browseButton_.setBounds(450, 31, 100, 23);
        this.add(this.browseButton_);
        this.sendCheck_ = new JCheckBox();
        this.sendCheck_.setBounds(10, 100, 360, 33);
        this.sendCheck_.setFont(new Font("", 0, 12));
        this.sendCheck_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FinishPage.this.model_.setSendConfiguration(FinishPage.this.sendCheck_.isSelected());
            }
        });
        this.sendCheck_.setText("Send configuration to Micro-manager.org");
        this.add(this.sendCheck_);
        JLabel jLabel2 = new JLabel();
        jLabel2.setAutoscrolls(true);
        jLabel2.setText("Providing the configuration data will assist securing further project funding.");
        jLabel2.setBounds(14, 127, 500, 21);
        jLabel2.setFont(this.sendCheck_.getFont());
        this.add(jLabel2);
    }

    public boolean enterPage(boolean bl) {
        this.sendCheck_.setSelected(this.model_.getSendConfiguration());
        this.fileNameField_.setText(this.model_.getFileName());
        return true;
    }

    public boolean exitPage(boolean bl) {
        if (bl) {
            this.saveConfiguration();
        }
        return true;
    }

    public void refresh() {
    }

    public void loadSettings() {
    }

    public void saveSettings() {
    }

    private void browseConfigurationFile() {
        String[] stringArray = new String[]{".cfg"};
        File file = FileDialogs.save(this.parent_, "Select a configuration file name", MMStudioMainFrame.MM_CONFIG_FILE);
        if (file != null) {
            this.setFilePath(file);
            this.overwrite_ = true;
        }
    }

    private void setFilePath(File file) {
        String string = file.getAbsolutePath();
        if (!string.endsWith(".cfg")) {
            string = string + ".cfg";
        }
        this.fileNameField_.setText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveConfiguration() {
        Cursor cursor;
        Container container;
        block9: {
            block8: {
                Serializable serializable;
                container = this.getTopLevelAncestor();
                cursor = null;
                if (null != container) {
                    cursor = container.getCursor();
                    serializable = new Cursor(3);
                    container.setCursor((Cursor)serializable);
                }
                try {
                    try {
                        int n;
                        this.core_.unloadAllDevices();
                        GUIUtils.preventDisplayAdapterChangeExceptions();
                        serializable = new File(this.fileNameField_.getText());
                        if (((File)serializable).exists() && !this.overwrite_ && (n = JOptionPane.showConfirmDialog(this, "Overwrite " + ((File)serializable).getName() + "?", "File Save", 0)) == 1) {
                            ReportingUtils.logMessage("All changes are going to be lost!");
                            Object var6_7 = null;
                            if (null == container) return;
                            if (null == cursor) return;
                            break block8;
                        }
                        this.setFilePath((File)serializable);
                        this.model_.removeInvalidConfigurations();
                        this.model_.saveToFile(this.fileNameField_.getText());
                        break block9;
                    }
                    catch (MMConfigFileException mMConfigFileException) {
                        ReportingUtils.showError(mMConfigFileException);
                        Object var6_9 = null;
                        if (null == container) return;
                        if (null == cursor) return;
                        container.setCursor(cursor);
                        return;
                    }
                    catch (Exception exception) {
                        ReportingUtils.showError(exception);
                        Object var6_10 = null;
                        if (null == container) return;
                        if (null == cursor) return;
                        container.setCursor(cursor);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    if (null == container) throw throwable;
                    if (null == cursor) throw throwable;
                    container.setCursor(cursor);
                    throw throwable;
                }
            }
            container.setCursor(cursor);
            return;
        }
        Object var6_8 = null;
        if (null == container) return;
        if (null == cursor) return;
        container.setCursor(cursor);
    }
}

