/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import ij.plugin.BrowserLauncher;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import mmcorej.CMMCore;
import mmcorej.MMCoreJ;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.DeviceSetupDlg;
import org.micromanager.conf2.DeviceTreeNode;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.PagePanel;
import org.micromanager.conf2.PeripheralSetupDlg;
import org.micromanager.utils.ReportingUtils;

public class DevicesPage
extends PagePanel
implements ListSelectionListener,
MouseListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private JTable deviceTable_;
    private JScrollPane installedScrollPane_;
    private static final String HELP_FILE_NAME = "conf_devices_page.html";
    private JButton editButton;
    private JButton removeButton;
    private JButton peripheralsButton;
    private boolean listByLib_;
    private TreeWContextMenu theTree_;
    private JScrollPane availableScrollPane_;
    final String documentationURLroot_;
    String libraryDocumentationName_;
    private JComboBox hubsCombo_;
    private JComboBox byLibCombo_;

    public DevicesPage(Preferences preferences) {
        this.title_ = "Add or remove devices";
        this.helpText_ = "The list of selected devices is displayed above. You can add or remove devices to/from this list.\nThe first column shows the device's assigned name for this particular configuration. In subsequent steps devices will be referred to by their assigned names.\n\nYou can edit device names by double-clicking in the first column. Device name must be unique and should not contain any special characters.";
        this.listByLib_ = true;
        this.setLayout(null);
        this.prefs_ = preferences;
        this.setHelpFileName(HELP_FILE_NAME);
        this.documentationURLroot_ = "https://valelab.ucsf.edu/~MM/MMwiki/index.php/";
        this.installedScrollPane_ = new JScrollPane();
        this.installedScrollPane_.setBounds(10, 21, 431, 241);
        this.add(this.installedScrollPane_);
        this.deviceTable_ = new JTable();
        this.deviceTable_.setSelectionMode(0);
        this.installedScrollPane_.setViewportView(this.deviceTable_);
        this.deviceTable_.getSelectionModel().addListSelectionListener(this);
        this.deviceTable_.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DevicesPage.this.editDevice();
                }
            }
        });
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DevicesPage.this.addDevice();
            }
        });
        jButton.setText("Add...");
        jButton.setBounds(451, 291, 99, 23);
        this.add(jButton);
        this.removeButton = new JButton();
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DevicesPage.this.removeDevice();
            }
        });
        this.removeButton.setText("Remove");
        this.removeButton.setBounds(451, 72, 99, 23);
        this.add(this.removeButton);
        this.removeButton.setEnabled(false);
        this.editButton = new JButton("Edit...");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DevicesPage.this.editDevice();
            }
        });
        this.editButton.setBounds(451, 21, 99, 23);
        this.add(this.editButton);
        this.editButton.setEnabled(false);
        this.peripheralsButton = new JButton("Peripherals...");
        this.peripheralsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DevicesPage.this.editPeripherals();
            }
        });
        this.peripheralsButton.setEnabled(false);
        this.peripheralsButton.setBounds(451, 46, 99, 23);
        this.add(this.peripheralsButton);
        JLabel jLabel = new JLabel("Installed Devices:");
        jLabel.setFont(new Font("Tahoma", 1, 11));
        jLabel.setBounds(10, 0, 431, 14);
        this.add(jLabel);
        JLabel jLabel2 = new JLabel("Available Devices:");
        jLabel2.setFont(new Font("Tahoma", 1, 11));
        jLabel2.setBounds(10, 273, 128, 14);
        this.add(jLabel2);
        this.availableScrollPane_ = new JScrollPane(null);
        this.availableScrollPane_.setBounds(10, 299, 431, 250);
        this.add(this.availableScrollPane_);
        JButton jButton2 = new JButton("Help");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DevicesPage.this.displayDocumentation();
            }
        });
        jButton2.setBounds(451, 319, 99, 23);
        this.add(jButton2);
        this.byLibCombo_ = new JComboBox();
        this.byLibCombo_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DevicesPage.this.byLibCombo_.getSelectedIndex() == 0) {
                    DevicesPage.this.listByLib_ = true;
                } else {
                    DevicesPage.this.listByLib_ = false;
                    DevicesPage.this.hubsCombo_.setSelectedIndex(1);
                }
                DevicesPage.this.buildTree();
            }
        });
        this.byLibCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"list by vendor", "list by type"}));
        this.byLibCombo_.setBounds(146, 270, 146, 20);
        this.add(this.byLibCombo_);
        this.hubsCombo_ = new JComboBox();
        this.hubsCombo_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DevicesPage.this.buildTree();
            }
        });
        this.hubsCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"compact view", "show all"}));
        this.hubsCombo_.setBounds(302, 270, 139, 20);
        this.add(this.hubsCombo_);
    }

    protected void editPeripherals() {
        Object object;
        int n = this.deviceTable_.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = (String)this.deviceTable_.getValueAt(n, 0);
        Device device = this.model_.findDevice(string);
        String[] stringArray = device.getPeripherals();
        Vector<Device> vector = new Vector<Device>();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (this.model_.hasAdapterName(device.getLibrary(), device.getName(), stringArray[i])) continue;
                object = this.model_.getDeviceDescription(device.getLibrary(), stringArray[i]);
                Device device2 = new Device(stringArray[i], device.getLibrary(), stringArray[i], (String)object);
                vector.add(device2);
                continue;
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception.getMessage());
            }
        }
        if (vector.size() > 0) {
            PeripheralSetupDlg peripheralSetupDlg = new PeripheralSetupDlg(this.model_, this.core_, device.getName(), vector);
            peripheralSetupDlg.setVisible(true);
            object = peripheralSetupDlg.getSelectedPeripherals();
            for (int i = 0; i < ((Device[])object).length; ++i) {
                try {
                    this.core_.loadDevice(object[i].getName(), object[i].getLibrary(), object[i].getAdapterName());
                    object[i].setParentHub(device.getName());
                    this.core_.setParentLabel(object[i].getName(), device.getName());
                    object[i].loadDataFromHardware(this.core_);
                    this.model_.addDevice(object[i]);
                    String[] stringArray2 = object[i].getPreInitProperties();
                    if (stringArray2.length > 0) {
                        DeviceSetupDlg deviceSetupDlg = new DeviceSetupDlg(this.model_, this.core_, object[i]);
                        deviceSetupDlg.setVisible(true);
                        if (object[i].isInitialized()) continue;
                        this.core_.unloadDevice(object[i].getName());
                        this.model_.removeDevice(object[i].getName());
                        continue;
                    }
                    this.core_.initializeDevice(object[i].getName());
                    object[i].setInitialized(true);
                    continue;
                }
                catch (MMConfigFileException mMConfigFileException) {
                    JOptionPane.showMessageDialog(this, mMConfigFileException.getMessage());
                    continue;
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, exception.getMessage());
                }
            }
            this.rebuildDevicesTable();
        } else {
            this.handleError("There are no available peripheral devices.");
        }
    }

    private void editDevice() {
        int n;
        int n2 = this.deviceTable_.getSelectedRow();
        if (n2 < 0) {
            return;
        }
        String string = (String)this.deviceTable_.getValueAt(n2, 0);
        Device device = this.model_.findDevice(string);
        try {
            device.loadDataFromHardware(this.core_);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        DeviceSetupDlg deviceSetupDlg = new DeviceSetupDlg(this.model_, this.core_, device);
        deviceSetupDlg.setVisible(true);
        this.model_.setModified(true);
        if (!device.isInitialized() && (n = JOptionPane.showConfirmDialog(this, "Device setup did not work out. Remove from the list?", "Device failed", 0)) == 0) {
            this.model_.removeDevice(device.getName());
            try {
                this.core_.unloadDevice(device.getName());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage());
            }
        }
        this.rebuildDevicesTable();
    }

    protected void removeDevice() {
        int n = this.deviceTable_.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = (String)this.deviceTable_.getValueAt(n, 0);
        if (string.contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreDevice()))) {
            this.handleError(MMCoreJ.getG_Keyword_CoreDevice() + " device can't be removed!");
            return;
        }
        this.model_.removePeripherals(string, this.core_);
        this.model_.removeDevice(string);
        try {
            this.core_.unloadDevice(string);
        }
        catch (Exception exception) {
            this.handleError(exception.getMessage());
        }
        this.rebuildDevicesTable();
    }

    public void rebuildDevicesTable() {
        DeviceTable_TableModel deviceTable_TableModel;
        TableModel tableModel = this.deviceTable_.getModel();
        if (tableModel instanceof DeviceTable_TableModel) {
            deviceTable_TableModel = (DeviceTable_TableModel)this.deviceTable_.getModel();
            deviceTable_TableModel.refresh();
        } else {
            deviceTable_TableModel = new DeviceTable_TableModel(this.model_);
            this.deviceTable_.setModel(deviceTable_TableModel);
        }
        deviceTable_TableModel.fireTableStructureChanged();
        deviceTable_TableModel.fireTableDataChanged();
    }

    public void refresh() {
        this.rebuildDevicesTable();
    }

    public boolean enterPage(boolean bl) {
        try {
            CMMCore.getDeviceLibraries();
            this.model_.removeDuplicateComPorts();
            this.rebuildDevicesTable();
            if (!bl) {
                this.model_.loadModel(this.core_);
                Cursor cursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.model_.initializeModel(this.core_);
                this.setCursor(cursor);
            }
            this.buildTree();
            return true;
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            this.setCursor(Cursor.getDefaultCursor());
            return false;
        }
    }

    public boolean exitPage(boolean bl) {
        Device[] deviceArray;
        for (Device device : deviceArray = this.model_.getDevices()) {
            if (!device.isCore() && !device.isInitialized()) {
                JOptionPane.showMessageDialog(this, "Unable to continue: at least one device failed.\nTo proceed to next step, either remove failed device(s) from the list,\nor edit settings until the status reads OK.\nTo avoid making any changes exit the wizard without saving the configuration.");
                return !bl;
            }
            try {
                if (device.getParentHub().length() != 0) continue;
                String string = this.core_.getParentLabel(device.getName());
                device.setParentHub(string);
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }
        return true;
    }

    public void loadSettings() {
    }

    public void saveSettings() {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.deviceTable_.getSelectedRow();
        if (n < 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            return;
        }
        String string = (String)this.deviceTable_.getValueAt(n, 0);
        Device device = this.model_.findDevice(string);
        if (device == null) {
            ReportingUtils.logError("Internal error in PeripheralSetupDlg: device not found");
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.peripheralsButton.setEnabled(false);
            return;
        }
        this.peripheralsButton.setEnabled(device.isHub() && device.getPeripherals().length > 0);
        this.editButton.setEnabled(!device.isCore());
        this.removeButton.setEnabled(!device.isCore());
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DeviceTreeNode deviceTreeNode;
        Object object;
        int[] nArray = this.theTree_.getSelectionRows();
        if (null != nArray && 0 < nArray.length && 0 < nArray[0] && (object = (deviceTreeNode = (DeviceTreeNode)this.theTree_.getLastSelectedPathComponent()).getUserObject()) != null) {
            this.libraryDocumentationName_ = object.getClass().isArray() ? ((Object[])object)[0].toString() : object.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDevice() {
        int[] nArray = this.theTree_.getSelectionRows();
        if (nArray == null) {
            return false;
        }
        if (0 < nArray.length && 0 < nArray[0]) {
            Device device;
            DeviceTreeNode deviceTreeNode = (DeviceTreeNode)this.theTree_.getLastSelectedPathComponent();
            Object[] objectArray = deviceTreeNode.getUserDataArray();
            if (null == objectArray && 1 == deviceTreeNode.getLeafCount() && null == (objectArray = (deviceTreeNode = (DeviceTreeNode)deviceTreeNode.getChildAt(0)).getUserDataArray())) {
                return false;
            }
            if (objectArray == null) {
                JOptionPane.showMessageDialog(this, "Multiple devices available in this node!\nPlease expand the node and select a specific device to add.");
                return false;
            }
            String string = objectArray[1].toString();
            String string2 = objectArray[0].toString();
            String string3 = objectArray[2].toString();
            String string4 = new String(string);
            Device device2 = this.model_.findDevice(string4);
            int n = 0;
            while (device2 != null) {
                string4 = new String(string + "-" + ++n);
                device2 = this.model_.findDevice(string4);
            }
            try {
                this.core_.loadDevice(string4, string2, string);
                device = new Device(string4, string2, string, string3);
                device.loadDataFromHardware(this.core_);
                this.model_.addDevice(device);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage());
                return false;
            }
            DeviceSetupDlg deviceSetupDlg = new DeviceSetupDlg(this.model_, this.core_, device);
            deviceSetupDlg.setVisible(true);
            if (!device.isInitialized()) {
                this.model_.removeDevice(device.getName());
                try {
                    this.core_.unloadDevice(device.getName());
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, exception.getMessage());
                }
                return false;
            }
            this.refresh();
            if (device.isHub() && !device.getName().equals("Core")) {
                Object object;
                String[] stringArray = device.getPeripherals();
                Vector<Device> vector = new Vector<Device>();
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        if (this.model_.hasAdapterName(device.getLibrary(), device.getName(), stringArray[i])) continue;
                        object = this.model_.getDeviceDescription(device.getLibrary(), stringArray[i]);
                        Device device3 = new Device(stringArray[i], device.getLibrary(), stringArray[i], (String)object);
                        vector.add(device3);
                        continue;
                    }
                    catch (Exception exception) {
                        ReportingUtils.logError(exception.getMessage());
                    }
                }
                if (vector.size() > 0) {
                    PeripheralSetupDlg peripheralSetupDlg = new PeripheralSetupDlg(this.model_, this.core_, device.getName(), vector);
                    peripheralSetupDlg.setVisible(true);
                    object = peripheralSetupDlg.getSelectedPeripherals();
                    for (int i = 0; i < ((Device[])object).length; ++i) {
                        Object var20_26;
                        try {
                            block23: {
                                try {
                                    this.core_.loadDevice(object[i].getName(), object[i].getLibrary(), object[i].getAdapterName());
                                    object[i].setParentHub(device.getName());
                                    this.core_.setParentLabel(object[i].getName(), device.getName());
                                    this.model_.addDevice(object[i]);
                                    object[i].loadDataFromHardware(this.core_);
                                    String[] stringArray2 = object[i].getPreInitProperties();
                                    if (stringArray2.length > 0) {
                                        DeviceSetupDlg deviceSetupDlg2 = new DeviceSetupDlg(this.model_, this.core_, object[i]);
                                        deviceSetupDlg2.setVisible(true);
                                        if (!object[i].isInitialized()) {
                                            this.core_.unloadDevice(object[i].getName());
                                            this.model_.removeDevice(object[i].getName());
                                        }
                                        break block23;
                                    }
                                    this.core_.initializeDevice(object[i].getName());
                                    object[i].setInitialized(true);
                                }
                                catch (MMConfigFileException mMConfigFileException) {
                                    JOptionPane.showMessageDialog(this, mMConfigFileException.getMessage());
                                    var20_26 = null;
                                    this.refresh();
                                    continue;
                                }
                                catch (Exception exception) {
                                    JOptionPane.showMessageDialog(this, exception.getMessage());
                                    var20_26 = null;
                                    this.refresh();
                                    continue;
                                }
                            }
                            var20_26 = null;
                            this.refresh();
                            continue;
                        }
                        catch (Throwable throwable) {
                            var20_26 = null;
                            this.refresh();
                            throw throwable;
                        }
                    }
                }
            }
        }
        return true;
    }

    private void buildTree() {
        if (this.listByLib_) {
            this.buildTreeByLib(this.model_);
        } else {
            this.buildTreeByType(this.model_);
        }
        this.availableScrollPane_.setViewportView(this.theTree_);
    }

    private void buildTreeByType(MicroscopeModel microscopeModel) {
        Object[] objectArray;
        Cloneable cloneable;
        Device[] deviceArray = null;
        deviceArray = this.hubsCombo_.getSelectedIndex() == 1 ? microscopeModel.getAvailableDeviceList() : microscopeModel.getAvailableDevicesCompact();
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < deviceArray.length; ++i) {
            if (hashtable.containsKey(deviceArray[i].getTypeAsString())) {
                ((Vector)hashtable.get(deviceArray[i].getTypeAsString())).add(deviceArray[i]);
                continue;
            }
            cloneable = new Vector<Device>();
            ((Vector)cloneable).add(deviceArray[i]);
            hashtable.put(deviceArray[i].getTypeAsString(), cloneable);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Devices supported by \u00b5Manager");
        cloneable = null;
        for (Object object : objectArray = hashtable.keySet().toArray()) {
            cloneable = new DeviceTreeNode((String)object, false);
            defaultMutableTreeNode.add((MutableTreeNode)((Object)cloneable));
            Vector vector = (Vector)hashtable.get(object);
            for (int i = 0; i < vector.size(); ++i) {
                Object[] objectArray2 = new Object[]{((Device)vector.get(i)).getLibrary(), ((Device)vector.get(i)).getAdapterName(), ((Device)vector.get(i)).getDescription(), new Boolean(((Device)vector.get(i)).isHub())};
                DeviceTreeNode deviceTreeNode = new DeviceTreeNode("", false);
                deviceTreeNode.setUserObject(objectArray2);
                ((DefaultMutableTreeNode)cloneable).add(deviceTreeNode);
            }
        }
        this.theTree_ = new TreeWContextMenu(defaultMutableTreeNode, this);
        this.theTree_.addTreeSelectionListener(this);
        TreeMouseListener treeMouseListener = new TreeMouseListener();
        this.theTree_.addMouseListener(treeMouseListener);
        this.theTree_.setRootVisible(false);
        this.theTree_.setShowsRootHandles(true);
    }

    private void buildTreeByLib(MicroscopeModel microscopeModel) {
        String[] stringArray;
        Device[] deviceArray = null;
        deviceArray = this.hubsCombo_.getSelectedIndex() == 1 ? microscopeModel.getAvailableDeviceList() : microscopeModel.getAvailableDevicesCompact();
        String string = "";
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Devices supported by \u00b5Manager");
        DeviceTreeNode deviceTreeNode = null;
        for (int i = 0; i < deviceArray.length; ++i) {
            if (0 != string.compareTo(deviceArray[i].getLibrary())) {
                deviceTreeNode = new DeviceTreeNode(deviceArray[i].getLibrary(), true);
                defaultMutableTreeNode.add(deviceTreeNode);
                string = deviceArray[i].getLibrary();
            }
            Object[] object = new Object[]{deviceArray[i].getLibrary(), deviceArray[i].getAdapterName(), deviceArray[i].getDescription(), new Boolean(deviceArray[i].isHub())};
            DeviceTreeNode deviceTreeNode2 = new DeviceTreeNode("", true);
            deviceTreeNode2.setUserObject(object);
            deviceTreeNode.add(deviceTreeNode2);
        }
        for (String string2 : stringArray = microscopeModel.getBadLibraries()) {
            DeviceTreeNode deviceTreeNode3 = new DeviceTreeNode(string2 + " (unavailable)", true);
            defaultMutableTreeNode.add(deviceTreeNode3);
        }
        this.theTree_ = new TreeWContextMenu(defaultMutableTreeNode, this);
        this.theTree_.addTreeSelectionListener(this);
        TreeMouseListener treeMouseListener = new TreeMouseListener();
        this.theTree_.addMouseListener(treeMouseListener);
        this.theTree_.setRootVisible(false);
        this.theTree_.setShowsRootHandles(true);
    }

    private void displayDocumentation() {
        try {
            BrowserLauncher.openURL((String)(this.documentationURLroot_ + this.libraryDocumentationName_));
        }
        catch (IOException iOException) {
            ReportingUtils.showError(iOException);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    class TreeMouseListener
    extends MouseAdapter {
        TreeMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (2 == mouseEvent.getClickCount() && DevicesPage.this.addDevice()) {
                DevicesPage.this.rebuildDevicesTable();
            }
        }
    }

    class TreeWContextMenu
    extends JTree
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        JPopupMenu popupMenu_;
        DevicesPage dp_;

        public TreeWContextMenu(DefaultMutableTreeNode defaultMutableTreeNode, DevicesPage devicesPage2) {
            super(defaultMutableTreeNode);
            this.dp_ = devicesPage2;
            this.popupMenu_ = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Add");
            jMenuItem.setActionCommand("add");
            jMenuItem.addActionListener(this);
            this.popupMenu_.add(jMenuItem);
            jMenuItem = new JMenuItem("Help");
            jMenuItem.setActionCommand("help");
            jMenuItem.addActionListener(this);
            this.popupMenu_.add(jMenuItem);
            this.popupMenu_.setOpaque(true);
            this.popupMenu_.setLightWeightPopupEnabled(true);
            this.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        TreeWContextMenu.this.popupMenu_.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("help")) {
                this.dp_.displayDocumentation();
            } else if (actionEvent.getActionCommand().equals("add") && this.dp_.addDevice()) {
                this.dp_.rebuildDevicesTable();
            }
        }
    }

    class DeviceTable_TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"Name", "Adapter/Library", "Description", "Status"};
        MicroscopeModel model_;
        Device[] devices_;

        public DeviceTable_TableModel(MicroscopeModel microscopeModel) {
            this.setMicroscopeModel(microscopeModel);
        }

        public void setMicroscopeModel(MicroscopeModel microscopeModel) {
            this.devices_ = microscopeModel.getDevices();
            this.model_ = microscopeModel;
        }

        public int getRowCount() {
            return this.devices_.length;
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.devices_[n].getName();
            }
            if (n2 == 1) {
                return new String(this.devices_[n].getAdapterName() + "/" + this.devices_[n].getLibrary());
            }
            if (n2 == 2) {
                return this.devices_[n].getDescription();
            }
            if (this.devices_[n].isCore()) {
                return "Default";
            }
            return this.devices_[n].isInitialized() ? "OK" : "Failed";
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            String string2 = this.devices_[n].getName();
            if (n2 == 0) {
                try {
                    this.model_.changeDeviceName(string2, string);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (Exception exception) {
                    DevicesPage.this.handleError(exception.getMessage());
                }
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void refresh() {
            this.devices_ = this.model_.getDevices();
            this.fireTableDataChanged();
        }
    }
}

